/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.gadgetrepo.ui.processors;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.ui.GadgetRepoServiceClient;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.common.ServerData;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class GadgetUploadProcessor
extends AbstractFileUploadExecutor {
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        HttpSession session = request.getSession();
        String errorRedirect = null;
        try {
            Boolean created;
            GadgetRepoServiceClient client = new GadgetRepoServiceClient(cookie, serverURL, this.configurationContext, request.getLocale());
            String gName = null;
            Map formFieldsMap = this.getFormFieldsMap();
            if (formFieldsMap.get("gadgetName") != null) {
                gName = (String)((ArrayList)formFieldsMap.get("gadgetName")).get(0);
            }
            String gUrl = null;
            if (formFieldsMap.get("gadgetUrl") != null) {
                gUrl = (String)((ArrayList)formFieldsMap.get("gadgetUrl")).get(0);
            }
            String gDesc = null;
            if (formFieldsMap.get("gadgetDesc") != null) {
                gDesc = (String)((ArrayList)formFieldsMap.get("gadgetDesc")).get(0);
            }
            String formMode = null;
            if (formFieldsMap.get("mode") != null) {
                formMode = (String)((ArrayList)formFieldsMap.get("mode")).get(0);
            }
            String gadgetPath = null;
            if (formFieldsMap.get("gadgetPath") != null) {
                gadgetPath = (String)((ArrayList)formFieldsMap.get("gadgetPath")).get(0);
            }
            String redirect = null;
            if (formFieldsMap.get("redirect") != null) {
                redirect = (String)((ArrayList)formFieldsMap.get("redirect")).get(0);
            }
            if (formFieldsMap.get("errorRedirect") != null) {
                errorRedirect = (String)((ArrayList)formFieldsMap.get("errorRedirect")).get(0);
            }
            String symlinkLocation = null;
            if (formFieldsMap.get("symlinkLocation") != null) {
                symlinkLocation = (String)((ArrayList)formFieldsMap.get("symlinkLocation")).get(0);
            }
            IServerAdmin adminClient = (IServerAdmin)CarbonUIUtil.getServerProxy((Object)new ServerAdminClient(this.configurationContext, serverURL, cookie, session), IServerAdmin.class, (HttpSession)session);
            ServerData data = adminClient.getServerData();
            String chroot = "";
            if (data.getRegistryType() != null && data.getRegistryType().equals("remote") && data.getRemoteRegistryChroot() != null && !data.getRemoteRegistryChroot().equals("/")) {
                chroot = data.getRemoteRegistryChroot();
                if (!chroot.startsWith("/")) {
                    chroot = "/" + chroot;
                }
                if (chroot.endsWith("/")) {
                    chroot = chroot.substring(0, chroot.length() - "/".length());
                }
            }
            if (symlinkLocation != null) {
                symlinkLocation = chroot + symlinkLocation;
            }
            FileItemData gadgetScreenData = null;
            Map fileItemsMap = this.getFileItemsMap();
            if (fileItemsMap.get("gadgetScreen") != null) {
                gadgetScreenData = (FileItemData)((ArrayList)fileItemsMap.get("gadgetScreen")).get(0);
            }
            DataHandler gadgetThumb = null;
            if (gadgetScreenData != null) {
                gadgetThumb = gadgetScreenData.getDataHandler();
            }
            String cType = null;
            if (gadgetThumb != null) {
                cType = gadgetThumb.getContentType();
            }
            FileItemData gadgetArchive = null;
            if (fileItemsMap.get("gadget") != null) {
                gadgetArchive = (FileItemData)((ArrayList)fileItemsMap.get("gadget")).get(0);
            } else if (gUrl == null || "".equals(gUrl)) {
                String msg = "Failed add resource. Gadget URL is empty";
                log.error((Object)msg);
                if (errorRedirect == null) {
                    CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp"));
                } else {
                    CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8")));
                }
                return false;
            }
            DataHandler gadgetFile = null;
            if (gadgetArchive != null && "application/zip".equals((gadgetFile = gadgetArchive.getDataHandler()).getContentType())) {
                cType = "application/vnd.wso2.gs.gadget";
            }
            if ("add".equals(formMode)) {
                created = client.addGadgetEntryToRepo(gName, gUrl, gDesc, gadgetThumb, cType, gadgetFile);
                if (!created.booleanValue()) {
                    String msg = "Can not add Gadget " + gName + ". Please refer error log for more details.";
                    log.info((Object)msg);
                    CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp"));
                    return false;
                }
                String msg = "Gadget " + gName + " added successfully.";
                log.debug((Object)msg);
            } else if ("mod".equals(formMode)) {
                created = client.modifyGadgetEntry(gadgetPath, gName, gUrl, gDesc, gadgetThumb, cType, gadgetFile);
                if (!created.booleanValue()) {
                    String msg = "Can not modify Gadget" + gName + ". Please refer error log for more details.";
                    log.info((Object)msg);
                    CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp"));
                    return false;
                }
                String msg = "Gadget " + gName + " modified successfully.";
                log.debug((Object)msg);
            }
            response.setContentType("text/html; charset=utf-8");
            String msg = "Successfully uploaded content.";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/" + redirect + "?ordinal=0&mode=" + formMode + "&region=region1&item=gadgetrepo_menu&name=governance"));
            return true;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            if (e.getMessage() == null) {
                msg = "File upload failed. Unexpected error";
            }
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp"));
            return false;
        }
    }

    private static String calcualtePath(String parentPath, String resourceName) {
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        String resourcePath = parentPath.endsWith("/") ? parentPath + resourceName : parentPath + "/" + resourceName;
        return resourcePath;
    }
}

