/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.gadgetrepo.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.stub.GadgetRepoServiceStub;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.stub.types.carbon.Comment;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.stub.types.carbon.Gadget;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.ui.GadgetRepoUiException;

public class GadgetRepoServiceClient {
    private static final Log log = LogFactory.getLog(GadgetRepoServiceClient.class);
    GadgetRepoServiceStub stub;

    public GadgetRepoServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "GadgetRepoService";
        this.stub = new GadgetRepoServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public Boolean isSessionValid() {
        try {
            return this.stub.isSessionValid();
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean addGadgetToRepo(String gName, String gUrl, String gDesc, String gScreen, String screenMediaType) {
        try {
            return this.stub.addGadgetToRepo(gName, gUrl, gDesc, gScreen, screenMediaType);
        }
        catch (RemoteException e) {
            String errorMsg = "Error from UI (client side) : Could not add the gadget to the repository";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return null;
        }
    }

    public Gadget[] getGadgetData() {
        try {
            return this.stub.getGadgetData();
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Boolean addGadget(String userId, String tabId, String url, String dashboardName, String gadgetGroup, String gadgetPath) {
        try {
            return this.stub.addGadget(userId, tabId, url, dashboardName, gadgetGroup, gadgetPath);
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean isReadOnlyMode(String userId) {
        try {
            return this.stub.isReadOnlyMode(userId);
        }
        catch (Exception e) {
            log.error((Object)e);
            return true;
        }
    }

    public Boolean deleteGadget(String gadgetPath) {
        try {
            return this.stub.deleteGadget(gadgetPath);
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    public Gadget getGadget(String gadgetPath) {
        try {
            return this.stub.getGadget(gadgetPath);
        }
        catch (RemoteException e) {
            String errorMsg = "Error from UI (client side) : Could not load the requested gadget";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return null;
        }
    }

    public Boolean modifyGadget(String gadegtPath, String gName, String gUrl, String gDesc, String gScreen, String screenMediaType) {
        try {
            return this.stub.modifyGadget(gadegtPath, gName, gUrl, gDesc, gScreen, screenMediaType);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not modify the gadget";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }

    public Boolean addCommentForGadget(String gadgetPath, Comment comment) {
        try {
            this.stub.addCommentForGadget(gadgetPath, comment);
            return true;
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not make a comment";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }

    public Boolean addRatingForGadget(String gadgetPath, int rating, String tabId, String gadgetGroup) {
        try {
            this.stub.addRatingForGadget(gadgetPath, rating, tabId, gadgetGroup);
            return true;
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not make a comment";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }

    public Boolean deleteComment(String id) {
        try {
            this.stub.deleteComment(id);
            return true;
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not delete comment";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }

    public Boolean isAdmin(String userId) {
        try {
            return this.stub.isAdmin(userId);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : isAdmin cannot checked";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }

    public Boolean incrementUserCount(String gadgetPath) {
        try {
            return this.stub.incrementUserCount(gadgetPath);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Counter could not be incremented";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }

    public String getUserRating(String gadgetPath, String userId) {
        try {
            return this.stub.getUserRating(gadgetPath, userId);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : user rating could not be retrived";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return null;
        }
    }

    public Boolean isExternalGadgetAdditionEnabled() {
        try {
            return this.stub.isExternalGadgetAdditionEnabled();
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    public Integer getCollectionSize() {
        try {
            if (this.stub.getCollectionSize() < 0) {
                return null;
            }
            return this.stub.getCollectionSize();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public int getGadgetsPerPage() {
        return 10;
    }

    public Gadget[] getGadgetDataPag(int upper, int lower) {
        try {
            return this.stub.getGadgetDataPag(upper, lower);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Gadget[] getGadgetByName(String gadgetName) {
        try {
            Gadget[] searchGadget = this.stub.getGadgetByName(gadgetName);
            if (searchGadget[0] == null) {
                return null;
            }
            return searchGadget;
        }
        catch (RemoteException e) {
            log.error((Object)("My error" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public Comment[] getCommentSet(String resPath, int start, int size) {
        try {
            return this.stub.getCommentSet(resPath, start, size);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not load the comment set";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return null;
        }
    }

    public Integer getCommentsCount(String resPath) {
        try {
            if (this.stub.getCommentsCount(resPath) < 0) {
                return null;
            }
            return this.stub.getCommentsCount(resPath);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not get comment length";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return null;
        }
    }

    public Boolean makeGadgetDefault(String gadgetPath, Boolean isMakeDefault) {
        try {
            return this.stub.makeGadgetDefault(gadgetPath, isMakeDefault.booleanValue());
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could make the gadget a default gadget";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return null;
        }
    }

    public String[] getDefaultGadgetUrlSet() {
        try {
            return this.stub.getDefaultGadgetUrlSet();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean makeUnsignedUserGadget(String gadgetPath, Boolean isMakeUnsigned) {
        try {
            return this.stub.makeUnsignedUserGadget(gadgetPath, isMakeUnsigned.booleanValue());
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not make the gadget a unsigned_user gadget";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return null;
        }
    }

    public Boolean deleteGadgetImage(String path) {
        try {
            return this.stub.deleteGadgetImage(path);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not delete the gadget image";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return null;
        }
    }

    public String addResource(String path, String mediaType, String description, DataHandler content, String symlinkLocation) {
        return "/path";
    }

    public boolean addGadgetEntryToRepo(String gName, String gUrl, String gDesc, DataHandler gScreen, String screenMediaType, DataHandler gadgetContent) {
        try {
            return this.stub.addGadgetEntryToRepo(gName, gUrl, gDesc, gScreen, screenMediaType, gadgetContent);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not add gadget entry";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }

    public Boolean modifyGadgetEntry(String gadegtPath, String gName, String gUrl, String gDesc, DataHandler gScreen, String screenMediaType, DataHandler gadgetContent) {
        try {
            return this.stub.modifyGadgetEntry(gadegtPath, gName, gUrl, gDesc, gScreen, screenMediaType, gadgetContent);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not modify the gadget";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }

    public Boolean userHasGadget(String gadgetPath) {
        try {
            return this.stub.userHasGadget(gadgetPath);
        }
        catch (Exception e) {
            String errorMsg = "Error from UI (client side) : Could not get the user";
            log.error((Object)new GadgetRepoUiException(errorMsg, e));
            return false;
        }
    }
}

