/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.gadgetrepopopulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.gadgetrepopopulator.GadgetRepoPopulatorContext;
import org.wso2.carbon.dashboard.gadgetrepopopulator.GadgetRepoPopulatorException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;

public class GadgetRepoPopulator {
    private static final Log log = LogFactory.getLog(GadgetRepoPopulator.class);
    public static final String SYSTEM_GS_GADGETS_PATH = "/repository/gadget-server/gadgets";
    private static final String REGISTRY_SYSTEM_GADGET_REPO_ROOT = "/repository/gadget-server/gadget-repo";

    public static void populateRepo(int tenantId) {
        try {
            String resourcesDiskRoot = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "resources" + File.separator + "gadget-repo";
            String gadgetRepoConfigFile = resourcesDiskRoot + File.separator + "gadget-repo.xml";
            String gadgetsDiskLocation = resourcesDiskRoot + File.separator + "gadgets";
            Registry registry = null;
            try {
                registry = GadgetRepoPopulatorContext.getRegistry(tenantId);
            }
            catch (Throwable e) {
                throw new GadgetRepoPopulatorException("Exception occoured : " + e);
            }
            if (!registry.resourceExists(REGISTRY_SYSTEM_GADGET_REPO_ROOT)) {
                File dashboardConfigXml = new File(gadgetRepoConfigFile);
                if (dashboardConfigXml.exists()) {
                    StAXOMBuilder sab = new StAXOMBuilder((InputStream)new FileInputStream(gadgetRepoConfigFile));
                    OMElement dashboardsRootEl = sab.getDocument().getOMDocumentElement();
                    FileReader dashboardConfigXmlReader = new FileReader(dashboardConfigXml);
                    registry.restore(REGISTRY_SYSTEM_GADGET_REPO_ROOT, (Reader)dashboardConfigXmlReader);
                    log.info((Object)"Successfully populated the default Gadget Repository.");
                } else {
                    log.info((Object)("Couldn't find a Dashboard at '" + gadgetRepoConfigFile + "'. Giving up."));
                }
            }
            if (!registry.resourceExists(SYSTEM_GS_GADGETS_PATH)) {
                File gadgetsDir = new File(gadgetsDiskLocation);
                if (gadgetsDir.exists()) {
                    GadgetRepoPopulator.beginFileTansfer(gadgetsDir, tenantId);
                    log.info((Object)"Successfully added default Gadgets to Registry.");
                } else {
                    log.info((Object)("Couldn't find contents at '" + gadgetsDiskLocation + "'. Giving up."));
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to activate Gadget Repository Populator for Gadget Server bundle ", (Throwable)e);
        }
    }

    public static void beginFileTansfer(File rootDirectory, int tenantId) throws RegistryException {
        try {
            String rootPath = rootDirectory.getAbsolutePath();
            Registry registry = GadgetRepoPopulatorContext.getRegistry(tenantId);
            UserRegistry uReg = (UserRegistry)registry;
            Collection defaultGadgetCollection = registry.newCollection();
            AuthorizationManager authorizationManager = uReg.getUserRealm().getAuthorizationManager();
            authorizationManager.authorizeRole("wso2.anonymous.role", "/_system/config/repository/gadget-server/gadgets", "http://www.wso2.org/projects/registry/actions/get");
            boolean transactionStarted = Transaction.isStarted();
            try {
                if (!transactionStarted) {
                    registry.beginTransaction();
                }
                registry.put(SYSTEM_GS_GADGETS_PATH, (Resource)defaultGadgetCollection);
                GadgetRepoPopulator.transferDirectoryContentToRegistry(rootDirectory, registry, rootPath, tenantId);
                if (!transactionStarted) {
                    registry.commitTransaction();
                }
            }
            catch (Exception e) {
                if (!transactionStarted) {
                    registry.rollbackTransaction();
                }
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (GadgetRepoPopulatorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void transferDirectoryContentToRegistry(File rootDirectory, Registry registry, String rootPath, int tenantId) throws FileNotFoundException {
        try {
            File[] filesAndDirs = rootDirectory.listFiles();
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                if (!file.isFile()) {
                    String directoryRegistryPath = SYSTEM_GS_GADGETS_PATH + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
                    Collection newCollection = registry.newCollection();
                    registry.put(directoryRegistryPath, (Resource)newCollection);
                    GadgetRepoPopulator.transferDirectoryContentToRegistry(file, registry, rootPath, tenantId);
                    continue;
                }
                GadgetRepoPopulator.addToRegistry(rootPath, file, tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void addToRegistry(String rootPath, File file, int tenantId) {
        try {
            Registry registry = GadgetRepoPopulatorContext.getRegistry(tenantId);
            String fileRegistryPath = SYSTEM_GS_GADGETS_PATH + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
            Resource fileResource = registry.newResource();
            fileResource.setMediaType("application/vnd.wso2-gadget+xml");
            fileResource.setContentStream((InputStream)new FileInputStream(file));
            registry.put(fileRegistryPath, fileResource);
        }
        catch (GadgetRepoPopulatorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

