/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.MessageCollection;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.MessageService;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="messages", path="/{userId}+/{msgCollId}/{messageIds}+")
public class MessageHandler {
    private final MessageService service;

    @Inject
    public MessageHandler(MessageService service) {
        this.service = service;
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> delete(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        String msgCollId = request.getParameter("msgCollId");
        List<String> messageIds = request.getListParameter("messageIds");
        HandlerPreconditions.requireNotEmpty(userIds, "No userId specified");
        HandlerPreconditions.requireSingular(userIds, "Multiple userIds not supported");
        if (msgCollId == null) {
            throw new ProtocolException(400, "A message collection is required");
        }
        HandlerPreconditions.requireNotEmpty(messageIds, "No message IDs specified");
        UserId user = request.getUsers().iterator().next();
        return this.service.deleteMessages(user, msgCollId, messageIds, request.getToken());
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        String msgCollId = request.getParameter("msgCollId");
        List<String> messageIds = request.getListParameter("messageIds");
        CollectionOptions options = new CollectionOptions(request);
        HandlerPreconditions.requireNotEmpty(userIds, "No userId specified");
        HandlerPreconditions.requireSingular(userIds, "Multiple userIds not supported");
        UserId user = request.getUsers().iterator().next();
        if (msgCollId == null) {
            Set<String> fields = request.getFields(MessageCollection.Field.ALL_FIELDS);
            return this.service.getMessageCollections(user, fields, options, request.getToken());
        }
        Set<String> fields = request.getFields(Message.Field.ALL_FIELDS);
        return this.service.getMessages(user, msgCollId, fields, messageIds, options, request.getToken());
    }

    @Operation(httpMethods={"POST"}, bodyParam="entity")
    public Future<?> modify(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        String msgCollId = request.getParameter("msgCollId");
        List<String> messageIds = request.getListParameter("messageIds");
        HandlerPreconditions.requireNotEmpty(userIds, "No userId specified");
        HandlerPreconditions.requireSingular(userIds, "Multiple userIds not supported");
        UserId user = request.getUsers().iterator().next();
        if (msgCollId == null) {
            MessageCollection msgCollection = request.getTypedParameter("entity", MessageCollection.class);
            return this.service.createMessageCollection(user, msgCollection, request.getToken());
        }
        HandlerPreconditions.requireEmpty(messageIds, "Message IDs not allowed here, use PUT instead");
        Message message = request.getTypedParameter("entity", Message.class);
        HandlerPreconditions.requireNotEmpty(message.getRecipients(), "No recipients specified");
        return this.service.createMessage(userIds.iterator().next(), request.getAppId(), msgCollId, message, request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="entity")
    public Future<?> create(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        String msgCollId = request.getParameter("msgCollId");
        List<String> messageIds = request.getListParameter("messageIds");
        HandlerPreconditions.requireNotEmpty(userIds, "No userId specified");
        HandlerPreconditions.requireSingular(userIds, "Multiple userIds not supported");
        UserId user = request.getUsers().iterator().next();
        if (msgCollId == null) {
            throw new ProtocolException(400, "A message collection is required");
        }
        if (messageIds.isEmpty()) {
            MessageCollection msgCollection = request.getTypedParameter("entity", MessageCollection.class);
            if (msgCollection == null) {
                throw new ProtocolException(400, "cannot parse message collection");
            }
            return this.service.modifyMessageCollection(user, msgCollection, request.getToken());
        }
        HandlerPreconditions.requireSingular(messageIds, "Only one messageId at a time");
        Message message = request.getTypedParameter("entity", Message.class);
        if (message == null || message.getId() == null) {
            throw new ProtocolException(400, "cannot parse message or missing ID");
        }
        return this.service.modifyMessage(user, msgCollId, messageIds.get(0), message, request.getToken());
    }
}

