/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Substitutions {
    private final Map<String, String> substitutions = Maps.newHashMap();

    public void addSubstitution(Type type, String key, String value) {
        this.substitutions.put(type.prefix + key, value);
    }

    public String getSubstitution(Type type, String key) {
        return this.substitutions.get(type.prefix + key);
    }

    public void addSubstitutions(Type type, Map<String, String> entries) {
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            this.addSubstitution(type, entry.getKey(), entry.getValue());
        }
    }

    private void performSubstitutions(String input, StringBuilder output, boolean isNested) {
        int next;
        int i;
        int lastPosition = 0;
        while ((i = input.indexOf("__", lastPosition)) != -1 && (next = input.indexOf("__", i + 2)) != -1) {
            output.append(input.substring(lastPosition, i));
            String pattern = input.substring(i, next);
            boolean isMessage = pattern.startsWith(Type.MESSAGE.prefix);
            String replacement = isMessage && isNested ? pattern + "__" : this.substitutions.get(pattern);
            if (replacement == null) {
                output.append('_');
                lastPosition = i + 1;
                continue;
            }
            lastPosition = next + 2;
            if (isMessage && !isNested) {
                this.performSubstitutions(replacement, output, true);
                continue;
            }
            output.append(replacement);
        }
        output.append(input.substring(lastPosition));
    }

    public String substituteString(String input) {
        if (input.contains("__")) {
            StringBuilder output = new StringBuilder(input.length() * 120 / 100);
            this.performSubstitutions(input, output, false);
            return output.toString();
        }
        return input;
    }

    public Uri substituteUri(Uri uri) {
        if (uri == null) {
            return null;
        }
        try {
            return Uri.parse(this.substituteString(uri.toString()));
        }
        catch (IllegalArgumentException e) {
            return Uri.parse("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        MESSAGE("MSG"),
        BIDI("BIDI"),
        USER_PREF("UP"),
        MODULE("MODULE");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = "__" + prefix + '_';
        }
    }
}

