/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJsVersioner
implements JsUriManager.Versioner {
    private final FeatureRegistry registry;
    private final Map<List<FeatureResource>, String> versionCache;

    @Inject
    public DefaultJsVersioner(FeatureRegistry registry) {
        this.registry = registry;
        this.versionCache = Maps.newHashMap();
    }

    @Override
    public String version(Uri gadgetUri, final String container, Collection<String> extern) {
        GadgetContext ctx = new GadgetContext(){

            public String getContainer() {
                return container;
            }

            public RenderingContext getRenderingContext() {
                return RenderingContext.GADGET;
            }
        };
        List<FeatureResource> resources = this.registry.getFeatureResources(ctx, extern, null);
        if (this.versionCache.containsKey(resources)) {
            return this.versionCache.get(resources);
        }
        StringBuilder jsBuf = new StringBuilder();
        for (FeatureResource resource : resources) {
            jsBuf.append(resource.getContent()).append(resource.getDebugContent());
        }
        String checksum = HashUtil.checksum(jsBuf.toString().getBytes());
        this.versionCache.put(resources, checksum);
        return checksum;
    }

    @Override
    public UriStatus validate(Uri gadgetUri, String container, Collection<String> extern, String version) {
        if (version == null || version.length() == 0) {
            return UriStatus.VALID_UNVERSIONED;
        }
        String expectedVersion = this.version(gadgetUri, container, extern);
        if (version.equals(expectedVersion)) {
            return UriStatus.VALID_VERSIONED;
        }
        return UriStatus.INVALID_VERSION;
    }
}

