/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.parse.DefaultHtmlSerializer;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBundle {
    public static final MessageBundle EMPTY = new MessageBundle();
    private static final DefaultHtmlSerializer htmlSerializer = new DefaultHtmlSerializer();
    private final ImmutableMap<String, String> messages;
    private final String languageDirection;
    private String jsonString;

    public MessageBundle(LocaleSpec locale, String xml) throws SpecParserException {
        Element doc;
        try {
            doc = XmlUtil.parse(xml);
        }
        catch (XmlException e) {
            throw new SpecParserException("Malformed XML in file " + locale.getMessages() + ": " + e.getMessage());
        }
        this.messages = this.parseMessages(doc);
        this.languageDirection = locale.getLanguageDirection();
    }

    public MessageBundle(LocaleSpec locale, Map<String, String> map) {
        this.messages = ImmutableMap.copyOf(map);
        this.languageDirection = locale.getLanguageDirection();
    }

    public MessageBundle(Element element) throws SpecParserException {
        this.messages = this.parseMessages(element);
        this.languageDirection = XmlUtil.getAttribute(element, "language_direction", "ltr");
    }

    public MessageBundle(MessageBundle ... bundles) {
        HashMap merged = Maps.newHashMap();
        String dir = null;
        for (MessageBundle bundle : bundles) {
            merged.putAll(bundle.messages);
            dir = bundle == EMPTY ? dir : bundle.languageDirection;
        }
        this.messages = ImmutableMap.copyOf((Map)merged);
        this.languageDirection = dir != null ? dir : "ltr";
    }

    private MessageBundle() {
        this.messages = ImmutableMap.of();
        this.jsonString = "{}";
        this.languageDirection = "ltr";
    }

    public String getLanguageDirection() {
        return this.languageDirection;
    }

    public Map<String, String> getMessages() {
        return this.messages;
    }

    public String toJSONString() {
        if (this.jsonString == null) {
            this.jsonString = JsonSerializer.serialize(this.messages);
        }
        return this.jsonString;
    }

    private ImmutableMap<String, String> parseMessages(Element element) throws SpecParserException {
        NodeList nodes = element.getElementsByTagName("msg");
        HashMap messages = Maps.newHashMapWithExpectedSize((int)nodes.getLength());
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            Element msg = (Element)nodes.item(i);
            String name = XmlUtil.getAttribute(msg, "name");
            if (name == null) {
                throw new SpecParserException("All message bundle entries must have a name attribute.");
            }
            StringWriter sw = new StringWriter();
            NodeList msgChildren = msg.getChildNodes();
            for (int child = 0; child < msgChildren.getLength(); ++child) {
                try {
                    if (msgChildren.item(child).getNodeType() == 4) {
                        sw.append(msgChildren.item(child).getTextContent());
                        continue;
                    }
                    htmlSerializer.serialize(msgChildren.item(child), sw);
                    continue;
                }
                catch (IOException e) {
                    throw new SpecParserException("Unexpected error getting value of msg node", new XmlException(e));
                }
            }
            messages.put(name, sw.toString().trim());
        }
        return ImmutableMap.copyOf((Map)messages);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<messagebundle>\n");
        for (Map.Entry entry : this.messages.entrySet()) {
            buf.append("<msg name=\"").append((String)entry.getKey()).append("\">").append((String)entry.getValue()).append("</msg>\n");
        }
        buf.append("</messagebundle>");
        return buf.toString();
    }
}

