/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feature {
    public static final Feature CORE_FEATURE = new Feature("core");
    public static final Feature SECURITY_TOKEN_FEATURE = new Feature("security-token");
    private final String name;
    private final Multimap<String, String> params;
    private final boolean required;

    private Feature(String name) {
        this.params = ImmutableMultimap.of();
        this.required = true;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Multimap<String, String> getParams() {
        return this.params;
    }

    public String getParam(String key) {
        Collection values = this.params.get((Object)key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.iterator().next();
    }

    public Collection<String> getParamCollection(String key) {
        return this.params.get((Object)key);
    }

    public boolean getRequired() {
        return this.required;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.required ? "<Require" : "<Optional").append(" feature=\"").append(this.name).append("\">");
        for (Map.Entry entry : this.params.asMap().entrySet()) {
            buf.append("\n<Param name=\"").append((String)entry.getKey()).append("\">").append(entry.getValue()).append("</Param>");
        }
        buf.append(this.required ? "</Require>" : "</Optional>");
        return buf.toString();
    }

    public Feature(Element feature) throws SpecParserException {
        this.required = feature.getNodeName().equals("Require");
        String name = XmlUtil.getAttribute(feature, "feature");
        if (name == null) {
            throw new SpecParserException((this.required ? "Require" : "Optional") + "@feature is required.");
        }
        this.name = name;
        NodeList children = feature.getElementsByTagName("Param");
        if (children.getLength() > 0) {
            ImmutableMultimap.Builder params = ImmutableMultimap.builder();
            int j = children.getLength();
            for (int i = 0; i < j; ++i) {
                Element param = (Element)children.item(i);
                String paramName = XmlUtil.getAttribute(param, "name");
                if (paramName == null) {
                    throw new SpecParserException("Param@name is required");
                }
                params.put((Object)paramName, (Object)param.getTextContent());
            }
            this.params = params.build();
        } else {
            this.params = ImmutableMultimap.of();
        }
    }
}

