/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.templates.ContainerTagLibraryFactory;
import org.apache.shindig.gadgets.templates.MessageELResolver;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.TemplateLibrary;
import org.apache.shindig.gadgets.templates.TemplateLibraryFactory;
import org.apache.shindig.gadgets.templates.TemplateParserException;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.TemplateResource;
import org.apache.shindig.gadgets.templates.tags.CompositeTagRegistry;
import org.apache.shindig.gadgets.templates.tags.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.tags.TagHandler;
import org.apache.shindig.gadgets.templates.tags.TemplateBasedTagHandler;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRewriter
implements GadgetRewriter {
    public static final Set<String> TAGS = ImmutableSet.of((Object)"script");
    static final String DISABLE_AUTO_PROCESSING_PARAM = "disableAutoProcessing";
    static final String REQUIRE_LIBRARY_PARAM = "requireLibrary";
    static final String CLIENT_SUPPORT_PARAM = "client";
    private static final Logger logger = Logger.getLogger(TemplateRewriter.class.getName());
    private final Provider<TemplateProcessor> processor;
    private final MessageBundleFactory messageBundleFactory;
    private final Expressions expressions;
    private final TagRegistry baseTagRegistry;
    private final TemplateLibraryFactory libraryFactory;
    private final ContainerTagLibraryFactory containerTags;

    @Inject
    public TemplateRewriter(Provider<TemplateProcessor> processor, MessageBundleFactory messageBundleFactory, Expressions expressions, TagRegistry baseTagRegistry, TemplateLibraryFactory libraryFactory, ContainerTagLibraryFactory containerTags) {
        this.processor = processor;
        this.messageBundleFactory = messageBundleFactory;
        this.expressions = expressions;
        this.baseTagRegistry = baseTagRegistry;
        this.libraryFactory = libraryFactory;
        this.containerTags = containerTags;
    }

    @Override
    public void rewrite(Gadget gadget, MutableContent content) throws RewritingException {
        Feature f = gadget.getSpec().getModulePrefs().getFeatures().get("opensocial-templates");
        if (f != null && this.isServerTemplatingEnabled(f)) {
            try {
                this.rewriteImpl(gadget, f, content);
            }
            catch (GadgetException ge) {
                throw new RewritingException(ge, ge.getHttpStatusCode());
            }
        }
    }

    private boolean isServerTemplatingEnabled(Feature f) {
        return !"true".equalsIgnoreCase(f.getParam(DISABLE_AUTO_PROCESSING_PARAM));
    }

    private void rewriteImpl(Gadget gadget, Feature f, MutableContent content) throws GadgetException {
        ArrayList registries = Lists.newArrayList();
        ArrayList libraries = Lists.newArrayList();
        registries.add(this.baseTagRegistry);
        TemplateLibrary osmlLibrary = this.containerTags.getLibrary(gadget.getContext().getContainer());
        registries.add(osmlLibrary.getTagRegistry());
        libraries.add(osmlLibrary);
        NodeList templateElements = content.getDocument().getElementsByTagName("OSTemplate");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < templateElements.getLength(); ++i) {
            builder.add((Object)((Element)templateElements.item(i)));
        }
        ImmutableList templates = builder.build();
        registries.add(this.registerCustomTags((List<Element>)templates));
        this.loadTemplateLibraries(gadget.getContext(), f, registries, libraries);
        CompositeTagRegistry registry = new CompositeTagRegistry(registries);
        TemplateContext templateContext = new TemplateContext(gadget, content.getPipelinedData());
        boolean needsFeature = this.executeTemplates(templateContext, content, (List<Element>)templates, registry);
        String clientOverride = f.getParam(CLIENT_SUPPORT_PARAM);
        if ("true".equalsIgnoreCase(clientOverride)) {
            needsFeature = true;
        } else if ("false".equalsIgnoreCase(clientOverride)) {
            needsFeature = false;
        }
        Element head = (Element)DomUtil.getFirstNamedChildNode(content.getDocument().getDocumentElement(), "head");
        this.postProcess(templateContext, needsFeature, head, (List<Element>)templates, libraries);
    }

    private void postProcess(TemplateContext templateContext, boolean needsFeature, Element head, List<Element> allTemplates, List<TemplateLibrary> libraries) {
        for (TemplateResource resource : templateContext.getResources()) {
            this.injectTemplateLibraryAssets(resource, head);
        }
        if (!needsFeature) {
            templateContext.getGadget().removeFeature("opensocial-templates");
            for (Element template : allTemplates) {
                Node parent = template.getParentNode();
                if (parent == null) continue;
                parent.removeChild(template);
            }
        } else {
            for (TemplateLibrary library : libraries) {
                this.injectTemplateLibrary(library, head);
            }
        }
    }

    private void loadTemplateLibraries(GadgetContext context, Feature f, List<TagRegistry> registries, List<TemplateLibrary> libraries) throws GadgetException {
        Collection urls = f.getParams().get((Object)REQUIRE_LIBRARY_PARAM);
        if (urls != null) {
            for (String url : urls) {
                Uri uri = Uri.parse(url.trim());
                uri = context.getUrl().resolve(uri);
                try {
                    TemplateLibrary library = this.libraryFactory.loadTemplateLibrary(context, uri);
                    registries.add(library.getTagRegistry());
                    libraries.add(library);
                }
                catch (TemplateParserException te) {
                    logger.log(Level.WARNING, null, te);
                }
            }
        }
    }

    private void injectTemplateLibraryAssets(TemplateResource resource, Element head) {
        Element contentElement;
        switch (resource.getType()) {
            case JAVASCRIPT: {
                contentElement = head.getOwnerDocument().createElement("script");
                contentElement.setAttribute("type", "text/javascript");
                break;
            }
            case STYLE: {
                contentElement = head.getOwnerDocument().createElement("style");
                contentElement.setAttribute("type", "text/css");
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type");
            }
        }
        if (resource.isSafe()) {
            SanitizingGadgetRewriter.bypassSanitization(contentElement, false);
        }
        contentElement.setTextContent(resource.getContent());
        head.appendChild(contentElement);
    }

    private void injectTemplateLibrary(TemplateLibrary library, Element head) {
        try {
            String libraryContent = library.serialize();
            if (StringUtils.isEmpty((String)libraryContent)) {
                return;
            }
            Element scriptElement = head.getOwnerDocument().createElement("script");
            scriptElement.setAttribute("type", "text/javascript");
            StringBuilder buffer = new StringBuilder();
            buffer.append("opensocial.template.Loader.loadContent(");
            JsonSerializer.appendString(buffer, library.serialize());
            buffer.append(',');
            JsonSerializer.appendString(buffer, library.getLibraryUri().toString());
            buffer.append(");");
            scriptElement.setTextContent(buffer.toString());
            head.appendChild(scriptElement);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private TagRegistry registerCustomTags(List<Element> allTemplates) {
        ImmutableSet.Builder handlers = ImmutableSet.builder();
        for (Element template : allTemplates) {
            String namespaceUri;
            String[] nameParts;
            if (template.getAttribute("tag").length() == 0 || (nameParts = template.getAttribute("tag").split(":")).length != 2 || (namespaceUri = template.lookupNamespaceURI(nameParts[0])) == null) continue;
            handlers.add((Object)new TemplateBasedTagHandler(template, namespaceUri, nameParts[1]));
        }
        return new DefaultTagRegistry((Set<TagHandler>)handlers.build());
    }

    private boolean executeTemplates(TemplateContext templateContext, MutableContent content, List<Element> allTemplates, TagRegistry registry) throws GadgetException {
        Map<String, Object> pipelinedData = content.getPipelinedData();
        boolean needsFeature = false;
        ArrayList templates = Lists.newArrayList();
        for (Element element : allTemplates) {
            String tag = element.getAttribute("tag");
            String require = element.getAttribute("require");
            if (!TemplateRewriter.checkRequiredData(require, pipelinedData.keySet())) {
                needsFeature = true;
                continue;
            }
            if (!"".equals(tag)) continue;
            templates.add(element);
        }
        if (!templates.isEmpty()) {
            Gadget gadget = templateContext.getGadget();
            MessageBundle bundle = this.messageBundleFactory.getBundle(gadget.getSpec(), gadget.getContext().getLocale(), gadget.getContext().getIgnoreCache());
            MessageELResolver messageELResolver = new MessageELResolver(this.expressions, bundle);
            int autoUpdateID = 0;
            for (Element template : templates) {
                DocumentFragment result = ((TemplateProcessor)this.processor.get()).processTemplate(template, templateContext, messageELResolver, registry);
                if ("true".equals(template.getAttribute("autoUpdate"))) {
                    needsFeature = true;
                    Element span = template.getOwnerDocument().createElement("span");
                    String id = "template_auto" + autoUpdateID++;
                    span.setAttribute("id", "_T_" + id);
                    template.setAttribute("name", id);
                    template.getParentNode().insertBefore(span, template);
                    span.appendChild(result);
                    continue;
                }
                template.getParentNode().insertBefore(result, template);
                template.getParentNode().removeChild(template);
            }
            MutableContent.notifyEdit(content.getDocument());
        }
        return needsFeature;
    }

    private static boolean checkRequiredData(String requiredData, Set<String> availableData) {
        if ("".equals(requiredData)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(requiredData, ",");
        while (st.hasMoreTokens()) {
            if (availableData.contains(st.nextToken().trim())) continue;
            return false;
        }
        return true;
    }
}

