/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.JsonUtil;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.preload.HttpPreloader;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelinedDataPreloader {
    private final RequestPipeline requestPipeline;
    private final ContainerConfig config;
    private static Set<String> HTTP_RESPONSE_HEADERS = ImmutableSet.of((Object)"content-type", (Object)"location", (Object)"set-cookie");

    @Inject
    public PipelinedDataPreloader(RequestPipeline requestPipeline, ContainerConfig config) {
        this.requestPipeline = requestPipeline;
        this.config = config;
    }

    public Collection<Callable<PreloadedData>> createPreloadTasks(GadgetContext context, PipelinedData.Batch batch) {
        ArrayList preloadList = Lists.newArrayList();
        ArrayList socialRequest = Lists.newArrayList();
        block5: for (Map.Entry<String, PipelinedData.BatchItem> preloadEntry : batch.getPreloads().entrySet()) {
            PipelinedData.BatchItem preloadItem = preloadEntry.getValue();
            switch (preloadItem.getType()) {
                case HTTP: {
                    preloadList.add(new HttpPreloadTask(context, (RequestAuthenticationInfo)preloadItem.getData(), preloadEntry.getKey()));
                    continue block5;
                }
                case SOCIAL: {
                    socialRequest.add(preloadItem.getData());
                    continue block5;
                }
                case VARIABLE: {
                    preloadList.add(new VariableTask(preloadEntry.getKey(), preloadItem.getData()));
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown pipeline type");
        }
        if (!socialRequest.isEmpty()) {
            preloadList.add(new SocialPreloadTask(context, socialRequest));
        }
        return preloadList;
    }

    protected HttpResponse executeSocialRequest(HttpRequest request) throws GadgetException {
        return this.requestPipeline.execute(request);
    }

    static List<Object> parseSocialResponse(Collection<? extends Object> requests, String response) throws JSONException {
        ArrayList data = Lists.newArrayList();
        if (response.startsWith("[")) {
            JSONArray array = new JSONArray(response);
            for (int i = 0; i < array.length(); ++i) {
                data.add(array.get(i));
            }
        } else {
            JSONObject error = new JSONObject(response);
            for (Object object : requests) {
                JSONObject itemResponse = new JSONObject();
                itemResponse.put("error", (Object)error);
                itemResponse.put("id", JsonUtil.getProperty(object, "id"));
                data.add(itemResponse);
            }
        }
        return data;
    }

    private static JSONObject createJsonHeaders(HttpResponse response) throws JSONException {
        JSONObject headers = null;
        for (String header : HTTP_RESPONSE_HEADERS) {
            Collection<String> values = response.getHeaders(header);
            if (values == null || values.isEmpty()) continue;
            JSONArray array = new JSONArray();
            for (String value : values) {
                array.put((Object)value);
            }
            if (headers == null) {
                headers = new JSONObject();
            }
            headers.put(header, (Object)array);
        }
        return headers;
    }

    private static JSONObject createJsonError(int code, String message, HttpResponse response) throws JSONException {
        JSONObject headers;
        JSONObject error = new JSONObject();
        error.put("code", code);
        if (message != null) {
            error.put("message", (Object)message);
        }
        JSONObject data = new JSONObject();
        String responseText = response.getResponseAsString();
        if (StringUtils.isNotEmpty((String)responseText)) {
            data.put("content", (Object)responseText);
        }
        if ((headers = PipelinedDataPreloader.createJsonHeaders(response)) != null) {
            data.put("headers", (Object)headers);
        }
        if (data.length() > 0) {
            error.put("data", (Object)data);
        }
        return error;
    }

    private Uri getSocialUri(GadgetContext context, String token) {
        String jsonUri = this.config.getString(context.getContainer(), "gadgets.osDataUri");
        Preconditions.checkNotNull((Object)jsonUri, (Object)"No JSON URI available for social preloads");
        Preconditions.checkNotNull((Object)token, (Object)"No token available for social preloads");
        UriBuilder builder = UriBuilder.parse(jsonUri.replace("%host%", context.getHost())).addQueryParameter("st", token);
        return builder.toUri();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpPreloadTask
    implements Callable<PreloadedData> {
        private final GadgetContext context;
        private final RequestAuthenticationInfo preload;
        private final String key;

        public HttpPreloadTask(GadgetContext context, RequestAuthenticationInfo preload, String key) {
            this.context = context;
            this.preload = preload;
            this.key = key;
        }

        @Override
        public PreloadedData call() throws Exception {
            String params;
            String method;
            HttpRequest request = HttpPreloader.newHttpRequest(this.context, this.preload);
            String refreshIntervalStr = this.preload.getAttributes().get("refreshInterval");
            if (refreshIntervalStr != null) {
                try {
                    int refreshInterval = Integer.parseInt(refreshIntervalStr);
                    request.setCacheTtl(refreshInterval);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((method = this.preload.getAttributes().get("method")) != null) {
                request.setMethod(method);
            }
            if ((params = this.preload.getAttributes().get("params")) != null && !"".equals(params)) {
                if ("POST".equalsIgnoreCase(request.getMethod())) {
                    request.setPostBody(params.getBytes("UTF-8"));
                    request.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                } else {
                    UriBuilder uriBuilder = new UriBuilder(request.getUri());
                    String query = uriBuilder.getQuery();
                    query = query == null ? params : query + '&' + params;
                    uriBuilder.setQuery(query);
                    request.setUri(uriBuilder.toUri());
                }
            }
            return new Data(PipelinedDataPreloader.this.requestPipeline.execute(request));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Data
        implements PreloadedData {
            private final JSONObject data;

            public Data(HttpResponse response) {
                JSONObject wrapper;
                block8: {
                    String format = HttpPreloadTask.this.preload.getAttributes().get("format");
                    wrapper = new JSONObject();
                    try {
                        wrapper.put("id", (Object)HttpPreloadTask.this.key);
                        if (response.getHttpStatusCode() >= 400) {
                            wrapper.put("error", (Object)PipelinedDataPreloader.createJsonError(response.getHttpStatusCode(), null, response));
                            break block8;
                        }
                        JSONObject data = new JSONObject();
                        wrapper.put("data", (Object)data);
                        data.put("status", response.getHttpStatusCode());
                        String responseText = response.getResponseAsString();
                        JSONObject headers = PipelinedDataPreloader.createJsonHeaders(response);
                        if (headers != null) {
                            data.put("headers", (Object)headers);
                        }
                        if (format == null || "json".equals(format)) {
                            try {
                                if (responseText.startsWith("[")) {
                                    data.put("content", (Object)new JSONArray(responseText));
                                    break block8;
                                }
                                data.put("content", (Object)new JSONObject(responseText));
                            }
                            catch (JSONException je) {
                                wrapper.remove("data");
                                wrapper.put("error", (Object)PipelinedDataPreloader.createJsonError(406, je.getMessage(), response));
                            }
                            break block8;
                        }
                        data.put("content", (Object)responseText);
                    }
                    catch (JSONException outerJe) {
                        throw new RuntimeException(outerJe);
                    }
                }
                this.data = wrapper;
            }

            @Override
            public Collection<Object> toJson() {
                return ImmutableList.of((Object)this.data);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SocialPreloadTask
    implements Callable<PreloadedData> {
        private final GadgetContext context;
        private final Collection<? extends Object> socialRequests;

        public SocialPreloadTask(GadgetContext context, Collection<? extends Object> socialRequests) {
            this.context = context;
            this.socialRequests = socialRequests;
        }

        @Override
        public PreloadedData call() throws Exception {
            HttpResponse response;
            String token = this.context.getParameter("st");
            if (token == null) {
                response = new HttpResponseBuilder().setHttpStatusCode(403).setResponseString("Security token missing").create();
            } else {
                Uri uri = PipelinedDataPreloader.this.getSocialUri(this.context, token);
                String socialRequestsJson = JsonSerializer.serialize(this.socialRequests);
                HttpRequest request = new HttpRequest(uri).setIgnoreCache(this.context.getIgnoreCache()).setSecurityToken(this.context.getToken()).setMethod("POST").setAuthType(AuthType.NONE).setPostBody(CharsetUtil.getUtf8Bytes(socialRequestsJson)).addHeader("Content-Type", "application/json; charset=UTF-8").setContainer(this.context.getContainer()).setGadget(this.context.getUrl());
                response = PipelinedDataPreloader.this.executeSocialRequest(request);
            }
            String responseText = response.getHttpStatusCode() < 400 ? response.getResponseAsString() : JsonSerializer.serialize(PipelinedDataPreloader.createJsonError(response.getHttpStatusCode(), null, response));
            final List<Object> data = PipelinedDataPreloader.parseSocialResponse(this.socialRequests, responseText);
            return new PreloadedData(){

                @Override
                public Collection<Object> toJson() {
                    return data;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VariableTask
    implements Callable<PreloadedData> {
        private ImmutableMap<String, Object> result;

        public VariableTask(String key, Object data) {
            this.result = data == null ? ImmutableMap.of((Object)"id", (Object)key) : ImmutableMap.of((Object)"id", (Object)key, (Object)"data", (Object)data);
        }

        @Override
        public PreloadedData call() throws Exception {
            return new PreloadedData(){

                @Override
                public Collection<Object> toJson() throws PreloadException {
                    return ImmutableList.of((Object)VariableTask.this.result);
                }
            };
        }
    }
}

