/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerIndex;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreTokenIndex;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class BasicOAuthStore
implements OAuthStore {
    private static final String CONSUMER_SECRET_KEY = "consumer_secret";
    private static final String CONSUMER_KEY_KEY = "consumer_key";
    private static final String KEY_TYPE_KEY = "key_type";
    private static final String CALLBACK_URL = "callback_url";
    private final Map<BasicOAuthStoreConsumerIndex, BasicOAuthStoreConsumerKeyAndSecret> consumerInfos = Maps.newHashMap();
    private final Map<BasicOAuthStoreTokenIndex, OAuthStore.TokenInfo> tokens = Maps.newHashMap();
    private BasicOAuthStoreConsumerKeyAndSecret defaultKey;
    private String defaultCallbackUrl;
    private int consumerKeyLookupCount = 0;
    private int accessTokenLookupCount = 0;
    private int accessTokenAddCount = 0;
    private int accessTokenRemoveCount = 0;

    public void initFromConfigString(String oauthConfigStr) throws GadgetException {
        try {
            JSONObject oauthConfigs = new JSONObject(oauthConfigStr);
            Iterator i = oauthConfigs.keys();
            while (i.hasNext()) {
                String url = (String)i.next();
                URI gadgetUri = new URI(url);
                JSONObject oauthConfig = oauthConfigs.getJSONObject(url);
                this.storeConsumerInfos(gadgetUri, oauthConfig);
            }
        }
        catch (JSONException e) {
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, (Throwable)e);
        }
    }

    private void storeConsumerInfos(URI gadgetUri, JSONObject oauthConfig) throws JSONException, GadgetException {
        for (String serviceName : JSONObject.getNames((JSONObject)oauthConfig)) {
            JSONObject consumerInfo = oauthConfig.getJSONObject(serviceName);
            this.storeConsumerInfo(gadgetUri, serviceName, consumerInfo);
        }
    }

    private void storeConsumerInfo(URI gadgetUri, String serviceName, JSONObject consumerInfo) throws JSONException, GadgetException {
        this.realStoreConsumerInfo(gadgetUri, serviceName, consumerInfo);
    }

    private void realStoreConsumerInfo(URI gadgetUri, String serviceName, JSONObject consumerInfo) throws JSONException {
        String callbackUrl = consumerInfo.optString(CALLBACK_URL, null);
        String consumerSecret = consumerInfo.getString(CONSUMER_SECRET_KEY);
        String consumerKey = consumerInfo.getString(CONSUMER_KEY_KEY);
        String keyTypeStr = consumerInfo.getString(KEY_TYPE_KEY);
        BasicOAuthStoreConsumerKeyAndSecret.KeyType keyType = BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC;
        if (keyTypeStr.equals("RSA_PRIVATE")) {
            keyType = BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE;
            consumerSecret = BasicOAuthStore.convertFromOpenSsl(consumerSecret);
        }
        BasicOAuthStoreConsumerKeyAndSecret kas = new BasicOAuthStoreConsumerKeyAndSecret(consumerKey, consumerSecret, keyType, null, callbackUrl);
        BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
        index.setGadgetUri(gadgetUri.toASCIIString());
        index.setServiceName(serviceName);
        this.setConsumerKeyAndSecret(index, kas);
    }

    public static String convertFromOpenSsl(String privateKey) {
        return privateKey.replaceAll("-----[A-Z ]*-----", "").replace("\n", "");
    }

    public void setDefaultKey(BasicOAuthStoreConsumerKeyAndSecret defaultKey) {
        this.defaultKey = defaultKey;
    }

    public void setDefaultCallbackUrl(String defaultCallbackUrl) {
        this.defaultCallbackUrl = defaultCallbackUrl;
    }

    public void setConsumerKeyAndSecret(BasicOAuthStoreConsumerIndex providerKey, BasicOAuthStoreConsumerKeyAndSecret keyAndSecret) {
        this.consumerInfos.put(providerKey, keyAndSecret);
    }

    public OAuthStore.ConsumerInfo getConsumerKeyAndSecret(SecurityToken securityToken, String serviceName, OAuthServiceProvider provider) throws GadgetException {
        ++this.consumerKeyLookupCount;
        BasicOAuthStoreConsumerIndex pk = new BasicOAuthStoreConsumerIndex();
        pk.setGadgetUri(securityToken.getAppUrl());
        pk.setServiceName(serviceName);
        BasicOAuthStoreConsumerKeyAndSecret cks = this.consumerInfos.get(pk);
        if (cks == null) {
            cks = this.defaultKey;
        }
        if (cks == null) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "No key for gadget " + securityToken.getAppUrl() + " and service " + serviceName);
        }
        OAuthConsumer consumer = null;
        if (cks.getKeyType() == BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE) {
            consumer = new OAuthConsumer(null, cks.getConsumerKey(), null, provider);
            consumer.setProperty("oauth_signature_method", "RSA-SHA1");
            consumer.setProperty("RSA-SHA1.PrivateKey", cks.getConsumerSecret());
        } else {
            consumer = new OAuthConsumer(null, cks.getConsumerKey(), cks.getConsumerSecret(), provider);
            consumer.setProperty("oauth_signature_method", "HMAC-SHA1");
        }
        String callback = cks.getCallbackUrl() != null ? cks.getCallbackUrl() : this.defaultCallbackUrl;
        return new OAuthStore.ConsumerInfo(consumer, cks.getKeyName(), callback);
    }

    private BasicOAuthStoreTokenIndex makeBasicOAuthStoreTokenIndex(SecurityToken securityToken, String serviceName, String tokenName) {
        BasicOAuthStoreTokenIndex tokenKey = new BasicOAuthStoreTokenIndex();
        tokenKey.setGadgetUri(securityToken.getAppUrl());
        tokenKey.setModuleId(securityToken.getModuleId());
        tokenKey.setServiceName(serviceName);
        tokenKey.setTokenName(tokenName);
        tokenKey.setUserId(securityToken.getViewerId());
        return tokenKey;
    }

    public OAuthStore.TokenInfo getTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) {
        ++this.accessTokenLookupCount;
        BasicOAuthStoreTokenIndex tokenKey = this.makeBasicOAuthStoreTokenIndex(securityToken, serviceName, tokenName);
        return this.tokens.get(tokenKey);
    }

    public void setTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName, OAuthStore.TokenInfo tokenInfo) {
        ++this.accessTokenAddCount;
        BasicOAuthStoreTokenIndex tokenKey = this.makeBasicOAuthStoreTokenIndex(securityToken, serviceName, tokenName);
        this.tokens.put(tokenKey, tokenInfo);
    }

    public void removeToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) {
        ++this.accessTokenRemoveCount;
        BasicOAuthStoreTokenIndex tokenKey = this.makeBasicOAuthStoreTokenIndex(securityToken, serviceName, tokenName);
        this.tokens.remove(tokenKey);
    }

    public int getConsumerKeyLookupCount() {
        return this.consumerKeyLookupCount;
    }

    public int getAccessTokenLookupCount() {
        return this.accessTokenLookupCount;
    }

    public int getAccessTokenAddCount() {
        return this.accessTokenAddCount;
    }

    public int getAccessTokenRemoveCount() {
        return this.accessTokenRemoveCount;
    }
}

