/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.shindig.gadgets.GadgetException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeedProcessor {
    public JSONObject process(String feedUrl, String feedXml, boolean getSummaries, int numEntries) throws GadgetException {
        try {
            SyndFeed feed = new SyndFeedInput().build((Reader)new StringReader(feedXml));
            JSONObject json = new JSONObject();
            json.put("Title", (Object)feed.getTitle());
            json.put("URL", (Object)feedUrl);
            json.put("Description", (Object)feed.getDescription());
            json.put("Link", (Object)feed.getLink());
            List authors = feed.getAuthors();
            String jsonAuthor = null;
            if (authors != null && !authors.isEmpty()) {
                SyndPerson author = (SyndPerson)authors.get(0);
                if (author.getName() != null) {
                    jsonAuthor = author.getName();
                } else if (author.getEmail() != null) {
                    jsonAuthor = author.getEmail();
                }
            }
            JSONArray entries = new JSONArray();
            json.put("Entry", (Object)entries);
            int entryCnt = 0;
            for (Object obj : feed.getEntries()) {
                SyndEntry e = (SyndEntry)obj;
                if (entryCnt >= numEntries) break;
                ++entryCnt;
                JSONObject entry = new JSONObject();
                entry.put("Title", (Object)e.getTitle());
                entry.put("Link", (Object)e.getLink());
                if (getSummaries) {
                    if (e.getContents() != null && !e.getContents().isEmpty()) {
                        entry.put("Summary", (Object)((SyndContent)e.getContents().get(0)).getValue());
                    } else {
                        entry.put("Summary", (Object)(e.getDescription() != null ? e.getDescription().getValue() : ""));
                    }
                }
                if (e.getUpdatedDate() != null) {
                    entry.put("Date", e.getUpdatedDate().getTime());
                } else if (e.getPublishedDate() != null) {
                    entry.put("Date", e.getPublishedDate().getTime());
                } else {
                    entry.put("Date", 0);
                }
                if (jsonAuthor == null) {
                    jsonAuthor = e.getAuthor();
                }
                entries.put((Object)entry);
            }
            json.put("Author", (Object)(jsonAuthor != null ? jsonAuthor : ""));
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (FeedException e) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, e, 502);
        }
        catch (IllegalArgumentException e) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, e, 502);
        }
    }
}

