/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.utils;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.dao.LogsDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.LogQueue;
import org.wso2.carbon.registry.core.utils.LogRecord;

public class LogWriter
extends Thread {
    private static final Log log = LogFactory.getLog(LogWriter.class);
    private static final int DEFAULT_SLEEP_TIME = 10000;
    private LogQueue logQueue = null;
    private DataAccessManager dataAccessManager = null;

    public LogWriter(LogQueue logQueue, DataAccessManager dataAccessManager) {
        this.logQueue = logQueue;
        this.dataAccessManager = dataAccessManager;
    }

    public void setLogQueue(LogQueue logQueue) {
        this.logQueue = logQueue;
    }

    public LogQueue getLogQueue() {
        return this.logQueue;
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            if (this.logQueue != null && !this.logQueue.isEmpty() && this.dataAccessManager != null) {
                int queueLength = this.logQueue.size();
                LogRecord[] logRecords = new LogRecord[queueLength];
                for (int a = 0; a < queueLength; ++a) {
                    LogRecord logRecord;
                    logRecords[a] = logRecord = (LogRecord)this.logQueue.poll();
                }
                LogsDAO logsDAO = this.dataAccessManager.getDAOManager().getLogsDAO();
                try {
                    logsDAO.saveLogBatch(logRecords);
                }
                catch (RegistryException e) {
                    log.error((Object)"Unable to save log records", (Throwable)((Object)e));
                }
            } else if (this.isInterrupted()) return;
            try {
                LogWriter.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                if (this.logQueue == null || this.logQueue.isEmpty()) return;
                continue;
            }
            break;
        }
    }

    public void addLog(String resourcePath, String userName, int action, String actionData) throws RegistryException {
        if (this.logQueue != null) {
            String temp;
            LogRecord logRecord = new LogRecord();
            if (CurrentSession.getLocalPathMap() != null && (temp = CurrentSession.getLocalPathMap().get(resourcePath)) != null) {
                resourcePath = temp;
            }
            logRecord.setResourcePath(resourcePath);
            logRecord.setUserName(userName);
            logRecord.setTimestamp(new Date(System.currentTimeMillis()));
            logRecord.setAction(action);
            logRecord.setActionData(actionData);
            logRecord.setTenantId(CurrentSession.getTenantId());
            this.logQueue.add(logRecord);
        }
    }
}

