/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.dao.ResourceVersionDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataobjects.ResourceDO;
import org.wso2.carbon.registry.core.jdbc.utils.VersionRetriever;

public class CollectionVersionImpl
extends CollectionImpl {
    private ResourceVersionDAO resourceVersionDAO;
    private VersionRetriever versionList;
    private int versionListIndex = 0;
    private static final Log log = LogFactory.getLog(CollectionVersionImpl.class);

    public CollectionVersionImpl() {
        if (this.dataAccessManager != null) {
            this.resourceVersionDAO = this.dataAccessManager.getDAOManager().getResourceVersionDAO();
        }
    }

    public CollectionVersionImpl(String path, ResourceDO resourceDO) {
        super(path, resourceDO);
        if (this.dataAccessManager != null) {
            this.resourceVersionDAO = this.dataAccessManager.getDAOManager().getResourceVersionDAO();
        }
    }

    public CollectionVersionImpl(CollectionVersionImpl collection) {
        super(collection);
        this.versionList = collection.versionList;
        this.versionListIndex = collection.versionListIndex;
        this.resourceVersionDAO = collection.resourceVersionDAO;
    }

    @Override
    public void setDataAccessManager(DataAccessManager dataAccessManager) {
        super.setDataAccessManager(dataAccessManager);
        if (dataAccessManager != null) {
            this.resourceVersionDAO = dataAccessManager.getDAOManager().getResourceVersionDAO();
        }
    }

    public void setVersionList(VersionRetriever versionList) {
        this.versionList = versionList;
    }

    public void setVersionListIndex(int versionListIndex) {
        this.versionListIndex = versionListIndex;
    }

    @Override
    public String[] getChildren() throws RegistryException {
        if (this.getContent() instanceof String[]) {
            return this.fixPaths((String[])this.getContent());
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getChildren(int start, int pageLen) throws RegistryException {
        this.setSessionInformation();
        try {
            this.pullContentFromOriginal();
            if (this.content != null && this.content instanceof String[]) {
                String[] childNodes = (String[])this.content;
                int limit = start + pageLen;
                if (start > childNodes.length) {
                    String[] stringArray = new String[]{};
                    return stringArray;
                }
                if (limit > childNodes.length) {
                    limit = childNodes.length;
                }
                String[] stringArray = this.fixPaths(Arrays.copyOfRange(childNodes, start, limit));
                return stringArray;
            }
            if (this.resourceVersionDAO == null) {
                String msg = "The data access object for versioned resources has not been created.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            String[] stringArray = this.fixPaths(this.resourceVersionDAO.getChildPaths(this.getResourceIDImpl(), this.versionList, this.versionListIndex, start, pageLen, this.snapshotID, this.dataAccessManager));
            return stringArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public int getChildCount() throws RegistryException {
        this.pullContentFromOriginal();
        if (this.content != null) {
            String[] childPaths = (String[])this.content;
            return this.fixPaths(childPaths).length;
        }
        String[] childPaths = this.getChildren(0, -1);
        if (childPaths == null) {
            return 0;
        }
        return childPaths.length;
    }

    @Override
    public Object getContent() throws RegistryException {
        this.pullContentFromOriginal();
        if (this.content == null) {
            String[] childPaths = this.getChildren(0, -1);
            this.setContentWithNoUpdate(childPaths);
        }
        return this.content;
    }
}

