/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.dashboard.DashboardService;
import org.wso2.carbon.dashboard.bean.DashboardContentBean;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.dashboard.common.LayoutConstants;
import org.wso2.carbon.dashboard.common.bean.Gadget;
import org.wso2.carbon.dashboard.common.bean.Tab;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class DashboardDSService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DashboardService.class);

    public Boolean setGadgetPrefs(String userId, String gadgetId, String prefId, String value, String dashboardName) {
        Boolean response;
        block2: {
            response = false;
            try {
                Registry registry = this.getConfigSystemRegistry();
                String gadgetPrefPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId + DashboardConstants.GADGET_PREFERENCE_PATH + prefId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId + DashboardConstants.GADGET_PREFERENCE_PATH + prefId;
                Resource gadgetPreferences = registry.resourceExists(gadgetPrefPath) ? registry.get(gadgetPrefPath) : registry.newResource();
                gadgetPreferences.setContent((Object)value);
                gadgetPreferences.setMediaType("text/html");
                registry.put(gadgetPrefPath, gadgetPreferences);
                response = true;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Failed to set preferences for user " + userId + " for prefId " + prefId), (Throwable)e);
            }
        }
        return response;
    }

    public String getGadgetPrefs(String userId, String gadgetId, String prefId, String dashboardName) {
        String response;
        block2: {
            response = "NA";
            try {
                Registry registry = this.getConfigSystemRegistry();
                String gadgetPrefPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId + DashboardConstants.GADGET_PREFERENCE_PATH + prefId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId + DashboardConstants.GADGET_PREFERENCE_PATH + prefId;
                Resource gadgetPreferences = registry.get(gadgetPrefPath);
                response = new String((byte[])gadgetPreferences.getContent());
                response = new String(Hex.decodeHex((char[])response.toCharArray()));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Preferences were not found for user " + userId + " for prefId " + prefId), (Throwable)e);
            }
        }
        return response;
    }

    public Boolean setGadgetLayout(String userId, String tabId, String newLayout, String dashboardName) {
        Boolean response = false;
        try {
            Registry registry = this.getConfigSystemRegistry();
            String gadgetLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH;
            Object gadgetLayout = registry.resourceExists(gadgetLayoutPath) ? registry.get(gadgetLayoutPath) : registry.newCollection();
            gadgetLayout.setProperty(DashboardConstants.CURRENT_GADGET_LAYOUT, newLayout);
            registry.put(gadgetLayoutPath, (Resource)gadgetLayout);
            response = true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to set new layout for user " + userId + " for layout info [" + newLayout + "]"), (Throwable)e);
        }
        return response;
    }

    public String getGadgetLayout(String userId, String tabId, String dashboardName) {
        String response;
        try {
            Collection gadgetLayout;
            Registry registry = this.getConfigSystemRegistry();
            String gadgetLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH;
            if (registry.resourceExists(gadgetLayoutPath)) {
                gadgetLayout = registry.get(gadgetLayoutPath);
            } else {
                gadgetLayout = registry.newCollection();
                registry.put(gadgetLayoutPath, (Resource)gadgetLayout);
            }
            response = gadgetLayout.getProperty(DashboardConstants.CURRENT_GADGET_LAYOUT);
            if (response == null || "".equals(response)) {
                response = "NA";
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get layout information for user " + userId), (Throwable)e);
            response = "NA";
        }
        return response;
    }

    public String getTabLayout(String userId, String dashboardName) {
        String response = "0";
        try {
            Registry registry = this.getConfigSystemRegistry();
            String tabLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH;
            Object gadgetLayout = registry.resourceExists(tabLayoutPath) ? registry.get(tabLayoutPath) : registry.newCollection();
            response = gadgetLayout.getProperty(DashboardConstants.CURRENT_TAB_LAYOUT);
            if (response == null) {
                gadgetLayout.setProperty(DashboardConstants.CURRENT_TAB_LAYOUT, "0");
                registry.put(tabLayoutPath, (Resource)gadgetLayout);
                response = "0";
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get layout information for user " + userId), (Throwable)e);
        }
        return response;
    }

    private void getGadgetIdsFromJsonLayout(JSONArray layouts, ArrayList IdStore) throws JSONException {
        for (int x = 0; x < layouts.length(); ++x) {
            JSONObject currentLayoutObject = layouts.getJSONObject(x);
            if (currentLayoutObject.getString("type").equalsIgnoreCase("gadget")) {
                IdStore.add(currentLayoutObject.getString("id"));
                continue;
            }
            this.getGadgetIdsFromJsonLayout(currentLayoutObject.getJSONArray("layout"), IdStore);
        }
    }

    private boolean isGadgetAutharized(String user, String gadgetUrl) throws UserStoreException {
        if (!gadgetUrl.startsWith("/registry")) {
            return true;
        }
        gadgetUrl = gadgetUrl.split("resource")[1];
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        if (registry == null) {
            registry = (UserRegistry)this.getConfigSystemRegistry();
        }
        return registry.getUserRealm().getAuthorizationManager().isUserAuthorized(user, gadgetUrl, "http://www.wso2.org/projects/registry/actions/get");
    }

    public String[] getGadgetUrlsToLayout(String userId, String tabId, String dashboardName, String backendServerURL) throws AxisFault {
        try {
            ArrayList<String> gadgetIdStore = new ArrayList<String>();
            String storedLayout = this.getGadgetLayout(userId, tabId, dashboardName);
            if ("NA".equalsIgnoreCase(storedLayout)) {
                return null;
            }
            if (storedLayout.contains("G1#")) {
                String[] columnIdCombos = storedLayout.split(",");
                for (int x = 0; x < columnIdCombos.length; ++x) {
                    String currentId = columnIdCombos[x].split("#")[1];
                    if (currentId == null || "".equals(currentId)) continue;
                    gadgetIdStore.add(currentId);
                }
            } else {
                this.getGadgetIdsFromJsonLayout(new JSONObject(storedLayout).getJSONArray("layout"), gadgetIdStore);
            }
            Registry registry = this.getConfigSystemRegistry();
            ArrayList<String> gadgetUrlsList = new ArrayList<String>();
            String[] indGadgetIds = new String[gadgetIdStore.size()];
            gadgetIdStore.toArray(indGadgetIds);
            for (String indGadgetId : indGadgetIds) {
                String gadgetPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + indGadgetId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + indGadgetId;
                try {
                    Resource currentGadget = registry.get(gadgetPath);
                    String gadgetUrlTmp = currentGadget.getProperty(DashboardConstants.GADGET_URL);
                    if (!this.isGadgetAutharized(userId, gadgetUrlTmp)) continue;
                    gadgetUrlsList.add(gadgetUrlTmp);
                }
                catch (RegistryException e) {
                    this.removeGadgetFromLayout(userId, tabId, indGadgetId, dashboardName);
                }
            }
            String[] gadgetUrls = new String[gadgetUrlsList.size()];
            gadgetUrlsList.toArray(gadgetUrls);
            if (gadgetUrls.length > 0) {
                gadgetUrls = this.sanitizeUrls(gadgetUrls, backendServerURL);
            }
            return gadgetUrls;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while parsing the gadget urls to the layout : ", (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    private void removeGadgetFromLayout(String userId, String tabId, String gadgetId, String dashboardName) throws JSONException {
        JSONObject storedLayout = new JSONObject(this.getGadgetLayout(userId, tabId, dashboardName));
        JSONArray layoutsArray = storedLayout.getJSONArray("layout");
        if (layoutsArray != null && layoutsArray.length() > 0) {
            JSONArray modifiedLayoutsArray = this.searchAndRemoveGadgetFromLayout(gadgetId, layoutsArray);
            storedLayout.put("layout", (Object)modifiedLayoutsArray);
            String newLayout = storedLayout.toString();
            this.setGadgetLayout(userId, tabId, newLayout, dashboardName);
        }
    }

    private JSONArray searchAndRemoveGadgetFromLayout(String gadgetId, JSONArray layoutsArray) throws JSONException {
        JSONArray modifiedLayoutsArray = new JSONArray();
        for (int x = 0; x < layoutsArray.length(); ++x) {
            JSONObject currentLayoutElement = (JSONObject)layoutsArray.get(x);
            if ("gadget".equals(currentLayoutElement.get("type"))) {
                if (gadgetId.equals(currentLayoutElement.get("id"))) continue;
                modifiedLayoutsArray.put((Object)currentLayoutElement);
                continue;
            }
            currentLayoutElement.put("layout", (Object)this.searchAndRemoveGadgetFromLayout(gadgetId, currentLayoutElement.getJSONArray("layout")));
            modifiedLayoutsArray.put((Object)currentLayoutElement);
        }
        return modifiedLayoutsArray;
    }

    public Boolean addGadgetToUser(String userId, String tabId, String url, String dashboardName, String gadgetGroup) {
        Boolean response;
        block11: {
            response = false;
            Registry registry = null;
            try {
                if (!this.isGadgetAutharized(userId, url)) {
                    return false;
                }
                registry = this.getConfigSystemRegistry();
                registry.beginTransaction();
                String gadgetId = this.addGadgetToRegistry(userId, url, dashboardName, registry);
                String gadgetLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH;
                Object gadgetLayout = registry.resourceExists(gadgetLayoutPath) ? registry.get(gadgetLayoutPath) : registry.newCollection();
                HashMap<Integer, Integer> gadgets = new HashMap<Integer, Integer>();
                String layout = this.getGadgetLayout(userId, tabId, dashboardName);
                if (layout.equals("NA")) {
                    layout = "{layout:[]}";
                }
                LinkedHashMap map = new LinkedHashMap();
                JSONObject json = null;
                try {
                    json = new JSONObject(layout);
                }
                catch (Exception e) {
                    log.error((Object)"JSONParser unsuccessful : ", (Throwable)e);
                }
                for (int i = 0; i < json.getJSONArray("layout").length(); ++i) {
                    JSONArray numberOfGadgetsInColumn = json.getJSONArray("layout").getJSONObject(i).getJSONArray("layout");
                    gadgets.put(i, numberOfGadgetsInColumn.length());
                }
                ArrayList mapKeys = new ArrayList(gadgets.keySet());
                ArrayList mapValues = new ArrayList(gadgets.values());
                TreeSet sortedSet = new TreeSet(mapValues);
                Object[] sortedArray = sortedSet.toArray();
                int size = sortedArray.length;
                for (int i = 0; i < size; ++i) {
                    map.put(mapKeys.get(mapValues.indexOf(sortedArray[i])), Integer.parseInt(sortedArray[i].toString()));
                }
                ArrayList ref = new ArrayList(((HashMap)map).keySet());
                String currentLayout = gadgetLayout.getProperty(DashboardConstants.CURRENT_GADGET_LAYOUT);
                int colNum = 0;
                if (ref.size() != 0) {
                    colNum = (Integer)ref.get(0);
                }
                gadgetLayout.setProperty(DashboardConstants.CURRENT_GADGET_LAYOUT, this.insertGadgetToJsonLayout(currentLayout, gadgetId, colNum).toString());
                registry.put(gadgetLayoutPath, (Resource)gadgetLayout);
                response = true;
                registry.commitTransaction();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block11;
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)e);
                }
            }
        }
        return response;
    }

    private String addGadgetToRegistry(String userId, String url, String dashboardName, Registry registry) throws RegistryException {
        String nextGadgetIdPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.NEXT_GADGET_ID_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.NEXT_GADGET_ID_PATH;
        Object nextGadgetIdResource = registry.resourceExists(nextGadgetIdPath) ? registry.get(nextGadgetIdPath) : registry.newCollection();
        String gadgetId = "0";
        if (nextGadgetIdResource.getProperty(DashboardConstants.NEXT_GADGET_ID) != null) {
            gadgetId = nextGadgetIdResource.getProperty(DashboardConstants.NEXT_GADGET_ID);
        }
        int nextGadgetId = Integer.parseInt(gadgetId) + 1;
        nextGadgetIdResource.setProperty(DashboardConstants.NEXT_GADGET_ID, String.valueOf(nextGadgetId));
        registry.put(nextGadgetIdPath, (Resource)nextGadgetIdResource);
        String newGadgetPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId;
        Object newGadgetResource = registry.resourceExists(newGadgetPath) ? registry.get(newGadgetPath) : registry.newCollection();
        newGadgetResource.setProperty(DashboardConstants.GADGET_URL, url);
        registry.put(newGadgetPath, (Resource)newGadgetResource);
        return gadgetId;
    }

    private JSONObject insertGadgetToJsonLayout(String layout, String gadgetId, int columnNumber) throws JSONException {
        if (layout == null || "".equals(layout)) {
            String twoColumnTemplate = "{\n    \"layout\":\n            [\n                {\n                    \"type\": \"columnContainer\",\n                    \"width\": \"33%\",\n                    \"layout\":\n                            [\n                                {\n                                    \"type\": \"gadget\",\n                                    \"id\": \"" + gadgetId + "\"\n" + "                                }\n" + "                            ]\n" + "                },\n" + "                {\n" + "                    \"type\": \"columnContainer\",\n" + "                    \"width\": \"67%\",\n" + "                    \"layout\":\n" + "                            [\n" + "\n" + "                            ]\n" + "                }\n" + "            ]\n" + "}";
            return new JSONObject(twoColumnTemplate);
        }
        JSONObject currentLayout = new JSONObject(layout);
        JSONObject newGadget = new JSONObject();
        newGadget.put("type", (Object)"gadget");
        newGadget.put("id", (Object)gadgetId);
        JSONArray firstContainersLayoutArray = currentLayout.getJSONArray("layout").getJSONObject(columnNumber).getJSONArray("layout");
        firstContainersLayoutArray.put(firstContainersLayoutArray.length(), (Object)newGadget);
        return currentLayout;
    }

    private String getGadgetUrl(String userId, String gadgetId, String dashboardName) {
        String gadgetUrl = null;
        String gadgetPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId;
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource gadgetRes = registry.get(gadgetPath);
            gadgetUrl = gadgetRes.getProperty(DashboardConstants.GADGET_URL);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return gadgetUrl;
    }

    public Boolean removeGadget(String userId, String tabId, String gadgetId, String dashboardName) {
        Boolean response;
        block4: {
            response = false;
            Registry registry = null;
            try {
                registry = this.getConfigSystemRegistry();
                registry.beginTransaction();
                this.removeGadgetFromLayout(userId, tabId, gadgetId, dashboardName);
                String gadgetPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId;
                registry.delete(gadgetPath);
                response = true;
                registry.commitTransaction();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block4;
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)e);
                }
            }
        }
        return response;
    }

    public Integer addNewTab(String userId, String tabTitle, String dashboardName) {
        Integer response;
        block8: {
            response = 0;
            String dashboardTabPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH;
            Registry registry = null;
            try {
                registry = this.getConfigSystemRegistry();
                registry.beginTransaction();
                Resource userTabResource = null;
                if (registry.resourceExists(dashboardTabPath)) {
                    userTabResource = registry.get(dashboardTabPath);
                } else {
                    registry.put(dashboardTabPath, (Resource)registry.newCollection());
                    userTabResource = registry.get(dashboardTabPath);
                }
                String nextTabId = userTabResource.getProperty(DashboardConstants.NEXT_TAB_ID);
                if (nextTabId == null) {
                    nextTabId = "0";
                }
                userTabResource.setProperty(DashboardConstants.NEXT_TAB_ID, String.valueOf(Integer.parseInt(nextTabId) + 1));
                registry.put(dashboardTabPath, userTabResource);
                Collection newTab = registry.newCollection();
                if ("".equals(tabTitle)) {
                    tabTitle = "Tab " + nextTabId;
                }
                newTab.setProperty(DashboardConstants.TAB_TITLE, tabTitle);
                String newTabPath = dashboardTabPath + nextTabId;
                registry.put(newTabPath, (Resource)newTab);
                String currentTabLayout = userTabResource.getProperty(DashboardConstants.CURRENT_TAB_LAYOUT);
                currentTabLayout = null == currentTabLayout || "null".equals(currentTabLayout) || "0".equalsIgnoreCase(currentTabLayout) && "0".equals(nextTabId) ? String.valueOf(nextTabId) : currentTabLayout + "," + String.valueOf(nextTabId);
                userTabResource.setProperty(DashboardConstants.CURRENT_TAB_LAYOUT, currentTabLayout);
                registry.put(dashboardTabPath, userTabResource);
                response = Integer.parseInt(nextTabId);
                registry.commitTransaction();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block8;
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)e);
                }
            }
        }
        return response;
    }

    private void addHomeTab(String userId, String dashboardName) {
        block5: {
            Integer response = 0;
            String dashboardTabPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH;
            Registry registry = null;
            try {
                registry = this.getConfigSystemRegistry();
                registry.beginTransaction();
                Resource userTabResource = null;
                if (registry.resourceExists(dashboardTabPath)) {
                    userTabResource = registry.get(dashboardTabPath);
                }
                String nextTabId = "0";
                Collection newTab = registry.newCollection();
                String tabTitle = "Tab " + nextTabId;
                newTab.setProperty(DashboardConstants.TAB_TITLE, tabTitle);
                String newTabPath = dashboardTabPath + nextTabId;
                registry.put(newTabPath, (Resource)newTab);
                String currentTabLayout = userTabResource.getProperty(DashboardConstants.CURRENT_TAB_LAYOUT);
                currentTabLayout = null == currentTabLayout || "null".equals(currentTabLayout) ? String.valueOf(nextTabId) : currentTabLayout + "," + String.valueOf(nextTabId);
                userTabResource.setProperty(DashboardConstants.CURRENT_TAB_LAYOUT, currentTabLayout);
                registry.put(dashboardTabPath, userTabResource);
                response = Integer.parseInt(nextTabId);
                registry.commitTransaction();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block5;
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String getTabTitle(String userId, String tabId, String dashboardName) {
        String response = "Tab " + tabId;
        String tabPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId;
        try {
            Registry registry = this.getConfigSystemRegistry();
            if ("0".equals(tabId) && (!registry.resourceExists(tabPath) || registry.get(tabPath).getProperty(DashboardConstants.TAB_TITLE) == null)) {
                return "Home";
            }
            Resource tabResource = registry.get(tabPath);
            if (tabResource.getProperty(DashboardConstants.TAB_TITLE) != null) {
                return tabResource.getProperty(DashboardConstants.TAB_TITLE);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public Boolean removeTab(String userId, String tabId, String dashboardName) {
        Boolean response;
        block11: {
            response = false;
            String dashboardTabPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH;
            Registry registry = null;
            boolean transactionStarted = false;
            try {
                registry = this.getConfigSystemRegistry();
                if (!Transaction.isStarted()) {
                    registry.beginTransaction();
                    transactionStarted = true;
                }
                Resource userTabResource = registry.get(dashboardTabPath);
                String currentTabLayout = userTabResource.getProperty(DashboardConstants.CURRENT_TAB_LAYOUT);
                String[] tabIds = currentTabLayout.split(",");
                String newTabLayout = "";
                for (String tabId1 : tabIds) {
                    if (tabId1.equals(tabId)) continue;
                    newTabLayout = newTabLayout.equals("") ? tabId1 : newTabLayout + "," + tabId1;
                }
                userTabResource.setProperty(DashboardConstants.CURRENT_TAB_LAYOUT, newTabLayout);
                registry.put(dashboardTabPath, userTabResource);
                JSONObject currentLayout = new JSONObject(this.getGadgetLayout(userId, tabId, dashboardName));
                JSONArray layoutElements = currentLayout.getJSONArray("layout");
                ArrayList gadgetIdStore = new ArrayList();
                this.getGadgetIdsFromJsonLayout(layoutElements, gadgetIdStore);
                if (gadgetIdStore.size() > 0) {
                    String[] gadgetList = new String[gadgetIdStore.size()];
                    gadgetIdStore.toArray(gadgetList);
                    for (int x = 0; x < gadgetList.length; ++x) {
                        this.removeGadget(userId, tabId, gadgetList[x], dashboardName);
                    }
                }
                String tabPath = dashboardTabPath + tabId;
                registry.delete(tabPath);
                response = true;
                if (transactionStarted) {
                    registry.commitTransaction();
                }
                if ("0".equals(tabId)) {
                    this.addHomeTab(userId, dashboardName);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block11;
                try {
                    if (transactionStarted) {
                        registry.rollbackTransaction();
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return response;
    }

    public Boolean isReadOnlyMode(String userId) {
        if (userId == null || "null".equals(userId)) {
            return true;
        }
        Boolean resp = true;
        try {
            String[] userRoles = this.getUserRealm().getUserStoreManager().getRoleListOfUser(userId);
            for (int x = 0; x < userRoles.length; ++x) {
                if (!"admin".equals(userRoles[x])) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return resp;
    }

    public String getBackendHttpPort() {
        String httpPort = null;
        try {
            int port = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            if (port == -1) {
                port = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            }
            httpPort = Integer.toString(port);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return httpPort;
    }

    public Boolean isSelfRegistrationEnabled() {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.USER_SELF_REG_PROPERTY_ID)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public Boolean isExternalGadgetAdditionEnabled() {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.USER_EXTERNAL_GADGET_ADD_PROPERTY_ID)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public String[] getDefaultGadgetUrlSet(String userId) throws AxisFault {
        try {
            if (this.isOldUser(userId).booleanValue()) {
                return new String[0];
            }
            Registry registry = this.getConfigSystemRegistry();
            String sql = "SELECT R.REG_NAME, R.REG_PATH_ID FROM REG_RESOURCE R, REG_PROPERTY P, REG_RESOURCE_PROPERTY RP, REG_PATH PA WHERE R.REG_VERSION=RP.REG_VERSION AND P.REG_NAME='" + DashboardConstants.DEFAULT_GADGET + "' AND " + "P.REG_VALUE='true' AND " + "P.REG_ID=RP.REG_PROPERTY_ID AND " + "PA.REG_PATH_ID=R.REG_PATH_ID";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("query", sql);
            Collection qResults = registry.executeQuery(DashboardConstants.SQL_STATEMENTS_PATH + "/query3", map);
            String[] qPaths = (String[])qResults.getContent();
            ArrayList<String> gadgetUrlsList = new ArrayList<String>();
            for (String qPath : qPaths) {
                Resource tempRes;
                String gadgetUrlTmp;
                if (!registry.resourceExists(qPath) || !this.isGadgetAutharized(userId, gadgetUrlTmp = (tempRes = registry.get(qPath)).getProperty(DashboardConstants.GADGET_URL))) continue;
                gadgetUrlsList.add(gadgetUrlTmp);
                try {
                    Integer userCount = Integer.parseInt(tempRes.getProperty(DashboardConstants.USER_CONTER));
                    userCount = userCount + 1;
                    tempRes.setProperty(DashboardConstants.USER_CONTER, userCount.toString());
                    registry.put(qPath, tempRes);
                }
                catch (Exception e) {
                    log.error((Object)("could not increment the user count :" + e.getMessage()));
                }
            }
            String[] gadgetUrls = new String[gadgetUrlsList.size()];
            gadgetUrlsList.toArray(gadgetUrls);
            return gadgetUrls;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could not get the default gadget url set", (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    private String getHttpServerRoot(String backendServerURL) {
        String response = "";
        try {
            String hostName = CarbonUtils.getServerConfiguration().getFirstProperty("HostName");
            response = backendServerURL.split("/carbon/")[0];
            URL newUrl = new URL(response);
            response = "".equals(newUrl.getPath()) ? "http://" + newUrl.getHost() + ":" + this.getBackendHttpPort() : "http://" + newUrl.getHost() + ":" + this.getBackendHttpPort() + newUrl.getPath();
            if (hostName != null && !hostName.equals("")) {
                response = !"".equals(newUrl.getPath()) ? "http://" + hostName + ":" + this.getBackendHttpPort() + newUrl.getPath() : "http://" + hostName + ":" + this.getBackendHttpPort();
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    private String[] sanitizeUrls(String[] gadgetUrls, String backendServerURL) {
        String[] response = new String[]{};
        String tDomain = this.getTenantDomain();
        String tPathWithDOmain = "";
        if (!"carbon.super".equals(tDomain)) {
            tPathWithDOmain = "/t/" + tDomain;
        }
        if (gadgetUrls != null) {
            ArrayList<String> tempUrlHolder = new ArrayList<String>();
            for (String currentUrl : gadgetUrls) {
                if ("/".equals(String.valueOf((currentUrl = currentUrl.replaceAll("[\r\n]", "").trim()).charAt(0)))) {
                    currentUrl = this.getHttpServerRoot(backendServerURL) + tPathWithDOmain + currentUrl;
                }
                tempUrlHolder.add(currentUrl);
            }
            response = new String[tempUrlHolder.size()];
            tempUrlHolder.toArray(response);
        }
        return response;
    }

    public Integer duplicateTab(String userId, String dashboardName, String sourceTabId, String newTabName) {
        int resp = 0;
        String newTabId = String.valueOf(this.addNewTab(userId, newTabName, dashboardName));
        try {
            Registry registry = this.getConfigSystemRegistry();
            JSONObject sourceGadgetLayout = new JSONObject(this.getGadgetLayout(userId, sourceTabId, dashboardName));
            JSONArray layoutElements = sourceGadgetLayout.getJSONArray("layout");
            JSONArray gadgetDuplicatedLayoutElements = this.duplicateGadgetsInLayout(userId, dashboardName, registry, layoutElements);
            sourceGadgetLayout.put("layout", (Object)gadgetDuplicatedLayoutElements);
            this.setGadgetLayout(userId, newTabId, sourceGadgetLayout.toString(), dashboardName);
            return Integer.parseInt(newTabId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            resp = 0;
            return resp;
        }
    }

    private JSONArray duplicateGadgetsInLayout(String userId, String dashboardName, Registry registry, JSONArray layoutElements) throws JSONException, RegistryException {
        for (int x = 0; x < layoutElements.length(); ++x) {
            JSONObject currentLayoutElement = (JSONObject)layoutElements.get(x);
            if ("gadget".equals(currentLayoutElement.get("type"))) {
                String sourceGadgetsId = currentLayoutElement.get("id").toString();
                if (sourceGadgetsId == null || "".equals(sourceGadgetsId)) continue;
                String duplicatesId = this.addGadgetToRegistry(userId, this.getGadgetUrl(userId, sourceGadgetsId, dashboardName), dashboardName, registry);
                currentLayoutElement.put("id", (Object)duplicatesId);
                continue;
            }
            this.duplicateGadgetsInLayout(userId, dashboardName, registry, currentLayoutElement.getJSONArray("layout"));
        }
        return layoutElements;
    }

    public Boolean copyGadget(String userId, String dashboardName, String sourceGadgetId, String tab, String grp) {
        String gadgetUrl = this.getGadgetUrl(userId, sourceGadgetId, dashboardName);
        Boolean resp = this.addGadgetToUser(userId, tab, gadgetUrl, dashboardName, grp);
        return resp;
    }

    public Boolean moveGadgetToTab(String userId, String dashboardName, String sourceGadgetId, String tab) {
        String gadgetUrl = this.getGadgetUrl(userId, sourceGadgetId, dashboardName);
        Boolean resp = this.addGadgetToUser(userId, tab, gadgetUrl, dashboardName, "G1#");
        return resp;
    }

    private Boolean tabNameExsists(String tabName, String userId) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource comQuery = registry.newResource();
            String sql = "SELECT R.REG_NAME, R.REG_PATH_ID FROM REG_RESOURCE R, REG_PROPERTY P, REG_RESOURCE_PROPERTY RP, REG_PATH PA WHERE R.REG_VERSION=RP.REG_VERSION AND P.REG_NAME='tabTitle' AND P.REG_VALUE LIKE ? AND P.REG_ID=RP.REG_PROPERTY_ID AND PA.REG_PATH_ID=R.REG_PATH_ID AND PA.REG_PATH_VALUE LIKE ?";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("1", tabName);
            String tabPath = DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + "%";
            params.put("2", tabPath);
            params.put("query", sql);
            Collection qResults = registry.executeQuery(DashboardConstants.SQL_STATEMENTS_PATH + "/query4", params);
            String[] qPaths = (String[])qResults.getContent();
            return qPaths.length != 0;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could validate the url for duplicates", (Throwable)e);
            return false;
        }
    }

    private Boolean isOldUser(String userId) {
        String nextGadgetIdPath = DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.NEXT_GADGET_ID_PATH;
        try {
            Registry registry = this.getConfigSystemRegistry();
            Boolean newUser = registry.resourceExists(nextGadgetIdPath);
            return newUser;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Boolean isSessionValid() {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        return !httpSession.isNew();
    }

    public String getPortalStylesUrl(String user) {
        Registry userRegistry = this.getConfigSystemRegistry();
        String retPath = null;
        try {
            if (userRegistry.resourceExists(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH)) {
                Resource res = userRegistry.get(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH);
                retPath = res.getProperty("theme.location");
                return retPath;
            }
            return retPath;
        }
        catch (Exception e) {
            log.error((Object)"Exception when retriving Portal style URL", (Throwable)e);
            return null;
        }
    }

    public Boolean populateCustomLayouts(String userId, String tabId, String layout, String dashboard) {
        Boolean result = false;
        String response = "NA";
        if (userId == null | "NULL".equalsIgnoreCase(userId)) {
            response = "NA";
        } else {
            try {
                String templateType = null;
                if (layout.equalsIgnoreCase("1")) {
                    templateType = LayoutConstants.ONE_COLUMN_LAYOUT;
                } else if (layout.equalsIgnoreCase("2")) {
                    templateType = LayoutConstants.TWO_COLUMN_SYMETRIC_LAYOUT;
                } else if (layout.equalsIgnoreCase("3")) {
                    templateType = LayoutConstants.DEFAULT_THREE_COLUMN_LAYOUT;
                } else if (layout.equalsIgnoreCase("4")) {
                    templateType = LayoutConstants.CUSTOM_THREE_COLUMN_LAYOUT;
                } else if (layout.equalsIgnoreCase("5")) {
                    templateType = LayoutConstants.TWO_COLUMN_ASYMETRIC1_LAYOUT;
                } else if (layout.equalsIgnoreCase("6")) {
                    templateType = LayoutConstants.TWO_COLUMN_ASYMETRIC2_LAYOUT;
                }
                response = new JSONObject(templateType).toString();
                try {
                    JSONObject currentLayout = new JSONObject(this.getGadgetLayout(userId, tabId, dashboard));
                    JSONArray layoutElements = currentLayout.getJSONArray("layout");
                    ArrayList gadgetIdStore = new ArrayList();
                    this.getGadgetIdsFromJsonLayout(layoutElements, gadgetIdStore);
                    for (String gadgetId : gadgetIdStore) {
                        response = this.insertGadgetToJsonLayout(response, gadgetId, 0).toString();
                    }
                }
                catch (JSONException e) {
                    log.debug((Object)"ignoring this exception : ", (Throwable)e);
                }
                this.setGadgetLayout(userId, tabId, response, dashboard);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public String populateDefaultThreeColumnLayout(String userId, String tabId) throws AxisFault {
        String response = "NA";
        if (userId == null | "NULL".equalsIgnoreCase(userId)) {
            response = "NA";
        } else {
            String[] gadgetURLs = this.getDefaultGadgetUrlSet(userId);
            Registry registry = null;
            try {
                JSONObject gadget;
                String gadgetId;
                int x;
                JSONObject masterLayout = new JSONObject();
                JSONObject column1Layout = new JSONObject();
                column1Layout.put("type", (Object)"columnContainer");
                column1Layout.put("width", (Object)"33%");
                JSONObject column2Layout = new JSONObject();
                column2Layout.put("type", (Object)"columnContainer");
                column2Layout.put("width", (Object)"33%");
                JSONObject column3Layout = new JSONObject();
                column3Layout.put("type", (Object)"columnContainer");
                column3Layout.put("width", (Object)"33%");
                registry = this.getConfigSystemRegistry();
                JSONArray column1Gadgets = new JSONArray();
                JSONArray column2Gadgets = new JSONArray();
                JSONArray column3Gadgets = new JSONArray();
                for (x = 0; x < gadgetURLs.length; x += 3) {
                    gadgetId = this.addGadgetToRegistry(userId, gadgetURLs[x], null, registry);
                    gadget = new JSONObject();
                    gadget.put("type", (Object)"gadget");
                    gadget.put("id", (Object)gadgetId);
                    column1Gadgets.put(column1Gadgets.length(), (Object)gadget);
                }
                for (x = 1; x < gadgetURLs.length; x += 3) {
                    gadgetId = this.addGadgetToRegistry(userId, gadgetURLs[x], null, registry);
                    gadget = new JSONObject();
                    gadget.put("type", (Object)"gadget");
                    gadget.put("id", (Object)gadgetId);
                    column2Gadgets.put(column2Gadgets.length(), (Object)gadget);
                }
                for (x = 2; x < gadgetURLs.length; x += 3) {
                    gadgetId = this.addGadgetToRegistry(userId, gadgetURLs[x], null, registry);
                    gadget = new JSONObject();
                    gadget.put("type", (Object)"gadget");
                    gadget.put("id", (Object)gadgetId);
                    column3Gadgets.put(column3Gadgets.length(), (Object)gadget);
                }
                column1Layout.put("layout", (Object)column1Gadgets);
                column2Layout.put("layout", (Object)column2Gadgets);
                column3Layout.put("layout", (Object)column3Gadgets);
                JSONArray columnCollection = new JSONArray();
                columnCollection.put(columnCollection.length(), (Object)column1Layout);
                columnCollection.put(columnCollection.length(), (Object)column2Layout);
                columnCollection.put(columnCollection.length(), (Object)column3Layout);
                masterLayout.put("layout", (Object)columnCollection);
                response = masterLayout.toString();
                this.setGadgetLayout(userId, tabId, response, null);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }

    public DashboardContentBean getDashboardContent(String userId, String dashboardName, String tDomain, String backendServerURL) throws AxisFault {
        DashboardContentBean dashboardContentBean = new DashboardContentBean();
        dashboardContentBean.setBackendHttpPort(this.getBackendHttpPort());
        dashboardContentBean.setDefaultGadgetUrlSet(this.getDefaultGadgetUrlSet(userId));
        dashboardContentBean.setPortalCss(this.getPortalStylesUrl(userId));
        dashboardContentBean.setReadOnlyMode(this.isReadOnlyMode(userId));
        dashboardContentBean.setTabLayout(this.getTabLayout(userId, dashboardName));
        String[] userTabLayout = this.getTabLayout(userId, dashboardName).split(",");
        ArrayList<Tab> userTabs = new ArrayList<Tab>();
        try {
            for (String userTab : userTabLayout) {
                Tab tab = new Tab();
                tab.setTabName(this.getTabTitle(userId, userTab, dashboardName));
                tab.setTabId(userTab);
                tab.setGadgetLayout(this.getGadgetLayout(userId, userTab, dashboardName));
                tab.setGadgets(this.getGadgetsForTab(userId, dashboardName, tab.getGadgetLayout()));
                userTabs.add(tab);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        Tab[] tabs = new Tab[userTabs.size()];
        dashboardContentBean.setTabs(userTabs.toArray(tabs));
        return dashboardContentBean;
    }

    public String getDashboardContentAsJson(String userId, String dashboardName, String tDomain, String backendServerURL) throws AxisFault {
        DashboardContentBean dashboardContentBean = this.getDashboardContent(userId, dashboardName, tDomain, backendServerURL);
        try {
            return dashboardContentBean.toJSONObject().toString();
        }
        catch (JSONException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public String getTabContentAsJson(String userId, String dashboardName, String tDomain, String backendServerURL, String tabId) throws AxisFault {
        DashboardContentBean dashboardContentBean = this.getDashboardContent(userId, dashboardName, tDomain, backendServerURL);
        Tab tab = this.getTabContentFromId(dashboardContentBean, tabId);
        try {
            return tab.toJSONObject().toString();
        }
        catch (JSONException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    private Gadget[] getGadgetsForTab(String userId, String dashboardName, String storedLayout) throws Exception {
        ArrayList<String> gadgetIdStore = new ArrayList<String>();
        if ("NA".equalsIgnoreCase(storedLayout)) {
            return new Gadget[0];
        }
        if (storedLayout.contains("G1#")) {
            String[] columnIdCombos = storedLayout.split(",");
            for (int x = 0; x < columnIdCombos.length; ++x) {
                String currentId = columnIdCombos[x].split("#")[1];
                if (currentId == null || "".equals(currentId)) continue;
                gadgetIdStore.add(currentId);
            }
        } else {
            this.getGadgetIdsFromJsonLayout(new JSONObject(storedLayout).getJSONArray("layout"), gadgetIdStore);
        }
        ArrayList<Gadget> gadgets = new ArrayList<Gadget>();
        for (String gadgetId : gadgetIdStore) {
            Gadget gadget = new Gadget();
            gadget.setGadgetId(gadgetId);
            gadget.setGadgetUrl(this.getGadgetUrl(userId, gadgetId, dashboardName));
            gadget.setGadgetPrefs(this.getGadgetPrefs(userId, gadgetId, "gadgetUserPrefs-" + gadgetId, dashboardName));
            gadgets.add(gadget);
        }
        Gadget[] gadgetsArray = new Gadget[gadgets.size()];
        return gadgets.toArray(gadgetsArray);
    }

    private Tab getTabContentFromId(DashboardContentBean dcb, String tabId) {
        Tab[] tabs;
        for (Tab tab : tabs = dcb.getTabs()) {
            if (!tab.getTabId().equals(tabId)) continue;
            return tab;
        }
        return null;
    }

    public String getTabLayoutWithNames(String userId, String dashboard) throws AxisFault {
        String[] userTabLayout = this.getTabLayout(userId, dashboard).split(",");
        StringBuilder result = new StringBuilder();
        for (String tabId : userTabLayout) {
            result.append(tabId + "-" + this.getTabTitle(userId, tabId, dashboard));
            result.append(",");
        }
        if (result.length() != 0) {
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    public boolean populateDashboardTab(String tabId) throws AxisFault {
        boolean returnValue = false;
        String gadgetDiskRoot = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "resources" + File.separator + "dashboard" + File.separator + "gadgets" + File.separator;
        String tabResourcePath = "tab" + tabId;
        String tabDiskLocation = gadgetDiskRoot + tabResourcePath;
        String registryGadgetPath = DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + DashboardConstants.GADGET_PATH;
        String serverName = CarbonUtils.getServerConfiguration().getFirstProperty("Name");
        Registry registry = this.getConfigSystemRegistry();
        try {
            if (registry.resourceExists(DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + serverName)) {
                Resource serverNameResource = registry.get(DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + serverName);
                if (serverNameResource.getProperty(tabResourcePath) == null) {
                    serverNameResource.setProperty(tabResourcePath, tabResourcePath);
                    String tenantDomain = SuperTenantCarbonContext.getCurrentContext().getTenantDomain();
                    File tabResourceDir = new File(tabDiskLocation);
                    if (tabResourceDir.exists()) {
                        this.beginFileTransfer(tabResourceDir, registry, registryGadgetPath);
                        log.info((Object)("Successfully populated the default Gadgets for tab : " + tabId + " in tenant : " + tenantDomain));
                        returnValue = true;
                    } else {
                        log.info((Object)("Couldn't find contents at '" + tabDiskLocation + "'. Giving up."));
                    }
                    registry.put(DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + serverName, serverNameResource);
                }
            } else {
                log.debug((Object)("Couldn't find a dashboard resources for " + serverName + ", and skipping on demand gadget population"));
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    private void beginFileTransfer(File rootDirectory, Registry registry, String registryGadgetPath) throws RegistryException {
        String rootPath = rootDirectory.getAbsolutePath();
        Collection defaultGadgetCollection = registry.newCollection();
        try {
            registry.beginTransaction();
            if (!registry.resourceExists(registryGadgetPath)) {
                registry.put(registryGadgetPath, (Resource)defaultGadgetCollection);
            }
            this.transferDirectoryContentToRegistry(rootDirectory, rootPath, registry, registryGadgetPath);
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void transferDirectoryContentToRegistry(File rootDirectory, String rootPath, Registry registry, String registryGadgetPath) throws FileNotFoundException {
        try {
            File[] filesAndDirs = rootDirectory.listFiles();
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                if (!file.isFile()) {
                    String directoryRegistryPath = registryGadgetPath + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
                    Collection newCollection = registry.newCollection();
                    if (!registry.resourceExists(directoryRegistryPath)) {
                        this.setAnonymousReadPermission(directoryRegistryPath);
                        registry.put(directoryRegistryPath, (Resource)newCollection);
                    }
                    this.transferDirectoryContentToRegistry(file, rootPath, registry, registryGadgetPath);
                    continue;
                }
                this.addToRegistry(rootPath, file, registry, registryGadgetPath);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void addToRegistry(String rootPath, File file, Registry registry, String registryGadgetPath) {
        try {
            String fileRegistryPath = registryGadgetPath + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
            Resource fileResource = registry.newResource();
            String mediaType = MediaTypesUtils.getMediaType((String)file.getAbsolutePath());
            if (mediaType.equals("application/xml")) {
                fileResource.setMediaType("application/vnd.wso2-gadget+xml");
            } else {
                fileResource.setMediaType(mediaType);
            }
            fileResource.setContentStream((InputStream)new FileInputStream(file));
            registry.put(fileRegistryPath, fileResource);
            this.setAnonymousReadPermission(fileRegistryPath);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setAnonymousReadPermission(String fileRegistryPath) throws org.wso2.carbon.user.api.UserStoreException {
        AuthorizationManager accessControlAdmin = CarbonContext.getCurrentContext().getUserRealm().getAuthorizationManager();
        if (!accessControlAdmin.isRoleAuthorized("wso2.anonymous.role", "/_system/config" + fileRegistryPath, "http://www.wso2.org/projects/registry/actions/get")) {
            accessControlAdmin.authorizeRole("wso2.anonymous.role", "/_system/config" + fileRegistryPath, "http://www.wso2.org/projects/registry/actions/get");
        }
    }

    protected Registry getConfigSystemRegistry() {
        return (Registry)SuperTenantCarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
    }

    protected Registry getConfigUserRegistry() {
        return (Registry)SuperTenantCarbonContext.getCurrentContext().getRegistry(RegistryType.USER_CONFIGURATION);
    }
}

