/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.DashboardException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.utils.ConfigurationContextService;

public class DashboardContext {
    private static Log log = LogFactory.getLog(DashboardContext.class);
    private static RegistryService registryService = null;
    private static UserRealm userRealm = null;
    private static ConfigurationContextService configContextService = null;

    public static ConfigurationContext getConfigContext() throws DashboardException {
        if (configContextService == null) {
            throw new DashboardException("ConfigurationContextService is null");
        }
        try {
            return configContextService.getServerConfigContext();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new DashboardException(e);
        }
    }

    public static void setConfigContextService(ConfigurationContextService configContext) {
        configContextService = configContext;
    }

    public static UserRealm getUserRealm() throws DashboardException {
        if (userRealm == null) {
            throw new DashboardException("UserRealm is null");
        }
        return userRealm;
    }

    public static void setUserRealm(UserRealm userRealm) {
        DashboardContext.userRealm = userRealm;
    }

    public static void setRegistryService(RegistryService registryService) {
        DashboardContext.registryService = registryService;
    }

    public static Registry getRegistry(int tId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tId);
    }
}

