/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.ui.internal;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.auth.AuthenticationServletFilter;
import org.apache.shindig.gadgets.servlet.ConcatProxyServlet;
import org.apache.shindig.gadgets.servlet.GadgetRenderingServlet;
import org.apache.shindig.gadgets.servlet.HtmlAccelServlet;
import org.apache.shindig.gadgets.servlet.JsServlet;
import org.apache.shindig.gadgets.servlet.MakeRequestServlet;
import org.apache.shindig.gadgets.servlet.OAuthCallbackServlet;
import org.apache.shindig.gadgets.servlet.ProxyServlet;
import org.apache.shindig.gadgets.servlet.RpcServlet;
import org.apache.shindig.protocol.DataServiceServlet;
import org.apache.shindig.protocol.JsonRpcServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.dashboard.common.OAuthUtils;
import org.wso2.carbon.dashboard.common.oauth.GSOAuthModule;
import org.wso2.carbon.dashboard.ui.DashboardUiContext;
import org.wso2.carbon.dashboard.ui.servlets.MakeSoapRequestServlet;
import org.wso2.carbon.utils.ConfigurationContextService;

public class DashboardUiServiceComponent {
    protected static final String INJECTOR_ATTRIBUTE = "guice-injector";
    protected static final String MODULES_ATTRIBUTE = "guice-modules";
    private static HttpService httpServiceInstance;
    private static final Log log;
    private List<ServiceRegistration> serviceRegistrations = null;
    private static ServletContext servletCtx;
    private static BundleContext bctx;

    protected void activate(ComponentContext context) {
        try {
            this.initShindig(servletCtx);
            bctx = context.getBundleContext();
            this.registerServlets(context.getBundleContext());
            log.debug((Object)"******* Dashboard UI Component bundle is activated ******* ");
        }
        catch (Exception e) {
            log.debug((Object)"******* Failed to activate Dashboard UI Component bundle ******* ");
        }
    }

    protected void deactivate(ComponentContext context) {
        this.unregisterServlets();
        log.debug((Object)"******* Dashboard UI Component bundle is deactivated ******* ");
    }

    protected void setServletContextService(ServletContext servletContext) {
        servletCtx = servletContext;
    }

    protected void unsetServletContextService(ServletContext servletContext) {
        servletContext.removeAttribute(INJECTOR_ATTRIBUTE);
    }

    protected void initShindig(ServletContext context) {
        System.setProperty("shindig-host-context", this.getHostWithContext());
        String moduleNames = "org.apache.shindig.common.PropertiesModule:org.apache.shindig.gadgets.DefaultGuiceModule:org.wso2.carbon.dashboard.social.GuiceModuleImpl:org.wso2.carbon.dashboard.common.oauth.GSOAuthModule";
        LinkedList modules = Lists.newLinkedList();
        for (String moduleName : moduleNames.split(":")) {
            try {
                moduleName = moduleName.trim();
                if (moduleName.length() <= 0) continue;
                modules.add((Module)Class.forName(moduleName).newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                if (moduleName.contains("org.wso2.carbon.dashboard.social.GuiceModuleImpl")) {
                    try {
                        modules.add((Module)Class.forName("org.apache.shindig.social.sample.SampleModule").newInstance());
                    }
                    catch (Exception e1) {
                        log.error((Object)e1);
                    }
                    continue;
                }
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Injector injector = null;
        try {
            injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)modules);
            GSOAuthModule.OAuthStoreProvider provider = (GSOAuthModule.OAuthStoreProvider)injector.getInstance(GSOAuthModule.OAuthStoreProvider.class);
            OAuthUtils.setOauthStoreProvider((GSOAuthModule.OAuthStoreProvider)provider);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
        }
        context.setAttribute(INJECTOR_ATTRIBUTE, (Object)injector);
    }

    private String getHostWithContext() {
        try {
            String webAppContext = DashboardUiContext.getConfigContext().getContextRoot();
            String hostWithContext = webAppContext.equals("/") ? System.getProperty("carbon.local.ip") + ":" + this.getBackendHttpPort() : System.getProperty("carbon.local.ip") + ":" + this.getBackendHttpPort() + webAppContext;
            return hostWithContext;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    private String getBackendHttpPort() {
        String httpPort = null;
        try {
            httpPort = ServerConfiguration.getInstance().getFirstProperty("RegistryHttpPort");
            if (httpPort == null) {
                httpPort = (String)DashboardUiContext.getConfigContext().getAxisConfiguration().getTransportIn("http").getParameter("port").getValue();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return httpPort;
    }

    private void registerServlets(BundleContext bundleContext) throws Exception {
        try {
            Object temp = null;
            if (this.serviceRegistrations != null) {
                return;
            }
            this.serviceRegistrations = new LinkedList<ServiceRegistration>();
            HttpServlet authServlet = new HttpServlet(){

                protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                }
            };
            this.registerServlets();
        }
        catch (Exception e) {
            String msg = "Failed to Register the Shindig Servlets";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    private void unregisterServlets() {
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations = null;
    }

    protected void setConfigurationContextService(ConfigurationContextService configCtx) {
        DashboardUiContext.setConfigContextService(configCtx);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtx) {
        DashboardUiContext.setConfigContextService(null);
    }

    private void registerServlets() throws Exception {
        this.registerXMLtoHTMLServlet();
        this.registerAccelServlet();
        this.registerMakeRequestServlet();
        this.registerProxyServlet();
        this.registerConcatServlet();
        this.registerOAuthCallbackServlet();
        this.registerMetadataServlet();
        this.registerJsServlet();
        this.registerRestApiServlet();
        this.registerJsonRpcServlet();
        this.registerSOAPRequestServlet();
    }

    private void registerServlet(BundleContext bundleContext, HttpServlet servlet, Dictionary servletParams) {
        ServiceRegistration temp = bundleContext.registerService(Servlet.class.getName(), (Object)servlet, servletParams);
        if (temp != null) {
            this.serviceRegistrations.add(temp);
            temp = null;
        }
    }

    private void registerXMLtoHTMLServlet() {
        GadgetRenderingServlet gadgetRenderingServlet = new GadgetRenderingServlet();
        AuthenticationServletFilter authFilter = new AuthenticationServletFilter();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "xml-to-html");
        ((Dictionary)servletMappings).put("url-pattern", "/ifr");
        this.registerServlet(bctx, (HttpServlet)gadgetRenderingServlet, servletMappings);
    }

    private void registerAccelServlet() {
        HtmlAccelServlet htmlAccelServlet = new HtmlAccelServlet();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "accel");
        ((Dictionary)servletMappings).put("url-pattern", "/gadgets/accel");
        this.registerServlet(bctx, (HttpServlet)htmlAccelServlet, servletMappings);
    }

    private void registerMakeRequestServlet() {
        MakeRequestServlet makeRequestServlet = new MakeRequestServlet();
        AuthenticationServletFilter authFilter = new AuthenticationServletFilter();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "makeRequest");
        ((Dictionary)servletMappings).put("url-pattern", "/gadgets/makeRequest");
        ((Dictionary)servletMappings).put("associated-filter", (String)authFilter);
        this.registerServlet(bctx, (HttpServlet)makeRequestServlet, servletMappings);
    }

    private void registerProxyServlet() {
        ProxyServlet proxyServlet = new ProxyServlet();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "proxy");
        ((Dictionary)servletMappings).put("url-pattern", "/gadgets/proxy");
        this.registerServlet(bctx, (HttpServlet)proxyServlet, servletMappings);
    }

    private void registerConcatServlet() {
        ConcatProxyServlet concatProxyServlet = new ConcatProxyServlet();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "concat");
        ((Dictionary)servletMappings).put("url-pattern", "/gadgets/concat");
        this.registerServlet(bctx, (HttpServlet)concatProxyServlet, servletMappings);
    }

    private void registerOAuthCallbackServlet() {
        OAuthCallbackServlet oauthCallbackServlet = new OAuthCallbackServlet();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "oauthCallback");
        ((Dictionary)servletMappings).put("url-pattern", "/gadgets/oauthcallback");
        this.registerServlet(bctx, (HttpServlet)oauthCallbackServlet, servletMappings);
    }

    private void registerMetadataServlet() {
        RpcServlet rpcServlet = new RpcServlet();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "metadata");
        ((Dictionary)servletMappings).put("url-pattern", "/gadgets/metadata");
        this.registerServlet(bctx, (HttpServlet)rpcServlet, servletMappings);
    }

    private void registerJsServlet() {
        JsServlet jsServlet = new JsServlet();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "js");
        ((Dictionary)servletMappings).put("url-pattern", "/gadgets/js");
        this.registerServlet(bctx, (HttpServlet)jsServlet, servletMappings);
    }

    private void registerRestApiServlet() {
        this.registerRestApiServlet("/rest");
        this.registerRestApiServlet("/gadgets/api/rest");
        this.registerRestApiServlet("/social/rest");
    }

    private void registerRestApiServlet(String urlPattern) {
        DataServiceServlet dataServiceServlet = new DataServiceServlet();
        AuthenticationServletFilter authFilter = new AuthenticationServletFilter();
        Hashtable<String, Object> servletMappings = new Hashtable<String, Object>();
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        ((Dictionary)initParams).put("handlers", "org.apache.shindig.social.handlers");
        ((Dictionary)servletMappings).put("url-pattern", urlPattern);
        ((Dictionary)servletMappings).put("servlet-params", initParams);
        ((Dictionary)servletMappings).put("associated-filter", authFilter);
        this.registerServlet(bctx, (HttpServlet)dataServiceServlet, servletMappings);
    }

    private void registerJsonRpcServlet() {
        this.registerJsonRpcServlet("/rpc");
        this.registerJsonRpcServlet("/gadgets/api/rpc");
        this.registerJsonRpcServlet("/social/rpc");
    }

    private void registerJsonRpcServlet(String urlPattern) {
        JsonRpcServlet jsonRpcServlet = new JsonRpcServlet();
        AuthenticationServletFilter authFilter = new AuthenticationServletFilter();
        Hashtable<String, Object> servletMappings = new Hashtable<String, Object>();
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        ((Dictionary)initParams).put("handlers", "org.apache.shindig.social.handlers");
        ((Dictionary)servletMappings).put("url-pattern", urlPattern);
        ((Dictionary)servletMappings).put("servlet-params", initParams);
        ((Dictionary)servletMappings).put("associated-filter", authFilter);
        this.registerServlet(bctx, (HttpServlet)jsonRpcServlet, servletMappings);
    }

    private void registerSOAPRequestServlet() {
        MakeSoapRequestServlet makeSoapRequestServlet = new MakeSoapRequestServlet();
        Hashtable<String, String> servletMappings = new Hashtable<String, String>();
        ((Dictionary)servletMappings).put("servlet-name", "soapRequest");
        ((Dictionary)servletMappings).put("url-pattern", "/gadgets/makeSOAPRequest");
        this.registerServlet(bctx, makeSoapRequestServlet, servletMappings);
    }

    static {
        log = LogFactory.getLog(DashboardUiServiceComponent.class);
        servletCtx = null;
        bctx = null;
    }
}

