/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.dashboardpopulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.dashboardpopulator.DashboardPopulatorContext;
import org.wso2.carbon.dashboard.dashboardpopulator.DashboardPopulatorException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.utils.CarbonUtils;

public class GadgetPopulator {
    private static final Log log = LogFactory.getLog(GadgetPopulator.class);
    public static final String SYSTEM_GADGETS_PATH = "/repository/dashboards/gadgets";
    private static final String REGISTRY_SYSTEM_DASHBOARDS_ROOT = "/repository/dashboards";
    static String gadgetsPath = "/repository/dashboards/gadgets";

    public static void populateDashboard(int tenantId) {
        try {
            String dashboardDiskRoot = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "resources" + File.separator + "dashboard";
            String dashboardConfigFile = dashboardDiskRoot + File.separator + "dashboard.xml";
            String gadgetsDiskLocation = dashboardDiskRoot + File.separator + "gadgets";
            UserRegistry registry = DashboardPopulatorContext.getRegistry(tenantId);
            AuthorizationManager accessControlAdmin = registry.getUserRealm().getAuthorizationManager();
            if (!accessControlAdmin.isRoleAuthorized("wso2.anonymous.role", "/_system/config/repository/dashboards/gadgets", "http://www.wso2.org/projects/registry/actions/get")) {
                accessControlAdmin.authorizeRole("wso2.anonymous.role", "/_system/config/repository/dashboards/gadgets", "http://www.wso2.org/projects/registry/actions/get");
            }
            String serverName = CarbonUtils.getServerConfiguration().getFirstProperty("Name");
            if (!registry.resourceExists("/repository/dashboards/" + serverName)) {
                File dashboardConfigXml = new File(dashboardConfigFile);
                if (dashboardConfigXml.exists()) {
                    FileReader dashboardConfigXmlReader = new FileReader(dashboardConfigXml);
                    registry.restore(REGISTRY_SYSTEM_DASHBOARDS_ROOT, (Reader)dashboardConfigXmlReader);
                    log.info((Object)"Successfully populated the default Dashboards.");
                } else {
                    log.info((Object)("Couldn't find a Dashboard at '" + dashboardConfigFile + "'. Giving up."));
                }
                File gadgetsDir = new File(gadgetsDiskLocation);
                if (gadgetsDir.exists()) {
                    GadgetPopulator.beginFileTansfer(gadgetsDir, tenantId);
                    log.info((Object)"Successfully populated the default Gadgets.");
                } else {
                    log.info((Object)("Couldn't find contents at '" + gadgetsDiskLocation + "'. Giving up."));
                }
                registry.put("/repository/dashboards/" + serverName, registry.newResource());
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to activate Dashboard Populator for Governance bundle ");
        }
    }

    public static void beginFileTansfer(File rootDirectory, int tenantId) throws RegistryException {
        try {
            String rootPath = rootDirectory.getAbsolutePath();
            UserRegistry registry = DashboardPopulatorContext.getRegistry(tenantId);
            Collection defaultGadgetCollection = registry.newCollection();
            try {
                registry.beginTransaction();
                registry.put(gadgetsPath, (Resource)defaultGadgetCollection);
                GadgetPopulator.transferDirectoryContentToRegistry(rootDirectory, (Registry)registry, rootPath, tenantId);
                registry.commitTransaction();
            }
            catch (Exception e) {
                registry.rollbackTransaction();
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (DashboardPopulatorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void transferDirectoryContentToRegistry(File rootDirectory, Registry registry, String rootPath, int tenantId) throws FileNotFoundException {
        try {
            File[] filesAndDirs = rootDirectory.listFiles();
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                if (!file.isFile()) {
                    String directoryRegistryPath = gadgetsPath + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
                    Collection newCollection = registry.newCollection();
                    registry.put(directoryRegistryPath, (Resource)newCollection);
                    GadgetPopulator.transferDirectoryContentToRegistry(file, registry, rootPath, tenantId);
                    continue;
                }
                GadgetPopulator.addToRegistry(rootPath, file, tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void addToRegistry(String rootPath, File file, int tenantId) {
        try {
            UserRegistry registry = DashboardPopulatorContext.getRegistry(tenantId);
            String fileRegistryPath = gadgetsPath + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
            Resource fileResource = registry.newResource();
            String mediaType = MediaTypesUtils.getMediaType((String)file.getAbsolutePath());
            if (mediaType.equals("application/xml")) {
                fileResource.setMediaType("application/vnd.wso2-gadget+xml");
            } else {
                fileResource.setMediaType(mediaType);
            }
            fileResource.setContentStream((InputStream)new FileInputStream(file));
            registry.put(fileRegistryPath, fileResource);
        }
        catch (DashboardPopulatorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void PopulateDashboardLayout(int tenantId) {
        try {
            String dashboardDiskRoot = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "resources" + File.separator + "dashboard";
            String dashboardConfigFile = dashboardDiskRoot + File.separator + "dashboard.xml";
            String serverName = CarbonUtils.getServerConfiguration().getFirstProperty("Name");
            UserRegistry registry = DashboardPopulatorContext.getRegistry(tenantId);
            AuthorizationManager accessControlAdmin = registry.getUserRealm().getAuthorizationManager();
            if (!accessControlAdmin.isRoleAuthorized("wso2.anonymous.role", "/_system/config/repository/dashboards/gadgets", "http://www.wso2.org/projects/registry/actions/get")) {
                accessControlAdmin.authorizeRole("wso2.anonymous.role", "/_system/config/repository/dashboards/gadgets", "http://www.wso2.org/projects/registry/actions/get");
            }
            if (!registry.resourceExists("/repository/dashboards/" + serverName)) {
                File dashboardConfigXml = new File(dashboardConfigFile);
                if (dashboardConfigXml.exists()) {
                    FileReader dashboardConfigXmlReader = new FileReader(dashboardConfigXml);
                    registry.restore(REGISTRY_SYSTEM_DASHBOARDS_ROOT, (Reader)dashboardConfigXmlReader);
                    log.info((Object)("Successfully populated the default Dashboard XML for tenant :" + tenantId));
                } else {
                    log.info((Object)("Couldn't find a Dashboard XML at '" + dashboardConfigFile + "'. Giving up dashboard population for tenant : " + tenantId));
                }
                registry.put("/repository/dashboards/" + serverName, registry.newResource());
            }
        }
        catch (Exception e) {
            String errorMsg = "Failed to populate Dashboard Layout (dashboard.xml) for tenant : " + tenantId;
            log.error((Object)errorMsg, (Throwable)e);
        }
    }
}

