/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.common.oauth;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Map;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreTokenIndex;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.wso2.carbon.dashboard.common.oauth.GSOAuthStoreConsumerIndex;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;

@Singleton
public class RegistryBasedOAuthStore
implements OAuthStore {
    private final Map<GSOAuthStoreConsumerIndex, BasicOAuthStoreConsumerKeyAndSecret> consumerInfos = Maps.newHashMap();
    private final Map<BasicOAuthStoreTokenIndex, OAuthStore.TokenInfo> tokens = Maps.newHashMap();
    private BasicOAuthStoreConsumerKeyAndSecret defaultKey;
    private String defaultCallbackUrl;
    private int consumerKeyLookupCount = 0;
    private int accessTokenLookupCount = 0;
    private int accessTokenAddCount = 0;
    private int accessTokenRemoveCount = 0;

    public void initFromConfigString(Registry reg, Collection oauthColl) throws GadgetException {
        try {
            String[] arr = oauthColl.getChildren();
            if (arr.length > 0) {
                for (int i = 0; i < arr.length; ++i) {
                    Resource res = reg.get(arr[i]);
                    this.realStoreConsumerInfo(null, res.getProperty("consumer_service"), res);
                }
            }
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, (Throwable)e);
        }
    }

    private void realStoreConsumerInfo(URI gadgetUri, String serviceName, Resource consumerInfo) throws Exception {
        String callbackUrl = consumerInfo.getProperty("callback_url");
        String consumerSecret = consumerInfo.getProperty("consumer_secret");
        String consumerKey = consumerInfo.getProperty("consumer_key");
        String keyTypeStr = consumerInfo.getProperty("key_type");
        BasicOAuthStoreConsumerKeyAndSecret.KeyType keyType = BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC;
        if (keyTypeStr.equals("RSA_PRIVATE")) {
            keyType = BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE;
            consumerSecret = RegistryBasedOAuthStore.convertFromOpenSsl(consumerSecret);
        }
        BasicOAuthStoreConsumerKeyAndSecret kas = new BasicOAuthStoreConsumerKeyAndSecret(consumerKey, consumerSecret, keyType, null, callbackUrl);
        GSOAuthStoreConsumerIndex index = new GSOAuthStoreConsumerIndex();
        index.setServiceName(serviceName);
        this.setConsumerKeyAndSecret(index, kas);
    }

    public static String convertFromOpenSsl(String privateKey) {
        return privateKey.replaceAll("-----[A-Z ]*-----", "").replace("\n", "");
    }

    public void setDefaultKey(BasicOAuthStoreConsumerKeyAndSecret defaultKey) {
        this.defaultKey = defaultKey;
    }

    public void setDefaultCallbackUrl(String defaultCallbackUrl) {
        this.defaultCallbackUrl = defaultCallbackUrl;
    }

    public void setConsumerKeyAndSecret(GSOAuthStoreConsumerIndex providerKey, BasicOAuthStoreConsumerKeyAndSecret keyAndSecret) {
        this.consumerInfos.put(providerKey, keyAndSecret);
    }

    public OAuthStore.ConsumerInfo getConsumerKeyAndSecret(SecurityToken securityToken, String serviceName, OAuthServiceProvider provider) throws GadgetException {
        ++this.consumerKeyLookupCount;
        GSOAuthStoreConsumerIndex pk = new GSOAuthStoreConsumerIndex();
        pk.setGadgetUri(securityToken.getAppUrl());
        pk.setServiceName(serviceName);
        BasicOAuthStoreConsumerKeyAndSecret cks = this.consumerInfos.get((Object)pk);
        if (cks == null) {
            cks = this.defaultKey;
        }
        if (cks == null) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "No key for gadget " + securityToken.getAppUrl() + " and service " + serviceName);
        }
        OAuthConsumer consumer = null;
        if (cks.getKeyType() == BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE) {
            consumer = new OAuthConsumer(null, cks.getConsumerKey(), null, provider);
            consumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
            consumer.setProperty("RSA-SHA1.PrivateKey", (Object)cks.getConsumerSecret());
        } else {
            consumer = new OAuthConsumer(null, cks.getConsumerKey(), cks.getConsumerSecret(), provider);
            consumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
        }
        String callback = cks.getCallbackUrl() != null ? cks.getCallbackUrl() : this.defaultCallbackUrl;
        return new OAuthStore.ConsumerInfo(consumer, cks.getKeyName(), callback);
    }

    private BasicOAuthStoreTokenIndex makeBasicOAuthStoreTokenIndex(SecurityToken securityToken, String serviceName, String tokenName) {
        BasicOAuthStoreTokenIndex tokenKey = new BasicOAuthStoreTokenIndex();
        tokenKey.setGadgetUri(securityToken.getAppUrl());
        tokenKey.setModuleId(securityToken.getModuleId());
        tokenKey.setServiceName(serviceName);
        tokenKey.setTokenName(tokenName);
        tokenKey.setUserId(securityToken.getViewerId());
        return tokenKey;
    }

    public OAuthStore.TokenInfo getTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) {
        ++this.accessTokenLookupCount;
        BasicOAuthStoreTokenIndex tokenKey = this.makeBasicOAuthStoreTokenIndex(securityToken, serviceName, tokenName);
        return this.tokens.get(tokenKey);
    }

    public void setTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName, OAuthStore.TokenInfo tokenInfo) {
        ++this.accessTokenAddCount;
        BasicOAuthStoreTokenIndex tokenKey = this.makeBasicOAuthStoreTokenIndex(securityToken, serviceName, tokenName);
        this.tokens.put(tokenKey, tokenInfo);
    }

    public void removeToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) {
        ++this.accessTokenRemoveCount;
        BasicOAuthStoreTokenIndex tokenKey = this.makeBasicOAuthStoreTokenIndex(securityToken, serviceName, tokenName);
        this.tokens.remove(tokenKey);
    }

    public int getConsumerKeyLookupCount() {
        return this.consumerKeyLookupCount;
    }

    public int getAccessTokenLookupCount() {
        return this.accessTokenLookupCount;
    }

    public int getAccessTokenAddCount() {
        return this.accessTokenAddCount;
    }

    public int getAccessTokenRemoveCount() {
        return this.accessTokenRemoveCount;
    }
}

