/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.common;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.common.oauth.GSOAuthModule;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.utils.ConfigurationContextService;

public class OAuthUtils {
    private static RegistryService registryService = null;
    private static GSOAuthModule.OAuthStoreProvider oauthStoreProvider = null;
    private static UserRealm userRealm = null;
    private static final Log log = LogFactory.getLog(OAuthUtils.class);
    private static ConfigurationContextService configContextService;

    public static UserRealm getUserRealm() throws Exception {
        if (userRealm == null) {
            throw new Exception("UserRealm is null");
        }
        return userRealm;
    }

    public static void setUserRealm(UserRealm userRealm) {
        OAuthUtils.userRealm = userRealm;
    }

    public static void setRegistryService(RegistryService registryService) {
        OAuthUtils.registryService = registryService;
    }

    public static Registry getRegistry(int tenantId) throws Exception {
        if (registryService == null) {
            throw new Exception("Registry is null");
        }
        try {
            return registryService.getConfigSystemRegistry(tenantId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public static ConfigurationContext getConfigContext() throws Exception {
        if (configContextService == null) {
            throw new Exception("ConfigurationContextService is null");
        }
        try {
            return configContextService.getServerConfigContext();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception(e);
        }
    }

    public static void setConfigContextService(ConfigurationContextService configContext) {
        configContextService = configContext;
    }

    public static GSOAuthModule.OAuthStoreProvider getOauthStoreProvider() {
        return oauthStoreProvider;
    }

    public static void setOauthStoreProvider(GSOAuthModule.OAuthStoreProvider oauthStoreProvider) {
        OAuthUtils.oauthStoreProvider = oauthStoreProvider;
    }
}

