/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.wso2.carbon.coordination.common.CoordinationException;

public class CoordinationServer
extends Thread {
    private static final Log log = LogFactory.getLog(CoordinationServer.class);
    private QuorumPeerConfig clusteredConfig;
    private ServerConfig standaloneConfig;
    private boolean clustered;

    public CoordinationServer(String configContent) throws CoordinationException {
        Properties configProps = new Properties();
        try {
            configProps.load(new ByteArrayInputStream(configContent.getBytes()));
            this.clusteredConfig = new QuorumPeerConfig();
            this.clusteredConfig.parseProperties(configProps);
            this.clustered = true;
            if (this.getClusteredConfig().getServers().size() == 0) {
                this.standaloneConfig = new ServerConfig();
                this.standaloneConfig.readFrom(this.getClusteredConfig());
                this.clustered = false;
            }
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.CONFIGURATION_ERROR, e);
        }
    }

    private boolean isClustered() {
        return this.clustered;
    }

    private QuorumPeerConfig getClusteredConfig() {
        return this.clusteredConfig;
    }

    private ServerConfig getStandaloneConfig() {
        return this.standaloneConfig;
    }

    @Override
    public void run() {
        try {
            if (this.isClustered()) {
                log.info((Object)"Starting Coordination server in clustered mode...");
                new QuorumPeerMain().runFromConfig(this.getClusteredConfig());
            } else {
                log.info((Object)"Starting Coordination server in standalone mode...");
                new ZooKeeperServerMain().runFromConfig(this.getStandaloneConfig());
            }
        }
        catch (IOException e) {
            log.error((Object)"Error starting Coordination server", (Throwable)e);
        }
    }
}

