/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cluster.mgt.admin.ui;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cluster.mgt.admin.stub.ClusterAdminStub;
import org.wso2.carbon.cluster.mgt.admin.stub.types.carbon.Group;
import org.wso2.carbon.cluster.mgt.admin.stub.types.carbon.GroupMember;

public class ClusterAdminClient {
    private static final Log log = LogFactory.getLog(ClusterAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.cluster.mgt.admin.ui.i18n.Resources";
    private ResourceBundle bundle;
    public ClusterAdminStub stub;

    public ClusterAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "ClusterAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new ClusterAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public Group[] getGroups() throws Exception {
        try {
            return this.stub.getGroups();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.get.groups");
            this.handleException(msg, e);
            return new Group[0];
        }
    }

    public GroupMember[] getMembers(String groupName) throws Exception {
        try {
            return this.stub.getMembers(groupName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.get.members.in.group"), groupName);
            this.handleException(msg, e);
            return new GroupMember[0];
        }
    }

    public void shutdownGroup(String groupName) throws Exception {
        try {
            this.stub.shutdownGroup(groupName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.shutdown.group"), groupName);
            this.handleException(msg, e);
        }
    }

    public void shutdownGroupGracefully(String groupName) throws Exception {
        try {
            this.stub.shutdownGroupGracefully(groupName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.shutdown.group.gracefully"), groupName);
            this.handleException(msg, e);
        }
    }

    public void restartGroup(String groupName) throws Exception {
        try {
            this.stub.restartGroup(groupName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.restart.group"), groupName);
            this.handleException(msg, e);
        }
    }

    public void restartGroupGracefully(String groupName) throws Exception {
        try {
            this.stub.restartGroupGracefully(groupName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.restart.group.gracefully"), groupName);
            this.handleException(msg, e);
        }
    }

    public void shutdownCluster() throws Exception {
        try {
            this.stub.shutdownCluster();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.shutdown.cluster");
            this.handleException(msg, e);
        }
    }

    public void shutdownClusterGracefully() throws Exception {
        try {
            this.stub.shutdownClusterGracefully();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.shutdown.cluster.gracefully");
            this.handleException(msg, e);
        }
    }

    public void restartCluster() throws Exception {
        try {
            this.stub.restartCluster();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.restart.cluster");
            this.handleException(msg, e);
        }
    }

    public void restartClusterGracefully() throws Exception {
        try {
            this.stub.restartClusterGracefully();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.restart.cluster.gracefully");
            this.handleException(msg, e);
        }
    }

    public void startGroupMaintenance(String groupName) throws Exception {
        try {
            this.stub.startGroupMaintenance(groupName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.start.group.maintenance"), groupName);
            this.handleException(msg, e);
        }
    }

    public void endGroupMaintenance(String groupName) throws Exception {
        try {
            this.stub.endGroupMaintenance(groupName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.end.group.maintenance"), groupName);
            this.handleException(msg, e);
        }
    }

    public void startClusterMaintenance() throws Exception {
        try {
            this.stub.startClusterMaintenance();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.start.cluster.maintenance");
            this.handleException(msg, e);
        }
    }

    public void endClusterMaintenance() throws Exception {
        try {
            this.stub.endClusterMaintenance();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.end.cluster.maintenance");
            this.handleException(msg, e);
        }
    }

    private void handleException(String msg, Exception e) throws Exception {
        log.error((Object)msg, (Throwable)e);
        throw new Exception(msg, e);
    }
}

