/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cluster.mgt.admin.ui;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.authenticator.stub.Login;
import org.wso2.carbon.cluster.mgt.admin.ui.ClusterAdminClient;

public class AuthenticationAdminClient {
    private static final Log log = LogFactory.getLog(ClusterAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.cluster.mgt.admin.ui.i18n.Resources";
    private ResourceBundle bundle;
    public AuthenticationAdminStub stub;
    private String backendServerURL;

    public AuthenticationAdminClient(String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "AuthenticationAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.backendServerURL = backendServerURL;
        this.stub = new AuthenticationAdminStub(configCtx, serviceURL);
    }

    public boolean login(HttpServletRequest request, String username, String password) throws Exception {
        log.info((Object)("Logging into " + this.backendServerURL));
        Login loginRequest = new Login();
        loginRequest.setUsername(username);
        loginRequest.setPassword(password);
        loginRequest.setRemoteAddress(request.getRemoteAddr());
        Options option = this.stub._getServiceClient().getOptions();
        option.setManageSession(true);
        boolean isLoggedIn = false;
        try {
            isLoggedIn = this.stub.login(username, password, request.getRemoteAddr());
            if (isLoggedIn) {
                String cookie = (String)this.stub._getServiceClient().getServiceContext().getProperty("Cookie");
                HttpSession session = request.getSession();
                session.setAttribute("wso2carbon.admin.service.cookie", (Object)cookie);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.login.to.server"), this.backendServerURL);
            this.handleException(msg, e);
        }
        return isLoggedIn;
    }

    private void handleException(String msg, Exception e) throws Exception {
        log.error((Object)msg, (Throwable)e);
        throw new Exception(msg, e);
    }
}

