/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cluster.mgt.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.clustering.management.GroupManagementCommand;
import org.apache.axis2.clustering.management.NodeManager;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cluster.mgt.admin.Group;
import org.wso2.carbon.cluster.mgt.admin.GroupMember;
import org.wso2.carbon.cluster.mgt.core.EndMaintenanceCommand;
import org.wso2.carbon.cluster.mgt.core.RestartMemberCommand;
import org.wso2.carbon.cluster.mgt.core.RestartMemberGracefullyCommand;
import org.wso2.carbon.cluster.mgt.core.ShutdownMemberCommand;
import org.wso2.carbon.cluster.mgt.core.ShutdownMemberGracefullyCommand;
import org.wso2.carbon.cluster.mgt.core.StartMaintenanceCommand;

public class ClusterAdmin {
    private static final Log log = LogFactory.getLog(ClusterAdmin.class);

    public GroupMember[] getMembers(String groupName) throws Exception {
        ClusteringAgent clusteringAgent = this.getClusteringAgent();
        GroupManagementAgent groupManagementAgent = clusteringAgent.getGroupManagementAgent(groupName);
        if (groupManagementAgent == null) {
            this.handleException("No GroupManagementAgent defined for domain " + groupName);
            return null;
        }
        List members = groupManagementAgent.getMembers();
        GroupMember[] groupMembers = new GroupMember[members.size()];
        int i = 0;
        for (Member member : members) {
            GroupMember groupMember = new GroupMember();
            groupMember.setHostName(member.getHostName());
            groupMember.setHttpPort(member.getHttpPort());
            groupMember.setHttpsPort(member.getHttpsPort());
            Properties properties = member.getProperties();
            groupMember.setBackendServerURL(properties.getProperty("backendServerURL"));
            groupMember.setMgConsoleURL(properties.getProperty("mgtConsoleURL"));
            groupMembers[i] = groupMember;
            ++i;
        }
        return groupMembers;
    }

    public Group[] getGroups() throws Exception {
        ClusteringAgent clusteringAgent = this.getClusteringAgent();
        ArrayList<Group> groups = new ArrayList<Group>();
        Set groupNames = clusteringAgent.getDomains();
        for (String groupName : groupNames) {
            Group group = new Group();
            group.setName(groupName);
            GroupManagementAgent gmAgent = clusteringAgent.getGroupManagementAgent(groupName);
            List memberList = gmAgent.getMembers();
            group.setDescription(gmAgent.getDescription());
            group.setNumberOfMembers(memberList.size());
            groups.add(group);
        }
        return groups.toArray(new Group[groups.size()]);
    }

    public void shutdownGroup(String groupName) throws Exception {
        GroupManagementAgent groupManagementAgent = this.getGroupManagementAgent(groupName);
        groupManagementAgent.send((GroupManagementCommand)new ShutdownMemberCommand());
    }

    public void restartGroup(String groupName) throws Exception {
        GroupManagementAgent groupManagementAgent = this.getGroupManagementAgent(groupName);
        groupManagementAgent.send((GroupManagementCommand)new RestartMemberCommand());
    }

    public void shutdownGroupGracefully(String groupName) throws Exception {
        GroupManagementAgent groupManagementAgent = this.getGroupManagementAgent(groupName);
        groupManagementAgent.send((GroupManagementCommand)new ShutdownMemberGracefullyCommand());
    }

    public void restartGroupGracefully(String groupName) throws Exception {
        GroupManagementAgent groupManagementAgent = this.getGroupManagementAgent(groupName);
        groupManagementAgent.send((GroupManagementCommand)new RestartMemberGracefullyCommand());
    }

    public void shutdownCluster() throws Exception {
        this.sendToCluster((GroupManagementCommand)new ShutdownMemberCommand());
    }

    public void shutdownClusterGracefully() throws Exception {
        this.sendToCluster((GroupManagementCommand)new ShutdownMemberGracefullyCommand());
    }

    public void restartCluster() throws Exception {
        this.sendToCluster((GroupManagementCommand)new RestartMemberCommand());
    }

    public void restartClusterGracefully() throws Exception {
        this.sendToCluster((GroupManagementCommand)new RestartMemberGracefullyCommand());
    }

    public void startGroupMaintenance(String groupName) throws Exception {
        GroupManagementAgent groupManagementAgent = this.getGroupManagementAgent(groupName);
        groupManagementAgent.send((GroupManagementCommand)new StartMaintenanceCommand());
    }

    public void endGroupMaintenance(String groupName) throws Exception {
        GroupManagementAgent groupManagementAgent = this.getGroupManagementAgent(groupName);
        groupManagementAgent.send((GroupManagementCommand)new EndMaintenanceCommand());
    }

    public void startClusterMaintenance() throws Exception {
        this.sendToCluster((GroupManagementCommand)new StartMaintenanceCommand());
    }

    public void endClusterMaintenance() throws Exception {
        this.sendToCluster((GroupManagementCommand)new EndMaintenanceCommand());
    }

    private void sendToCluster(GroupManagementCommand cmd) throws AxisFault {
        ClusteringAgent clusteringAgent = this.getClusteringAgent();
        Set groupNames = clusteringAgent.getDomains();
        for (String groupName : groupNames) {
            GroupManagementAgent managementAgent = clusteringAgent.getGroupManagementAgent(groupName);
            managementAgent.send(cmd);
        }
    }

    private GroupManagementAgent getGroupManagementAgent(String groupName) throws AxisFault {
        ClusteringAgent clusteringAgent = this.getClusteringAgent();
        GroupManagementAgent groupManagementAgent = clusteringAgent.getGroupManagementAgent(groupName);
        if (groupManagementAgent == null) {
            this.handleException("No GroupManagementAgent defined for domain " + groupName);
        }
        return groupManagementAgent;
    }

    private ClusteringAgent getClusteringAgent() throws AxisFault {
        AxisConfiguration axisConfig = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration();
        ClusteringAgent clusterManager = axisConfig.getClusteringAgent();
        if (clusterManager == null) {
            this.handleException("ClusteringAgent not enabled in axis2.xml file");
        }
        return clusterManager;
    }

    private NodeManager getNodeManager() throws AxisFault {
        ClusteringAgent clusteringAgent = this.getClusteringAgent();
        NodeManager nodeManager = clusteringAgent.getNodeManager();
        if (nodeManager == null) {
            this.handleException("Cluster NodeManager not enabled in axis2.xml file");
        }
        return nodeManager;
    }

    private void handleException(String message) throws AxisFault {
        log.error((Object)message);
        throw new AxisFault(message);
    }
}

