/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.internal;

import java.net.SocketException;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.cloud.csg.common.CSGUtils;
import org.wso2.carbon.cloud.csg.transport.server.CSGThriftServer;
import org.wso2.carbon.cloud.csg.transport.server.CSGThriftServerHandler;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class CSGServiceComponent {
    private static Log log = LogFactory.getLog(CSGServiceComponent.class);
    private ServerConfigurationService serverConfiguration;
    private RealmService realmService;

    protected void activate(ComponentContext ctxt) {
        String hostName;
        if (this.serverConfiguration == null || this.realmService == null) {
            log.error((Object)("Could not activated the CSGServiceComponent. " + (this.serverConfiguration == null ? "ServerConfigurationService" : "RealmService") + "is null!"));
            return;
        }
        try {
            String csgRoleName = CSGUtils.getStringProperty("csg-role-name", "csg");
            this.addCSGUser(csgRoleName, CSGUtils.getPermissionsList(), CSGUtils.getStringProperty("csg-user-name", "csguser"), CSGUtils.getStringProperty("csg-user-password", "csguser"));
        }
        catch (UserStoreException e) {
            log.error((Object)"Cloud not activated the CSGServiceComponent.", (Throwable)e);
            return;
        }
        try {
            hostName = CSGUtils.getCSGThriftServerHostName();
        }
        catch (SocketException e) {
            log.error((Object)"Could not activated the CSGServiceComponent.", (Throwable)e);
            return;
        }
        int port = CSGUtils.getCSGThriftServerPort();
        int timeOut = CSGUtils.getIntProperty("csg-thrift-timeout", 900000);
        String keyStoreURL = CSGUtils.getWSO2KeyStoreFilePath();
        if (keyStoreURL == null) {
            log.error((Object)"KeyStore is missing and required for encryption");
            return;
        }
        String keyStorePassWord = CSGUtils.getWSO2KeyStorePassword();
        if (keyStorePassWord == null) {
            log.error((Object)"KeyStore password is missing");
            return;
        }
        WorkerPool workerPool = WorkerPoolFactory.getWorkerPool((int)CSGUtils.getIntProperty("csg-t-core", 20), (int)CSGUtils.getIntProperty("csg-t-max", 500), (int)CSGUtils.getIntProperty("csg-t-alive-sec", 5), (int)CSGUtils.getIntProperty("csg-t-qlen", -1), (String)"CSGThriftServerHandler-worker-thread-group", (String)"CSGThriftServerHandler-worker");
        CSGThriftServerHandler csgThriftServerHandler = new CSGThriftServerHandler(workerPool);
        CSGThriftServer server = new CSGThriftServer(csgThriftServerHandler);
        try {
            server.start(hostName, port, timeOut, keyStoreURL, keyStorePassWord, "CSG-ThriftServer-main-thread");
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Unable to start thrift server", (Throwable)axisFault);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activated the CSGServiceComponent");
        }
    }

    protected void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (this.realmService != null) {
            this.realmService = null;
        }
    }

    protected void setServerConfiguration(ServerConfigurationService configuration) {
        this.serverConfiguration = configuration;
    }

    protected void unsetServerConfiguration(ServerConfigurationService configuration) {
        this.serverConfiguration = null;
    }

    private void addCSGUser(String roleName, String[] permissionList, String csgUserName, String passWord) throws UserStoreException {
        String[] optimizedList = UserCoreUtil.optimizePermissions((String[])permissionList);
        UserRealm realm = this.realmService.getBootstrapRealm();
        if (realm.getRealmConfiguration().getAdminRoleName().equals(roleName)) {
            throw new UserStoreException("UI permission of admin is not allowed to change!");
        }
        AuthorizationManager authorizationManager = realm.getAuthorizationManager();
        authorizationManager.clearRoleActionOnAllResources(roleName, "ui.execute");
        for (String permission : optimizedList) {
            authorizationManager.authorizeRole(roleName, permission, "ui.execute");
        }
        authorizationManager.authorizeRole(roleName, "/", "add");
        authorizationManager.authorizeRole(roleName, "/", "get");
        authorizationManager.authorizeRole(roleName, "/", "delete");
        UserStoreManager manager = realm.getUserStoreManager();
        if (!manager.isExistingRole(roleName)) {
            manager.addRole(roleName, null, null);
        }
        if (!manager.isExistingUser(csgUserName)) {
            manager.addUser(csgUserName, (Object)passWord, new String[]{roleName}, new HashMap(), null, false);
        }
    }
}

