/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.service;

import java.net.SocketException;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.csg.common.CSGException;
import org.wso2.carbon.cloud.csg.common.CSGProxyToolsURLs;
import org.wso2.carbon.cloud.csg.common.CSGServiceMetaDataBean;
import org.wso2.carbon.cloud.csg.common.CSGThriftServerBean;
import org.wso2.carbon.cloud.csg.common.CSGUtils;
import org.wso2.carbon.cloud.csg.transport.CSGTransportSender;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.proxyadmin.ProxyAdminException;
import org.wso2.carbon.proxyadmin.ProxyData;
import org.wso2.carbon.proxyadmin.service.ProxyServiceAdmin;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.service.mgt.ServiceAdmin;
import org.wso2.carbon.service.mgt.ServiceMetaData;

public class CSGAdminService
extends AbstractServiceBusAdmin {
    private static final Log log = LogFactory.getLog(CSGAdminService.class);

    public void deployProxy(CSGServiceMetaDataBean metaData) throws CSGException {
        if (metaData == null) {
            this.handleException("CSG Service meta data is null");
        }
        try {
            ProxyData proxyData = this.createProxyData(metaData);
            new ProxyServiceAdmin().addProxy(proxyData);
            if (this.getAxisConfig().getTransportOut("csg") == null) {
                this.enableCSGTransportSender(this.getAxisConfig());
            }
        }
        catch (Exception e) {
            this.handleException("Could not deploy the CSG service '" + metaData.getServiceName() + "'. " + e.getMessage(), e);
        }
    }

    public void unDeployProxy(String serviceName) throws CSGException {
        if (serviceName == null) {
            this.handleException("CSG service(proxy service) name is null");
        }
        try {
            new ProxyServiceAdmin().deleteProxyService(serviceName);
            this.deleteWSDL(serviceName);
        }
        catch (ProxyAdminException e) {
            this.handleException("Could not delete the CSG service '" + serviceName + "'. " + e.getMessage(), e);
        }
    }

    public CSGThriftServerBean getThriftServerConnectionBean() throws CSGException {
        CSGThriftServerBean bean;
        try {
            String hostName = CSGUtils.getCSGThriftServerHostName();
            int port = CSGUtils.getCSGThriftServerPort();
            int timeOut = CSGUtils.getIntProperty("csg-thrift-timeout", 900000);
            if (!CSGUtils.isServerAlive(hostName, port)) {
                this.handleException("Thrift server is not running on the host '" + hostName + "'" + " in port '" + port + "'");
            }
            bean = new CSGThriftServerBean();
            bean.setHostName(hostName);
            bean.setPort(port);
            bean.setTimeOut(timeOut);
        }
        catch (SocketException e) {
            throw new CSGException(e);
        }
        return bean;
    }

    public void updateProxy(String serviceName, int eventType) throws CSGException {
        ProxyServiceAdmin proxyAdmin = new ProxyServiceAdmin();
        try {
            if (eventType == 0) {
                proxyAdmin.deleteProxyService(serviceName);
            } else if (eventType == 3) {
                proxyAdmin.startProxyService(serviceName);
            } else if (eventType == 2) {
                proxyAdmin.stopProxyService(serviceName);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("The event SERVICE_DEPLOY is supported for the service '" + serviceName + "'"));
            }
        }
        catch (ProxyAdminException e) {
            this.handleException("Could not update service proxy service '" + serviceName + "'", e);
        }
    }

    public CSGProxyToolsURLs getPublishedProxyToolsURLs(String serviceName, String domainName) throws CSGException {
        try {
            CSGProxyToolsURLs tools = new CSGProxyToolsURLs();
            ServiceMetaData data = new ServiceAdmin().getServiceData(serviceName);
            tools.setTryItURL(data.getTryitURL());
            tools.setWsdl11URL(data.getWsdlURLs()[0]);
            tools.setWsdl2URL(data.getWsdlURLs()[1]);
            tools.setEprArray(data.getEprs());
            return tools;
        }
        catch (Exception e) {
            this.handleException("Could not read the proxy service URL for the service '" + serviceName + "', for the domain '" + domainName + "'", e);
            return null;
        }
    }

    private ProxyData createProxyData(CSGServiceMetaDataBean proxyMetaData) throws CSGException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating the proxy data with following metadata");
            log.debug((Object)("Service Name : " + proxyMetaData.getServiceName()));
            log.debug((Object)("CSGTransport endpoint : " + proxyMetaData.getEndpoint()));
            log.debug((Object)("Has In Out operations? : " + proxyMetaData.isHasInOutMEP()));
            log.debug((Object)("Enable MTOM? : " + proxyMetaData.isMTOMEnabled()));
            log.debug((Object)("Has WS-Sec enabled ? : " + proxyMetaData.isWsSecEnabled()));
            log.debug((Object)("Has WS-RM enabled ? : " + proxyMetaData.isWsRmEnabled()));
            if (proxyMetaData.isWsSecEnabled()) {
                log.debug((Object)("WS-Sec policy : \n" + proxyMetaData.getSecPolicy()));
            }
            if (proxyMetaData.isWsRmEnabled()) {
                log.debug((Object)("WS-RM policy : \n" + proxyMetaData.getRmPolicy()));
            }
            log.debug((Object)("WSDL location : " + proxyMetaData.getWsdlLocation()));
            log.debug((Object)("WSDL : \n" + proxyMetaData.getInLineWSDL()));
        }
        ProxyData proxy = new ProxyData();
        proxy.setName(proxyMetaData.getServiceName());
        if (proxyMetaData.getInLineWSDL() != null) {
            String persistedWsdlPath = this.persistWSDL(proxyMetaData.getServiceName(), proxyMetaData.getInLineWSDL());
            proxy.setWsdlKey(persistedWsdlPath);
        }
        String inSeq = "<inSequence xmlns=\"http://ws.apache.org/ns/synapse\"><class name=\"org.wso2.carbon.cloud.csg.CSGMEPHandlingMediator\"/><property name=\"transportNonBlocking\" scope=\"axis2\" action=\"remove\"/><property name=\"preserveProcessedHeaders\" value=\"true\"/>";
        if (proxyMetaData.isHasInOutMEP()) {
            proxy.setOutSeqXML("<outSequence xmlns=\"http://ws.apache.org/ns/synapse\"><send/></outSequence>");
        } else {
            inSeq = inSeq + "<property name=\"OUT_ONLY\" scope=\"axis2\" action=\"set\" value=\"true\"/>";
        }
        inSeq = inSeq + "</inSequence>";
        proxy.setInSeqXML(inSeq);
        proxy.setFaultSeqXML("<faultSequence xmlns=\"http://ws.apache.org/ns/synapse\"><log level=\"full\"/><drop/></faultSequence>");
        String endpointXML = "<endpoint xmlns=\"http://ws.apache.org/ns/synapse\"><address uri=\"" + proxyMetaData.getEndpoint() + "\">" + "<suspendOnFailure>" + "<errorCodes>400207</errorCodes>" + "<initialDuration>1000</initialDuration>" + "<progressionFactor>2</progressionFactor>" + "<maximumDuration>64000</maximumDuration>" + "</suspendOnFailure>" + "</address>" + "</endpoint>";
        proxy.setEndpointXML(endpointXML);
        return proxy;
    }

    private void handleException(String msg) throws CSGException {
        log.error((Object)msg);
        throw new CSGException(msg);
    }

    private void handleException(String msg, Throwable t) throws CSGException {
        log.error((Object)msg, t);
        throw new CSGException(msg, t);
    }

    private void enableCSGTransportSender(AxisConfiguration axisConfig) throws Exception {
        CSGTransportSender sender = new CSGTransportSender();
        TransportOutDescription transportOut = new TransportOutDescription("csg");
        transportOut.setSender((TransportSender)sender);
        axisConfig.addTransportOut(transportOut);
        transportOut.getSender().init(this.getConfigContext(), transportOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String persistWSDL(String serviceName, String wsdl) throws CSGException {
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        Registry registry = this.getGovernanceUserRegistry();
        String resourcePath = this.composeWsdlResourcePath(serviceName);
        try {
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            if (registry.resourceExists(resourcePath)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Replacing the Wsdl for the service: " + serviceName));
                }
                registry.delete(resourcePath);
            }
            Resource resource = registry.newResource();
            resource.setContent((Object)wsdl);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding wsdl to registry. Service name: " + serviceName));
            }
            registry.put(resourcePath, (org.wso2.carbon.registry.api.Resource)resource);
        }
        catch (RegistryException e) {
            isTransactionSuccess = false;
            this.handleException("Error occurred while saving the wsdl into registry", e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException re) {
                    this.handleException("Error occurred while trying to rollback or commit the transaction", re);
                }
            }
        }
        return resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteWSDL(String serviceName) throws CSGException {
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        Registry registry = this.getGovernanceUserRegistry();
        String resourcePath = this.composeWsdlResourcePath(serviceName);
        try {
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            if (registry.resourceExists(resourcePath)) {
                registry.delete(resourcePath);
            }
        }
        catch (RegistryException e) {
            isTransactionSuccess = false;
            this.handleException("Error occurred while deleting the wsdl from registry", e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException re) {
                    this.handleException("Error occurred while trying to rollback or commit the transaction", re);
                }
            }
        }
    }

    private String composeWsdlResourcePath(String serviceName) {
        return "/trunk/services/wsdls/" + serviceName + ".wsdl";
    }
}

