/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.delivery.jms;

import java.net.SocketException;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.event.client.stub.generated.authentication.AuthenticationAdminServiceStub;
import org.wso2.carbon.event.client.stub.generated.authentication.AuthenticationExceptionException;
import org.wso2.carbon.event.core.delivery.DeliveryManager;
import org.wso2.carbon.event.core.delivery.DeliveryManagerFactory;
import org.wso2.carbon.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.event.core.internal.delivery.jms.QpidJMSDeliveryManager;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.internal.util.JavaUtil;
import org.wso2.carbon.qpid.stub.service.QpidAdminServiceStub;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class QpidJMSDeliveryManagerFactory
implements DeliveryManagerFactory {
    public static final String EB_REMOTE_MESSGE_BROKER = "remoteMessageBroker";
    public static final String EB_HOST_NAME = "hostName";
    public static final String EB_SERVICE_PORT = "servicePort";
    public static final String EB_WEB_CONTEXT = "webContext";
    public static final String EB_USER_NAME = "userName";
    public static final String EB_PASSWORD = "password";
    public static final String EB_QPID_PORT = "qpidPort";
    public static final String EB_CLIENT_ID = "clientID";
    public static final String EB_VIRTUAL_HOST_NAME = "virtualHostName";
    public static final String EB_TYPE = "type";
    public static final String EB_REMOTE_MESSAGE_BROKER_PASSWORD_ALIAS = "eventBrokerConfig.eventBroker.deliveryManager.remoteMessageBroker.password";

    @Override
    public DeliveryManager getDeliveryManger(OMElement config) throws EventBrokerConfigurationException {
        String type = config.getAttributeValue(new QName(null, EB_TYPE));
        QpidJMSDeliveryManager qpidJMSDelivaryManager = new QpidJMSDeliveryManager(type);
        if ("remote".equals(type)) {
            OMElement remoteQpidAdminService = config.getFirstChildWithName(new QName("http://wso2.org/carbon/event/broker", EB_REMOTE_MESSGE_BROKER));
            String hostName = JavaUtil.getValue(remoteQpidAdminService, EB_HOST_NAME);
            String servicePort = JavaUtil.getValue(remoteQpidAdminService, EB_SERVICE_PORT);
            String webContext = JavaUtil.getValue(remoteQpidAdminService, EB_WEB_CONTEXT);
            if (!webContext.endsWith("/")) {
                webContext = webContext + "/";
            }
            String userName = JavaUtil.getValue(remoteQpidAdminService, EB_USER_NAME);
            String password = JavaUtil.getValue(remoteQpidAdminService, EB_PASSWORD);
            SecretResolver secretResolver = SecretResolverFactory.create((OMElement)remoteQpidAdminService, (boolean)false);
            if (secretResolver != null && secretResolver.isInitialized()) {
                if (secretResolver.isTokenProtected(EB_REMOTE_MESSAGE_BROKER_PASSWORD_ALIAS)) {
                    password = secretResolver.resolve(EB_REMOTE_MESSAGE_BROKER_PASSWORD_ALIAS);
                } else {
                    throw new EventBrokerConfigurationException("Can not resolve password for remote message broker from secret resolver.");
                }
            }
            String qpidPort = JavaUtil.getValue(remoteQpidAdminService, EB_QPID_PORT);
            String clientID = JavaUtil.getValue(remoteQpidAdminService, EB_CLIENT_ID);
            String virtualHostName = JavaUtil.getValue(remoteQpidAdminService, EB_VIRTUAL_HOST_NAME);
            ConfigurationContext clientConfigurationContext = EventBrokerHolder.getInstance().getConfigurationContextService().getClientConfigContext();
            try {
                String servicesString = "https://" + hostName + ":" + servicePort + webContext + "services/";
                AuthenticationAdminServiceStub stub = new AuthenticationAdminServiceStub(clientConfigurationContext, servicesString + "AuthenticationAdmin");
                stub._getServiceClient().getOptions().setManageSession(true);
                boolean isAuthenticated = stub.login(userName, password, NetworkUtils.getLocalHostname());
                if (!isAuthenticated) {
                    throw new EventBrokerConfigurationException("Can not authenticate to the remote messge broker ");
                }
                ServiceContext serviceContext = stub._getServiceClient().getLastOperationContext().getServiceContext();
                String sessionCookie = (String)serviceContext.getProperty("Cookie");
                QpidAdminServiceStub qpidAdminServiceStub = new QpidAdminServiceStub(clientConfigurationContext, servicesString + "QpidAdminService");
                qpidAdminServiceStub._getServiceClient().getOptions().setManageSession(true);
                qpidAdminServiceStub._getServiceClient().getOptions().setProperty("Cookie", (Object)sessionCookie);
                String accessKey = qpidAdminServiceStub.getAccessKey();
                qpidJMSDelivaryManager.setHostName(hostName);
                qpidJMSDelivaryManager.setAccessKey(accessKey);
                qpidJMSDelivaryManager.setQpidPort(qpidPort);
                qpidJMSDelivaryManager.setClientID(clientID);
                qpidJMSDelivaryManager.setVirtualHostName(virtualHostName);
            }
            catch (AxisFault axisFault) {
                throw new EventBrokerConfigurationException("Can not connect to the remote Qpid Service ", axisFault);
            }
            catch (SocketException e) {
                throw new EventBrokerConfigurationException("Can not connect to the remote Qpid Service ", e);
            }
            catch (AuthenticationExceptionException e) {
                throw new EventBrokerConfigurationException("Can not connect to the remote Qpid Service ", e);
            }
            catch (RemoteException e) {
                throw new EventBrokerConfigurationException("Can not connect to the remote Qpid Service ", e);
            }
        }
        return qpidJMSDelivaryManager;
    }
}

