/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.TemplateMediatorSerializer;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.TemplateRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class TemplateStore
extends AbstractStore<TemplateMediator> {
    public TemplateStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new TemplateRegistryStore(registry, configName);
        }
    }

    @Override
    protected String getFileName(TemplateMediator template) {
        return template.getFileName();
    }

    @Override
    protected TemplateMediator getObjectToPersist(String name, SynapseConfiguration config) {
        return (TemplateMediator)config.getSequenceTemplates().get(name);
    }

    @Override
    protected OMElement saveToFile(TemplateMediator template, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeTemplate(template, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the template: " + template.getName() + " to the " + "file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(TemplateMediator sequence) {
        TemplateMediatorSerializer serializer = new TemplateMediatorSerializer();
        return serializer.serializeMediator(null, (Mediator)sequence);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfig) {
        File templateDir = new File(this.configPath, "templates");
        if (!templateDir.exists()) {
            return;
        }
        File templateFile = new File(templateDir, fileName);
        synapseConfig.getArtifactDeploymentStore().addBackedUpArtifact(templateFile.getAbsolutePath());
        templateFile.delete();
    }
}

