/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.multitenancy;

import java.io.File;
import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerConfigurationInformationFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerManager;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapseConfigurationBuilder;
import org.apache.synapse.config.xml.MultiXMLConfigurationSerializer;
import org.apache.synapse.deployers.ExtensionDeployer;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.apache.synapse.task.TaskScheduler;
import org.osgi.framework.ServiceRegistration;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.mediation.dependency.mgt.services.ConfigurationTrackingService;
import org.wso2.carbon.mediation.initializer.CarbonSynapseController;
import org.wso2.carbon.mediation.initializer.ServiceBusInitializer;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationManager;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationServiceImpl;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentServiceImpl;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsServiceImpl;
import org.wso2.carbon.mediation.initializer.utils.ConfigurationHolder;
import org.wso2.carbon.mediation.registry.WSO2Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class TenantServiceBusInitializer
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(TenantServiceBusInitializer.class);

    public void createdConfigurationContext(ConfigurationContext configurationContext) {
        String tenantDomain = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantDomain();
        log.info((Object)("Intializing the ESB Configuration for the tenant domain : " + tenantDomain));
        try {
            EventBroker eventBroker;
            org.wso2.carbon.registry.core.Registry registry = (org.wso2.carbon.registry.core.Registry)SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getRegistry(RegistryType.SYSTEM_CONFIGURATION);
            AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
            ReentrantLock lock = new ReentrantLock();
            axisConfig.addParameter("synapse.config.lock", (Object)lock);
            File tenantAxis2Repo = new File(configurationContext.getAxisConfiguration().getRepository().getFile());
            File synapseConfigsDir = new File(tenantAxis2Repo, "synapse-configs");
            if (!synapseConfigsDir.exists() && !synapseConfigsDir.mkdir()) {
                log.fatal((Object)("Couldn't create the synapse-config root on the file system for the tenant domain : " + tenantDomain));
                return;
            }
            String synapseConfigsDirLocation = synapseConfigsDir.getAbsolutePath();
            axisConfig.addParameter("SynapseConfig.ConfigurationFile", (Object)synapseConfigsDirLocation);
            ConfigurationManager manger = new ConfigurationManager((UserRegistry)registry, configurationContext);
            manger.init();
            File synapseConfigDir = new File(synapseConfigsDir, manger.getTracker().getCurrentConfigurationName());
            if (!synapseConfigDir.exists()) {
                this.createTenantSynapseConfigHierarchy(synapseConfigDir, tenantDomain);
            }
            axisConfig.addParameter("SynapseConfig.HomeDirectory", (Object)tenantAxis2Repo.getAbsolutePath());
            axisConfig.addParameter("SynapseConfig.ServerName", (Object)("synapse." + tenantDomain));
            axisConfig.addParameter("SynapseConfig.ResolveRoot", (Object)tenantAxis2Repo.getAbsolutePath());
            ServerContextInformation contextInfo = this.initESB(manger.getTracker().getCurrentConfigurationName(), configurationContext);
            if (contextInfo == null) {
                this.handleFatal("Failed to intilize the ESB for tenent:" + tenantDomain);
            }
            this.initPersistence(manger.getTracker().getCurrentConfigurationName(), configurationContext, contextInfo);
            configurationContext.setProperty("CONFIGURATION_MANAGER", (Object)manger);
            int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantId();
            Properties props = new Properties();
            SynapseConfigurationServiceImpl synCfgSvc = new SynapseConfigurationServiceImpl(contextInfo.getSynapseConfiguration(), tenantId, configurationContext);
            ServiceRegistration confRegistration = ConfigurationHolder.getInstance().getBundleContext().registerService(SynapseConfigurationService.class.getName(), (Object)synCfgSvc, (Dictionary)props);
            props = new Properties();
            SynapseEnvironmentServiceImpl synEnvSvc = new SynapseEnvironmentServiceImpl(contextInfo.getSynapseEnvironment(), tenantId, configurationContext);
            ServiceRegistration envRegistration = ConfigurationHolder.getInstance().getBundleContext().registerService(SynapseEnvironmentService.class.getName(), (Object)synEnvSvc, (Dictionary)props);
            props = new Properties();
            SynapseRegistrationsServiceImpl synRegistrationsSvc = new SynapseRegistrationsServiceImpl(confRegistration, envRegistration, tenantId, configurationContext);
            ServiceRegistration synapseRegistration = ConfigurationHolder.getInstance().getBundleContext().registerService(SynapseRegistrationsService.class.getName(), (Object)synRegistrationsSvc, (Dictionary)props);
            ConfigurationTrackingService trackingService = ServiceBusInitializer.getConfigurationTrackingService();
            if (trackingService != null) {
                trackingService.setSynapseConfiguration(contextInfo.getSynapseConfiguration());
            }
            if ((eventBroker = ServiceBusInitializer.getEventBroker()) != null) {
                configurationContext.setProperty("mediation.event.broker", (Object)eventBroker);
            }
            ConfigurationHolder.getInstance().addSynapseRegistration(tenantId, synapseRegistration);
        }
        catch (Exception e) {
            this.handleFatal("Couldn't initialize the ESB for tenant:" + tenantDomain, e);
        }
        catch (Throwable t) {
            log.fatal((Object)("Failed to initialize ESB for tenant:" + tenantDomain + "due to a fatal error"), t);
        }
    }

    public void terminatingConfigurationContext(ConfigurationContext configurationContext) {
        String tenantDomain = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantDomain();
        log.info((Object)("Shutting down the persistence manager for the tenant: " + tenantDomain));
        Parameter p = configurationContext.getAxisConfiguration().getParameter("PERSISTENCE_MANAGER");
        if (p != null && p.getValue() instanceof MediationPersistenceManager) {
            ((MediationPersistenceManager)p.getValue()).destroy();
        }
        int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantId();
        ServiceRegistration tenantRegistration = ConfigurationHolder.getInstance().getSynapseRegistration(tenantId);
        if (tenantRegistration != null) {
            ConfigurationHolder.getInstance().getBundleContext().ungetService(tenantRegistration.getReference());
        }
    }

    private void initPersistence(String configName, ConfigurationContext configurationContext, ServerContextInformation contextInfo) throws RegistryException, AxisFault {
        ServerConfiguration serverConf = ServerConfiguration.getInstance();
        String persistence = serverConf.getFirstProperty("MediationConfig.Persistence");
        org.wso2.carbon.registry.core.Registry configRegistry = (org.wso2.carbon.registry.core.Registry)SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        if (!"disabled".equals(persistence)) {
            String regPersistence = serverConf.getFirstProperty("MediationConfig.RegistryPersistence");
            UserRegistry registry = "disabled".equals(regPersistence) ? null : (UserRegistry)configRegistry;
            String interval = serverConf.getFirstProperty("MediationConfig.WorkerInterval");
            long intervalInMillis = 5000L;
            if (interval != null && !"".equals(interval)) {
                try {
                    intervalInMillis = Long.parseLong(interval);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Invalid value " + interval + " specified for the mediation " + "persistence worker interval, Using defaults"), (Throwable)e);
                }
            }
            MediationPersistenceManager pm = new MediationPersistenceManager(registry, contextInfo.getServerConfigurationInformation().getSynapseXMLLocation(), contextInfo.getSynapseConfiguration(), intervalInMillis, configName);
            configurationContext.getAxisConfiguration().addParameter(new Parameter("PERSISTENCE_MANAGER", (Object)pm));
        } else {
            log.info((Object)"Persistence for mediation configuration is disabled");
        }
    }

    private ServerContextInformation initESB(String configurationName, ConfigurationContext configurationContext) throws AxisFault {
        TaskDescriptionRepository repository;
        TaskScheduler scheduler;
        ServerConfigurationInformation configurationInformation = ServerConfigurationInformationFactory.createServerConfigurationInformation((AxisConfiguration)configurationContext.getAxisConfiguration());
        if (System.getProperty("SynapseServerName") != null) {
            configurationInformation.setServerName(System.getProperty("SynapseServerName"));
        }
        String repoPath = configurationContext.getAxisConfiguration().getRepository().getPath();
        configurationInformation.setSynapseXMLLocation(repoPath + File.separator + "synapse-configs" + File.separator + configurationName);
        configurationInformation.setCreateNewInstance(false);
        configurationInformation.setServerControllerProvider(CarbonSynapseController.class.getName());
        if (TenantServiceBusInitializer.isRunningSamplesMode()) {
            configurationInformation.setSynapseXMLLocation("repository" + File.separator + "samples" + File.separator + "synapse_sample_" + System.getProperty("esb.sample") + ".xml");
        }
        ServerManager serverManager = new ServerManager();
        ServerContextInformation contextInfo = new ServerContextInformation((Object)configurationContext, configurationInformation);
        if (configurationContext.getProperty("CARBON_TASK_SCHEDULER") == null) {
            scheduler = new TaskScheduler("task_scheduler");
            configurationContext.setProperty("CARBON_TASK_SCHEDULER", (Object)scheduler);
        } else {
            scheduler = (TaskScheduler)configurationContext.getProperty("CARBON_TASK_SCHEDULER");
        }
        contextInfo.addProperty("task_scheduler", (Object)scheduler);
        if (configurationContext.getProperty("CARBON_TASK_REPOSITORY") == null) {
            repository = new TaskDescriptionRepository();
            configurationContext.setProperty("CARBON_TASK_REPOSITORY", (Object)repository);
        } else {
            repository = (TaskDescriptionRepository)configurationContext.getProperty("CARBON_TASK_REPOSITORY");
        }
        contextInfo.addProperty("task_description_repository", (Object)repository);
        AxisConfiguration axisConf = configurationContext.getAxisConfiguration();
        axisConf.addParameter(new Parameter("SYNAPSE_CURRENT_CONFIGURATION", (Object)configurationName));
        serverManager.init(configurationInformation, contextInfo);
        serverManager.start();
        AxisServiceGroup serviceGroup = axisConf.getServiceGroup("__SynapseService");
        serviceGroup.addParameter("hiddenService", (Object)"true");
        this.addDeployers(configurationContext);
        return contextInfo;
    }

    private void createTenantSynapseConfigHierarchy(File synapseConfigDir, String tenantDomain) {
        if (!synapseConfigDir.mkdir()) {
            log.fatal((Object)("Couldn't create the synapse-config root on the file system for the tenant domain : " + tenantDomain));
            return;
        }
        File sequencesDir = new File(synapseConfigDir, "sequences");
        File endpointsDir = new File(synapseConfigDir, "endpoints");
        File entriesDir = new File(synapseConfigDir, "local-entries");
        File proxyServicesDir = new File(synapseConfigDir, "proxy-services");
        File eventSourcesDir = new File(synapseConfigDir, "event-sources");
        File tasksDir = new File(synapseConfigDir, "tasks");
        File executorsDir = new File(synapseConfigDir, "priority-executors");
        if (!sequencesDir.mkdir()) {
            log.warn((Object)("Could not create " + sequencesDir));
        }
        if (!endpointsDir.mkdir()) {
            log.warn((Object)("Could not create " + endpointsDir));
        }
        if (!entriesDir.mkdir()) {
            log.warn((Object)("Could not create " + entriesDir));
        }
        if (!proxyServicesDir.mkdir()) {
            log.warn((Object)("Could not create " + proxyServicesDir));
        }
        if (!eventSourcesDir.mkdir()) {
            log.warn((Object)("Could not create " + eventSourcesDir));
        }
        if (!tasksDir.mkdir()) {
            log.warn((Object)("Could not create " + tasksDir));
        }
        if (!executorsDir.mkdir()) {
            log.warn((Object)("Could not create " + executorsDir));
        }
        SynapseConfiguration initialSynCfg = SynapseConfigurationBuilder.getDefaultConfiguration();
        SequenceMediator mainSequence = (SequenceMediator)initialSynCfg.getMainSequence();
        SequenceMediator faultSequence = (SequenceMediator)initialSynCfg.getFaultSequence();
        mainSequence.setFileName("main.xml");
        faultSequence.setFileName("fault.xml");
        WSO2Registry registry = new WSO2Registry();
        initialSynCfg.setRegistry((Registry)registry);
        MultiXMLConfigurationSerializer serializer = new MultiXMLConfigurationSerializer(synapseConfigDir.getAbsolutePath());
        try {
            serializer.serializeSequence(mainSequence, initialSynCfg, null);
            serializer.serializeSequence(faultSequence, initialSynCfg, null);
            serializer.serializeSynapseRegistry((Registry)registry, initialSynCfg, null);
        }
        catch (Exception e) {
            this.handleException("Couldn't serialise the initial synapse configuration for the domain : " + tenantDomain, e);
        }
    }

    private void addDeployers(ConfigurationContext configurationContext) {
        AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        String carbonRepoPath = configurationContext.getAxisConfiguration().getRepository().getFile();
        String mediatorsPath = carbonRepoPath + File.separator + "mediators";
        String extensionsPath = carbonRepoPath + File.separator + "extensions";
        ExtensionDeployer deployer = new ExtensionDeployer();
        deploymentEngine.addDeployer((Deployer)deployer, mediatorsPath, "xar");
        deploymentEngine.addDeployer((Deployer)deployer, extensionsPath, "xar");
        deploymentEngine.addDeployer((Deployer)deployer, mediatorsPath, "jar");
        deploymentEngine.addDeployer((Deployer)deployer, extensionsPath, "jar");
    }

    public static boolean isRunningSamplesMode() {
        return System.getProperty("esb.sample") != null;
    }

    private void handleFatal(String message) {
        log.fatal((Object)message);
    }

    private void handleFatal(String message, Exception e) {
        log.fatal((Object)message, (Throwable)e);
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
    }
}

