/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.configurations;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapseConfigurationBuilder;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.apache.synapse.task.TaskScheduler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationInformation;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationInitilizerException;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationTracker;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationServiceImpl;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentServiceImpl;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsServiceImpl;
import org.wso2.carbon.mediation.initializer.utils.ConfigurationHolder;
import org.wso2.carbon.mediation.registry.WSO2Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ConfigurationManager {
    private static Log log = LogFactory.getLog(ConfigurationManager.class);
    public static final String CONFIGURATION_MANAGER = "CONFIGURATION_MANAGER";
    private String synpaseConfigurationsRoot = "repository/deployment/server/synapse-configs";
    private ConfigurationTracker tracker;
    private UserRegistry registry = null;
    private ConfigurationContext configurationContext;
    private int tenantId = -1234;

    public ConfigurationManager(UserRegistry registry, ConfigurationContext configurationContext) {
        if (registry == null) {
            throw new IllegalArgumentException("Registry is required");
        }
        if (configurationContext == null) {
            throw new IllegalArgumentException("ConfigurationContext is required");
        }
        this.registry = registry;
        this.configurationContext = configurationContext;
    }

    public void init() throws ConfigurationInitilizerException {
        this.tracker = new ConfigurationTracker(this.registry);
        try {
            this.tracker.init();
            Parameter parameter = this.configurationContext.getAxisConfiguration().getParameter("SynapseConfig.ConfigurationFile");
            if (parameter != null && parameter.getValue() != null) {
                this.synpaseConfigurationsRoot = parameter.getValue().toString();
            }
            this.tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)this.configurationContext).getTenantId();
        }
        catch (RegistryException e) {
            this.handleException("Cannot initialize the configuration tracker: ", (Exception)((Object)e));
        }
    }

    public ConfigurationTracker getTracker() {
        return this.tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(String name) throws ConfigurationInitilizerException {
        try {
            if (!this.tracker.isConfigurationExists(name)) {
                this.handleException("Trying to load the configuration: " + name + " that doesn't have a record");
            }
            SynapseConfiguration newSynapseConfiguration = null;
            SynapseConfiguration oldSynapseConfiguration = this.getSynapseConfiguration();
            SynapseEnvironment oldSynapseEnvironment = this.getSynapseEnvironment();
            TaskDescriptionRepository repository = this.getSynapseEnvironment().getTaskManager().getTaskDescriptionRepository();
            TaskScheduler taskScheduler = this.getSynapseEnvironment().getTaskManager().getTaskScheduler();
            int loadLocation = 0;
            if (!this.tracker.isConfigurationCreated(name)) {
                ConfigurationInformation information = this.tracker.getConfigurationInformation(name);
                newSynapseConfiguration = this.createDefaultConfiguration();
                if (information != null && information.getDescription() != null) {
                    newSynapseConfiguration.setDescription(information.getDescription());
                }
                loadLocation = 1;
                log.info((Object)("A default Synapse Configuration is created for the configuration: " + name));
            }
            Properties properties = SynapsePropertiesLoader.loadSynapseProperties();
            if (this.getServerConfigurationInformation().getResolveRoot() != null) {
                properties.put("resolve.root", this.getServerConfigurationInformation().getResolveRoot());
            }
            if (this.getServerConfigurationInformation().getSynapseHome() != null) {
                properties.put("synapse.home", this.getServerConfigurationInformation().getSynapseHome());
            }
            if (loadLocation != 1) {
                if (this.isLoadFromRegistry()) {
                    newSynapseConfiguration = ConfigurationUtils.loadFromRegistry(this.registry, name, this.synpaseConfigurationsRoot + File.separator + name, properties);
                    if (newSynapseConfiguration != null) {
                        log.info((Object)("Successfully loaded the Synapse Configuration: " + name + " from the registry"));
                        loadLocation = 2;
                    } else {
                        log.warn((Object)("Failed to load Synapse Configuration: " + name + " from the registry, " + "trying to load from the file system"));
                    }
                }
                if (newSynapseConfiguration == null) {
                    newSynapseConfiguration = SynapseConfigurationBuilder.getConfiguration((String)(this.synpaseConfigurationsRoot + File.separator + name), (Properties)properties);
                    if (newSynapseConfiguration != null) {
                        log.info((Object)("Successfully loaded the Synapse Configuration: " + name + " from the file system"));
                        loadLocation = 3;
                    } else {
                        log.warn((Object)("Failed to load the Synapse Configuration: " + name));
                        return false;
                    }
                }
            }
            SynapseConfiguration synapseConfiguration = oldSynapseConfiguration;
            synchronized (synapseConfiguration) {
                this.getMediationPersistenceManager().destroy();
                try {
                    ConfigurationUtils.destroyConfiguration(oldSynapseConfiguration, this.configurationContext.getAxisConfiguration(), oldSynapseEnvironment);
                }
                catch (Exception e) {
                    log.warn((Object)"Error while destroying the current configuration.. Continuing to load the new configuration");
                }
            }
            newSynapseConfiguration.setPathToConfigFile(this.synpaseConfigurationsRoot + File.separator + name);
            this.getServerConfigurationInformation().setSynapseXMLLocation(this.synpaseConfigurationsRoot + File.separator + name);
            if (loadLocation == 1) {
                ConfigurationUtils.saveToRegistry(this.registry, newSynapseConfiguration, name);
                ConfigurationUtils.saveToFileSystem(newSynapseConfiguration);
            } else if (loadLocation == 2) {
                if ("true".equals(ConfigurationUtils.getParameter("MediationConfig.SaveToFile"))) {
                    ConfigurationUtils.saveToFileSystem(newSynapseConfiguration);
                }
            } else {
                ConfigurationUtils.saveToRegistry(this.registry, newSynapseConfiguration, name);
            }
            this.tracker.activate(name);
            this.configurationContext.getAxisConfiguration().addParameter(new Parameter("SYNAPSE_CURRENT_CONFIGURATION", (Object)name));
            this.tracker.update(name, true);
            this.initializeConfiguration(this.synpaseConfigurationsRoot + File.separator + name, oldSynapseConfiguration, newSynapseConfiguration, repository, taskScheduler);
            ConfigurationUtils.initPersistence(newSynapseConfiguration, this.registry, this.synpaseConfigurationsRoot + File.separator + name, this.configurationContext.getAxisConfiguration(), name);
            this.unregisterServices();
            this.registerServices();
            return true;
        }
        catch (RegistryException e) {
            this.handleException("Error accessing the registry resources", (Exception)((Object)e));
        }
        catch (AxisFault axisFault) {
            this.handleException("Error while setting up the new configuration");
        }
        return false;
    }

    private void registerServices() {
        SynapseEnvironment synEnv = this.getSynapseEnvironment();
        SynapseConfiguration synConfig = this.getSynapseConfiguration();
        SynapseConfigurationServiceImpl synCfgSvc = new SynapseConfigurationServiceImpl(synConfig, this.tenantId, this.configurationContext);
        Properties props = new Properties();
        ServiceRegistration confRegistration = ConfigurationHolder.getInstance().getBundleContext().registerService(SynapseConfigurationService.class.getName(), (Object)synCfgSvc, (Dictionary)props);
        props = new Properties();
        SynapseEnvironmentServiceImpl synEnvSvc = new SynapseEnvironmentServiceImpl(synEnv, this.tenantId, this.configurationContext);
        ServiceRegistration envRegistration = ConfigurationHolder.getInstance().getBundleContext().registerService(SynapseEnvironmentService.class.getName(), (Object)synEnvSvc, (Dictionary)props);
        props = new Properties();
        SynapseRegistrationsServiceImpl synRegistrationsSvc = new SynapseRegistrationsServiceImpl(confRegistration, envRegistration, this.tenantId, this.configurationContext);
        ServiceRegistration synapseRegistration = ConfigurationHolder.getInstance().getBundleContext().registerService(SynapseRegistrationsService.class.getName(), (Object)synRegistrationsSvc, (Dictionary)props);
    }

    private void unregisterServices() {
        BundleContext bundleContext = ConfigurationHolder.getInstance().getBundleContext();
        ServiceRegistration serviceRegistration = ConfigurationHolder.getInstance().getSynapseRegistration(this.tenantId);
        if (serviceRegistration != null) {
            ServiceRegistration synEnvServiceRegistration;
            SynapseRegistrationsService synapseRegistrationsService = (SynapseRegistrationsService)bundleContext.getService(serviceRegistration.getReference());
            ServiceRegistration synConfigServiceRegistration = synapseRegistrationsService.getSynapseConfigurationServiceRegistration();
            if (synConfigServiceRegistration != null) {
                bundleContext.ungetService(synConfigServiceRegistration.getReference());
            }
            if ((synEnvServiceRegistration = synapseRegistrationsService.getSynapseEnvironmentServiceRegistration()) != null) {
                bundleContext.ungetService(synEnvServiceRegistration.getReference());
            }
            bundleContext.ungetService(serviceRegistration.getReference());
        }
    }

    private SynapseConfiguration createDefaultConfiguration() {
        SynapseConfiguration newSynapseConfiguration = SynapseConfigurationBuilder.getDefaultConfiguration();
        SequenceMediator mainSequence = (SequenceMediator)newSynapseConfiguration.getMainSequence();
        mainSequence.setFileName(mainSequence.getName());
        SequenceMediator faultSequence = (SequenceMediator)newSynapseConfiguration.getFaultSequence();
        faultSequence.setFileName(faultSequence.getName());
        WSO2Registry registry = new WSO2Registry();
        newSynapseConfiguration.setRegistry((Registry)registry);
        newSynapseConfiguration.setProperty("__separateRegDef", "true");
        return newSynapseConfiguration;
    }

    public void delete(String name) throws ConfigurationInitilizerException {
        try {
            this.tracker.delete(name);
        }
        catch (RegistryException e) {
            this.handleException("Failed to delete the configuration: " + name, (Exception)((Object)e));
        }
    }

    public void create(String name, String description) throws ConfigurationInitilizerException {
        try {
            this.tracker.create(name, description);
        }
        catch (RegistryException e) {
            this.handleException("Failed to create configuration: " + name, (Exception)((Object)e));
        }
    }

    public List<ConfigurationInformation> getConfigurationsList() throws ConfigurationInitilizerException {
        try {
            return this.tracker.getConfigurationList();
        }
        catch (RegistryException e) {
            this.handleException("Failed to get the configurations list", (Exception)((Object)e));
            return null;
        }
    }

    public void addExistingConfiguration(String name) throws ConfigurationInitilizerException {
        try {
            if (this.tracker.isConfigurationExists(name)) {
                String msg = "Configuration already exists in the available configurations list. Cannot add it again.";
                log.warn((Object)msg);
                throw new ConfigurationInitilizerException(msg);
            }
            this.tracker.create(name, "");
            this.tracker.update(name, true);
        }
        catch (RegistryException e) {
            this.handleException("Failed to add the existing configuration: " + name, (Exception)((Object)e));
        }
    }

    private void initializeConfiguration(String configurationLocation, SynapseConfiguration oldSynapseConfiguration, SynapseConfiguration newSynapseConfiguration, TaskDescriptionRepository repository, TaskScheduler taskScheduler) throws ConfigurationInitilizerException, AxisFault {
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        newSynapseConfiguration.setAxisConfiguration(axisConfiguration);
        Entry hostEntry = oldSynapseConfiguration.getEntryDefinition("SERVER_HOST");
        Entry ipEntry = oldSynapseConfiguration.getEntryDefinition("SERVER_IP");
        Properties properties = SynapsePropertiesLoader.loadSynapseProperties();
        if (properties != null) {
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                newSynapseConfiguration.setProperty(key, properties.getProperty(key));
            }
        }
        newSynapseConfiguration.setPathToConfigFile(configurationLocation);
        newSynapseConfiguration.addEntry("SERVER_HOST", hostEntry);
        newSynapseConfiguration.addEntry("SERVER_IP", ipEntry);
        if (newSynapseConfiguration.getMainSequence() == null) {
            SynapseConfigUtils.setDefaultMainSequence((SynapseConfiguration)newSynapseConfiguration);
        }
        if (newSynapseConfiguration.getFaultSequence() == null) {
            SynapseConfigUtils.setDefaultFaultSequence((SynapseConfiguration)newSynapseConfiguration);
        }
        ServerContextInformation contextInformation = this.getServerContextInformation();
        newSynapseConfiguration.setAxisConfiguration(axisConfiguration);
        Parameter synapseCtxParam = new Parameter("synapse.config", null);
        synapseCtxParam.setValue((Object)newSynapseConfiguration);
        MessageContextCreatorForAxis2.setSynConfig((SynapseConfiguration)newSynapseConfiguration);
        Parameter synapseEnvParam = new Parameter("synapse.env", null);
        Axis2SynapseEnvironment synEnv = new Axis2SynapseEnvironment(this.configurationContext, newSynapseConfiguration, contextInformation);
        synapseEnvParam.setValue((Object)synEnv);
        MessageContextCreatorForAxis2.setSynEnv((SynapseEnvironment)synEnv);
        if (contextInformation == null) {
            throw new IllegalStateException("ServerContextInformation not found");
        }
        contextInformation.setSynapseEnvironment((SynapseEnvironment)synEnv);
        contextInformation.setSynapseConfiguration(newSynapseConfiguration);
        try {
            axisConfiguration.addParameter(synapseCtxParam);
            axisConfiguration.addParameter(synapseEnvParam);
        }
        catch (AxisFault e) {
            String msg = "Could not set parameters 'synapse.config' and/or 'synapse.env'to the Axis2 configuration : " + e.getMessage();
            throw new ConfigurationInitilizerException(msg, e);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Re-deploying Proxy services...");
        }
        for (ProxyService proxyService : newSynapseConfiguration.getProxyServices()) {
            if (proxyService == null) continue;
            proxyService.buildAxisService(newSynapseConfiguration, axisConfiguration);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deployed Proxy service : " + proxyService.getName()));
            }
            if (proxyService.isStartOnLoad()) continue;
            proxyService.stop(newSynapseConfiguration);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Re-deploying Event Sources...");
        }
        for (SynapseEventSource eventSource : newSynapseConfiguration.getEventSources()) {
            if (eventSource == null) continue;
            eventSource.buildService(axisConfiguration);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Deployed Event Source : " + eventSource.getName()));
        }
        synEnv.getTaskManager().init(repository, taskScheduler);
        newSynapseConfiguration.init((SynapseEnvironment)synEnv);
        synEnv.setInitialized(true);
    }

    private boolean isLoadFromRegistry() {
        return "true".equals(ConfigurationUtils.getParameter("MediationConfig.LoadFromRegistry"));
    }

    private SynapseEnvironment getSynapseEnvironment() {
        return (SynapseEnvironment)this.configurationContext.getAxisConfiguration().getParameter("synapse.env").getValue();
    }

    private SynapseConfiguration getSynapseConfiguration() {
        return (SynapseConfiguration)this.configurationContext.getAxisConfiguration().getParameter("synapse.config").getValue();
    }

    private MediationPersistenceManager getMediationPersistenceManager() {
        return ServiceBusUtils.getMediationPersistenceManager(this.configurationContext.getAxisConfiguration());
    }

    private ServerConfigurationInformation getServerConfigurationInformation() {
        Parameter p = this.configurationContext.getAxisConfiguration().getParameter("synapse.server.config.info");
        if (p != null) {
            return (ServerConfigurationInformation)p.getValue();
        }
        return null;
    }

    private ServerContextInformation getServerContextInformation() {
        Parameter p = this.configurationContext.getAxisConfiguration().getParameter("synapse.server.context.info");
        if (p != null) {
            return (ServerContextInformation)p.getValue();
        }
        return null;
    }

    private void handleException(String msg) throws ConfigurationInitilizerException {
        log.warn((Object)msg);
        throw new ConfigurationInitilizerException(msg);
    }

    private void handleException(String msg, Exception e) throws ConfigurationInitilizerException {
        log.warn((Object)msg, (Throwable)e);
        throw new ConfigurationInitilizerException(msg, e);
    }
}

