/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.transport;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportEndpoint;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportReceiver;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportTaskManager;
import org.wso2.carbon.cloud.csg.common.CSGUtils;
import org.wso2.carbon.cloud.csg.stub.types.common.CSGThriftServerBean;
import org.wso2.carbon.core.util.CryptoException;

public class CSGPollingTransportTaskManagerFactory {
    private static final Log log = LogFactory.getLog(CSGPollingTransportTaskManagerFactory.class);

    private CSGPollingTransportTaskManagerFactory() {
    }

    public static CSGPollingTransportTaskManager createTaskManagerForService(AxisService service, WorkerPool workerPool, CSGPollingTransportEndpoint endpoint, CSGPollingTransportReceiver receiver) throws AxisFault {
        CSGThriftServerBean bean;
        String token;
        String serviceName = service.getName();
        String encryptedToken = (String)service.getParameterValue("token");
        try {
            token = CSGUtils.getPlainToken((String)encryptedToken);
        }
        catch (CryptoException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        if ("".equals(token)) {
            throw new AxisFault("The secure token is not set for service '" + serviceName + "'");
        }
        CSGPollingTransportTaskManager stm = new CSGPollingTransportTaskManager();
        stm.setToken(token);
        stm.setServiceName(serviceName);
        stm.setWorkerPool(workerPool);
        stm.setConcurrentClients(CSGUtils.getIntProperty((String)"csg-thrift-t-c-c", (int)1));
        stm.setSubject(receiver.getSubject());
        stm.setNoOfDispatchingTask(CSGUtils.getIntProperty((String)"csg-no-of-dispatch-worker", (int)2));
        stm.setEndpoint(endpoint);
        int requestBlockSize = CSGUtils.getIntProperty((String)"csg-thrift-t-m-s", (int)5);
        int responseBlockSize = CSGUtils.getIntProperty((String)"csg-thrift-r-m-s", (int)1000);
        int messageProcessingBlockSize = CSGUtils.getIntProperty((String)"csg-thrift-p-r-m-s", (int)5);
        if (messageProcessingBlockSize > 500) {
            log.warn((Object)("The message processing block size '" + messageProcessingBlockSize + "' " + "is large than the worker pool size '" + 500 + "'. All polling tasks and the message processing tasks share the worker pool," + "so the default value for the message processing block '" + 5 + "' will be used"));
            messageProcessingBlockSize = 5;
        }
        if ((bean = (CSGThriftServerBean)service.getParameterValue("CSG_SERVER_BEAN")) == null) {
            throw new AxisFault("Remote CSG server information is missing");
        }
        String hostName = bean.getHostName();
        int port = bean.getPort();
        int timeout = bean.getTimeOut();
        int initialReconnectionDuration = CSGUtils.getIntProperty((String)"csg-thirft-re-connect-duration", (int)10000);
        double progressionFactor = CSGUtils.getDoubleProperty((String)"csg-progression-factor", (double)2.0);
        stm.setRequestBlockSize(requestBlockSize);
        stm.setMessageProcessingBlockSize(messageProcessingBlockSize);
        stm.setResponseBlockSize(responseBlockSize);
        stm.setHostName(hostName);
        stm.setPort(port);
        stm.setTimeout(timeout);
        stm.setReconnectionProgressionFactor(progressionFactor);
        stm.setInitialReconnectDuration(initialReconnectionDuration);
        stm.setTrustStoreLocation(CSGUtils.getWSO2TrustStoreFilePath());
        stm.setTrustStorePassWord(CSGUtils.getWSO2TrustStorePassword());
        return stm;
    }
}

