/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.csg.agent.CSGAgentPollingTaskFlags;
import org.wso2.carbon.cloud.csg.agent.CSGAgentUtils;
import org.wso2.carbon.cloud.csg.agent.client.AuthenticationClient;
import org.wso2.carbon.cloud.csg.agent.client.CSGAdminClient;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportReceiver;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportSender;
import org.wso2.carbon.cloud.csg.common.CSGException;
import org.wso2.carbon.cloud.csg.common.CSGProxyToolsURLs;
import org.wso2.carbon.cloud.csg.common.CSGServerBean;
import org.wso2.carbon.cloud.csg.common.CSGUtils;
import org.wso2.carbon.cloud.csg.common.thrift.CSGThriftClient;
import org.wso2.carbon.cloud.csg.stub.types.common.CSGServiceMetaDataBean;
import org.wso2.carbon.cloud.csg.stub.types.common.CSGThriftServerBean;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.service.mgt.ServiceAdmin;
import org.wso2.carbon.service.mgt.ServiceMetaData;
import org.wso2.carbon.transport.mgt.TransportAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSGAgentAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(CSGAgentAdminService.class);

    public void publishService(String serviceName, String serverName, boolean isAutomatic) throws CSGException {
        if (serviceName == null) {
            this.handleException("Service name is null!");
        }
        try {
            CSGAdminClient csgAdminClient;
            AxisService service;
            CSGServerBean csgServer = this.getCSGServerBean(serverName);
            if (csgServer == null) {
                this.handleException("No persist information found for the server'" + serverName + "'");
            }
            if ((service = this.getAxisConfig().getService(serviceName)) == null) {
                this.handleException("No service found with the name '" + serviceName + "'");
            }
            if ((csgAdminClient = this.getCSGAdminClient(csgServer)) == null) {
                this.handleException("CSGAdminClient is null");
            }
            String domainName = csgServer.getDomainName();
            String passWord = csgServer.getPassWord();
            String userName = CSGUtils.getFullUserName((String)csgServer.getUserName(), (String)domainName);
            CSGThriftServerBean bean = csgAdminClient.getThriftServerConnectionBean();
            String hostName = csgServer.getHost();
            if ("localhost".equals(hostName) || "127.0.0.1".equals(hostName)) {
                hostName = bean.getHostName();
            } else {
                bean.setHostName(hostName);
            }
            int port = bean.getPort();
            int timeOut = bean.getTimeOut();
            String trustStorePath = CSGUtils.getWSO2TrustStoreFilePath();
            String trustStorePassword = CSGUtils.getWSO2TrustStorePassword();
            CSGThriftClient csgThriftClient = new CSGThriftClient(CSGUtils.getCSGThriftClient((String)hostName, (int)port, (int)timeOut, (String)trustStorePath, (String)trustStorePassword));
            String queueName = CSGUtils.getCSGEPR((String)domainName, (String)serverName, (String)serviceName);
            String token = csgThriftClient.login(userName, passWord, queueName);
            new TransportAdmin().addExposedTransports(serviceName, "csgpolling");
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            service.addParameter("token", (Object)cryptoUtil.encryptAndBase64Encode(token.getBytes()));
            service.addParameter("CSG_SERVER_BEAN", (Object)bean);
            CSGAgentPollingTaskFlags.flagForShutDown(serviceName, false);
            if (CSGAgentAdminService.hasInOutOperations(service)) {
                this.enableCSGPollingTransportSender(this.getAxisConfig());
            }
            this.enableCSGPollingTransportReceiver(this.getAxisConfig());
            csgAdminClient.deployProxy(this.getCSGServiceMetaData(service, domainName, serverName));
            this.flagServiceStatus(serviceName, serverName, true, isAutomatic);
        }
        catch (Exception e) {
            this.handleException("Could not publish service '" + serviceName + "'. " + e.getMessage(), e);
        }
    }

    public void unPublishService(String serviceName, String serverName) throws CSGException {
        if (serviceName == null) {
            this.handleException("The service name is not supplied for un-publishing");
        }
        try {
            CSGServerBean csgServer;
            new TransportAdmin().removeExposedTransports(serviceName, "csgpolling");
            AxisService service = this.getAxisConfig().getService(serviceName);
            if (service == null) {
                this.handleException("No service is found with the name '" + serviceName + "'");
            }
            if ((csgServer = this.getCSGServerBean(serverName)) == null) {
                throw new CSGException("No CSG server information found with the name '" + serverName + "'");
            }
            CSGAdminClient csgAdminClient = this.getCSGAdminClient(csgServer);
            if (csgAdminClient == null) {
                this.handleException("CSGAdminClient is null");
            }
            CSGAgentPollingTaskFlags.flagForShutDown(serviceName, true);
            csgAdminClient.unDeployProxy(serviceName);
            this.flagServiceStatus(serviceName, serverName, false, false);
        }
        catch (Exception e) {
            this.handleException("Could not un-publish the service '" + serviceName + "'", e);
        }
    }

    public void addCSGServer(CSGServerBean csgServer) throws CSGException {
        try {
            this.loggingToRemoteCSGServer(csgServer);
            Registry registry = this.getConfigSystemRegistry();
            CSGAgentUtils.persistServer(registry, csgServer);
        }
        catch (Exception e) {
            this.handleException("Could not add CSG server '" + csgServer.getName() + "'. Error is " + e.getMessage(), e);
        }
    }

    public CSGServerBean getCSGServer(String csgServerName) throws CSGException {
        Registry registry = this.getConfigSystemRegistry();
        String resourcePath = "/repository/components/org.wso2.carbon.cloud.csg/servers/" + csgServerName;
        try {
            if (registry.resourceExists(resourcePath)) {
                Resource resource = registry.get(resourcePath);
                return CSGAgentUtils.getCSGServerBean((org.wso2.carbon.registry.api.Resource)resource);
            }
        }
        catch (RegistryException e) {
            this.handleException("Could not read the registry resource '" + resourcePath + "'. Error is " + e.getMessage(), e);
        }
        return null;
    }

    public CSGServerBean[] getCSGServerList() throws CSGException {
        try {
            Resource resource;
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists("/repository/components/org.wso2.carbon.cloud.csg/servers") && (resource = registry.get("/repository/components/org.wso2.carbon.cloud.csg/servers")) instanceof org.wso2.carbon.registry.api.Collection) {
                org.wso2.carbon.registry.api.Collection collection = (org.wso2.carbon.registry.api.Collection)resource;
                int size = collection.getChildCount();
                CSGServerBean[] beanInfo = new CSGServerBean[size];
                String[] child = collection.getChildren();
                for (int i = 0; child.length > i; ++i) {
                    String s = child[i];
                    Resource childResource = registry.get(s);
                    beanInfo[i] = CSGAgentUtils.getCSGServerBean((org.wso2.carbon.registry.api.Resource)childResource);
                }
                return beanInfo;
            }
        }
        catch (RegistryException e) {
            this.handleException("Could not retrieve the CSG server list. Error is " + e.getMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCSGServer(CSGServerBean csgServer) throws CSGException {
        this.loggingToRemoteCSGServer(csgServer);
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        Registry registry = this.getConfigSystemRegistry();
        String resource = "/repository/components/org.wso2.carbon.cloud.csg/servers/" + csgServer.getName();
        try {
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            if (registry.resourceExists(resource)) {
                registry.delete(resource);
                CSGAgentUtils.persistServer(registry, csgServer);
            }
        }
        catch (RegistryException e) {
            isTransactionSuccess = false;
            this.handleException("Could not read the registry resource '" + resource + "'. Error is " + e.getMessage(), e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException re) {
                    this.handleException("Error occurred while trying to rollback or commit the transaction", re);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCSGServer(String csgServerName) throws CSGException {
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        Registry registry = this.getConfigSystemRegistry();
        try {
            String resource;
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            if (registry.resourceExists(resource = "/repository/components/org.wso2.carbon.cloud.csg/servers/" + csgServerName)) {
                if (!this.isHasPublishedServices(csgServerName)) {
                    registry.delete(resource);
                } else {
                    this.handleException(csgServerName + " has services published onto it.");
                }
            } else {
                log.error((Object)("The resource '" + resource + "' does not exist!"));
            }
        }
        catch (Exception e) {
            isTransactionSuccess = false;
            this.handleException("Could not remove the CSG server: " + csgServerName + ". Error is " + e.getMessage(), e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException re) {
                    this.handleException("Error occurred while trying to rollback or commit the transaction", re);
                }
            }
        }
    }

    public String getServiceStatus(String serviceName) throws CSGException {
        try {
            Registry registry = this.getConfigSystemRegistry();
            String resourcePath = "/repository/components/org.wso2.carbon.cloud.csg/flags/" + serviceName + ".flag";
            if (registry.resourceExists(resourcePath)) {
                Resource resource = registry.get(resourcePath);
                return new String((byte[])resource.getContent());
            }
        }
        catch (Exception e) {
            this.handleException("Could not retrieve the service publish flag for service '" + serviceName + "'", e);
        }
        return "Unpublished";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceStatus(String serviceName, String status) throws CSGException {
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        Registry registry = this.getConfigSystemRegistry();
        try {
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            Resource resource = registry.newResource();
            resource.setContent((Object)status);
            registry.put("/repository/components/org.wso2.carbon.cloud.csg/flags/" + serviceName + ".flag", resource);
        }
        catch (Exception e) {
            isTransactionSuccess = false;
            this.handleException("Could not retrieve the service publish flag for service '" + serviceName + "'", e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException re) {
                    this.handleException("Error occurred while trying to rollback or commit the transaction", re);
                }
            }
        }
    }

    public void doServiceUpdate(String serviceName, int eventType) throws CSGException {
        String publishedServer = this.getPublishedServer(serviceName);
        if (publishedServer != null) {
            CSGServerBean csgServer = this.getCSGServerBean(publishedServer);
            if (csgServer == null) {
                this.handleException("No persist information found for the server'" + publishedServer + "'");
            }
            try {
                CSGAdminClient csgAdminClient = this.getCSGAdminClient(csgServer);
                if (eventType == 0) {
                    this.flagServiceStatus(serviceName, csgServer.getName(), false, false);
                }
                csgAdminClient.updateProxy(serviceName, eventType);
            }
            catch (Exception e) {
                this.handleException("Cloud not update service the service '" + serviceName + "'");
            }
        }
    }

    public String getPublishedServer(String serviceName) throws CSGException {
        try {
            Resource serverResource;
            Registry registry = this.getConfigSystemRegistry();
            String serverResourcePath = "/repository/components/org.wso2.carbon.cloud.csg/flags/" + serviceName + ".server";
            if (registry.resourceExists(serverResourcePath) && (serverResource = registry.get(serverResourcePath)) != null && serverResource.getContent() != null) {
                return new String((byte[])serverResource.getContent());
            }
        }
        catch (RegistryException e) {
            this.handleException("Could not retrieve the published server list. Error is " + e.getMessage(), e);
        }
        return null;
    }

    public CSGProxyToolsURLs getPublishedProxyToolsURLs(String serviceName) throws CSGException {
        try {
            CSGServerBean bean = this.getCSGServer(this.getPublishedServer(serviceName));
            if (bean == null) {
                this.handleException("No persist server information found for the published service '" + serviceName + "'");
            }
            String domainName = bean.getDomainName();
            CSGAdminClient csgAdminClient = this.getCSGAdminClient(bean);
            if (csgAdminClient == null) {
                this.handleException("CSGAdminClient is null");
            }
            org.wso2.carbon.cloud.csg.stub.types.common.CSGProxyToolsURLs tools = csgAdminClient.getPublishedProxyToolsURLs(serviceName, domainName);
            CSGProxyToolsURLs tempTools = new CSGProxyToolsURLs();
            if (tools != null) {
                tempTools.setTryItURL(tools.getTryItURL());
                tempTools.setWsdl11URL(tools.getWsdl11URL());
                tempTools.setWsdl2URL(tools.getWsdl2URL());
                tempTools.setEprArray(tools.getEprArray());
                return tempTools;
            }
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
        return null;
    }

    public boolean isHasPublishedServices(String csgServerName) throws CSGException {
        boolean isHasServices;
        block3: {
            isHasServices = false;
            try {
                Resource resource;
                Registry registry = this.getConfigSystemRegistry();
                if (!registry.resourceExists("/repository/components/org.wso2.carbon.cloud.csg/flags") || !((resource = registry.get("/repository/components/org.wso2.carbon.cloud.csg/flags")) instanceof org.wso2.carbon.registry.api.Collection)) break block3;
                org.wso2.carbon.registry.api.Collection serviceFlagCollection = (org.wso2.carbon.registry.api.Collection)resource;
                String[] flags = serviceFlagCollection.getChildren();
                List<String> serverFlagPaths = this.filterForServiceFlags(flags);
                for (String serverFlagPath : serverFlagPaths) {
                    Resource serverFlag = registry.get(serverFlagPath);
                    String publishedServer = serverFlag.getContent() != null ? new String((byte[])serverFlag.getContent()) : "";
                    if (!csgServerName.equals(publishedServer)) continue;
                    isHasServices = true;
                    break;
                }
            }
            catch (Exception e) {
                this.handleException("Unable to retrieve CSG services configurations", e);
            }
        }
        return isHasServices;
    }

    private void handleException(String msg) throws CSGException {
        log.error((Object)msg);
        throw new CSGException(msg);
    }

    private void handleException(String msg, Throwable t) throws CSGException {
        log.error((Object)msg, t);
        throw new CSGException(msg, t);
    }

    private CSGServerBean getCSGServerBean(String csgServerName) throws CSGException {
        CSGServerBean bean;
        block5: {
            bean = null;
            try {
                Registry registry = this.getConfigSystemRegistry();
                String resourceName = "/repository/components/org.wso2.carbon.cloud.csg/servers/" + csgServerName;
                if (registry.resourceExists(resourceName)) {
                    Resource resource = registry.get(resourceName);
                    try {
                        bean = new CSGServerBean();
                        bean.setHost(resource.getProperty("host"));
                        bean.setName(resource.getProperty("name"));
                        bean.setUserName(resource.getProperty("username"));
                        bean.setPort(resource.getProperty("port"));
                        bean.setDomainName(resource.getProperty("domain"));
                        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
                        bean.setPassWord(new String(cryptoUtil.base64DecodeAndDecrypt(resource.getProperty("password"))));
                    }
                    catch (CryptoException e) {
                        this.handleException("Could not convert into an AXIOM element");
                    }
                    break block5;
                }
                throw new CSGException("Resource :" + resourceName + " does not exist");
            }
            catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
                this.handleException("Could not retrieve the server information for server: " + csgServerName, e);
            }
        }
        return bean;
    }

    private static String getAuthServiceURL(CSGServerBean csgServer) {
        return "https://" + csgServer.getHost() + ":" + csgServer.getPort() + "/services/AuthenticationAdmin";
    }

    private static String getProxyURL(CSGServerBean csgServer) {
        return "https://" + csgServer.getHost() + ":" + csgServer.getPort() + "/services/";
    }

    private static boolean hasInOutOperations(AxisService service) {
        Iterator axisOpItr = service.getOperations();
        while (axisOpItr.hasNext()) {
            AxisOperation axisOp = (AxisOperation)axisOpItr.next();
            if (axisOp.getAxisSpecificMEPConstant() != 12) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flagServiceStatus(String serviceName, String serverName, boolean isPublished, boolean isAutoMatic) throws CSGException {
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        Registry registry = this.getConfigSystemRegistry();
        try {
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            if (!registry.resourceExists("/repository/components/org.wso2.carbon.cloud.csg/")) {
                Collection collection = registry.newCollection();
                registry.put("/repository/components/org.wso2.carbon.cloud.csg/", (Resource)collection);
            }
            Resource resource = registry.newResource();
            Resource serverResource = registry.newResource();
            String serverResourcePath = "/repository/components/org.wso2.carbon.cloud.csg/flags/" + serviceName + ".server";
            if (isPublished) {
                if (isAutoMatic) {
                    resource.setContent((Object)"AutoMatic");
                } else {
                    resource.setContent((Object)"Published");
                }
                serverResource.setContent((Object)serverName);
            } else {
                resource.setContent((Object)"Unpublished");
                if (registry.resourceExists(serverResourcePath)) {
                    registry.delete(serverResourcePath);
                }
            }
            registry.put("/repository/components/org.wso2.carbon.cloud.csg/flags/" + serviceName + ".flag", resource);
            registry.put("/repository/components/org.wso2.carbon.cloud.csg/flags/" + serviceName + ".server", serverResource);
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            isTransactionSuccess = false;
            this.handleException("Could not flag the service '" + serviceName + "'", e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (Exception exception) {
                    this.handleException("Error occurred while trying to rollback or commit the transaction", exception);
                }
            }
        }
    }

    private CSGServiceMetaDataBean getCSGServiceMetaData(AxisService service, String tenantName, String serverName) throws CSGException {
        try {
            CSGServiceMetaDataBean privateServiceMetaData = new CSGServiceMetaDataBean();
            privateServiceMetaData.setServiceName(service.getName());
            privateServiceMetaData.setEndpoint(CSGUtils.getCSGEPR((String)tenantName, (String)serverName, (String)service.getName()));
            ServiceAdmin serviceAdmin = new ServiceAdmin(this.getAxisConfig());
            ServiceMetaData serviceAdminMetaData = serviceAdmin.getServiceData(service.getName());
            if (serviceAdminMetaData.isActive()) {
                OMElement wsdlElement = this.getWSDLElement(serviceAdminMetaData.getWsdlURLs()[0]);
                String wsdlString = wsdlElement.toStringWithConsume();
                if (wsdlString.contains("Unable to generate WSDL 1.1 for this service") || wsdlString.contains("error")) {
                    privateServiceMetaData.setInLineWSDL(null);
                } else {
                    privateServiceMetaData.setInLineWSDL(wsdlElement.toStringWithConsume());
                }
            }
            if (CSGAgentAdminService.hasInOutOperations(service)) {
                privateServiceMetaData.setHasInOutMEP(true);
            }
            return privateServiceMetaData;
        }
        catch (Exception e) {
            this.handleException("Error while retrieving the meta data of the service '" + service.getName() + "'", e);
            return null;
        }
    }

    private CSGAdminClient getCSGAdminClient(CSGServerBean bean) throws CSGException {
        try {
            CSGAdminClient csgAdminClient;
            String domainName = bean.getDomainName();
            String passWord = bean.getPassWord();
            String sessionCookie = CSGAgentUtils.getSessionCookie(CSGAgentAdminService.getAuthServiceURL(bean), bean.getUserName(), passWord, domainName, bean.getHost());
            if (CSGAgentUtils.isClientAxis2XMLExists()) {
                ConfigurationContext configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, (String)"repository/conf/axis2/axis2_client.xml");
                csgAdminClient = new CSGAdminClient(sessionCookie, CSGAgentAdminService.getProxyURL(bean), configCtx);
            } else {
                csgAdminClient = new CSGAdminClient(sessionCookie, CSGAgentAdminService.getProxyURL(bean));
            }
            return csgAdminClient;
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    private void enableCSGPollingTransportSender(AxisConfiguration axisConfig) throws AxisFault {
        TransportOutDescription transportOut = new TransportOutDescription("csgpolling");
        CSGPollingTransportSender txSender = new CSGPollingTransportSender();
        transportOut.setSender((TransportSender)txSender);
        axisConfig.addTransportOut(transportOut);
        transportOut.getSender().init(this.getConfigContext(), transportOut);
    }

    private void enableCSGPollingTransportReceiver(AxisConfiguration axisConfig) throws AxisFault {
        TransportInDescription transportIn = new TransportInDescription("csgpolling");
        CSGPollingTransportReceiver receiver = new CSGPollingTransportReceiver();
        transportIn.setReceiver((TransportListener)receiver);
        axisConfig.addTransportIn(transportIn);
        transportIn.getReceiver().init(this.getConfigContext(), transportIn);
        transportIn.getReceiver().start();
    }

    private List<String> filterForServiceFlags(String[] flags) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String flag : flags) {
            if (!flag.endsWith(".server")) continue;
            filtered.add(flag);
        }
        return filtered;
    }

    private void loggingToRemoteCSGServer(CSGServerBean csgServer) throws CSGException {
        String authServerUrl = "https://" + csgServer.getHost() + ":" + csgServer.getPort() + "/services/AuthenticationAdmin";
        AuthenticationClient authClient = new AuthenticationClient();
        authClient.getLoggedAuthAdminStub(authServerUrl, csgServer.getUserName(), csgServer.getPassWord(), csgServer.getHost(), csgServer.getDomainName());
    }

    private OMElement getWSDLElement(String wsdlLocation) throws CSGException {
        OMNode wsdNode = CSGAgentUtils.getOMElementFromURI(wsdlLocation);
        if (!(wsdNode instanceof OMElement)) {
            throw new CSGException("Invalid instance type detected when parsing the WSDL '" + wsdlLocation + "'. Required OMElement type!");
        }
        OMElement wsdlElement = (OMElement)wsdNode;
        return wsdlElement;
    }
}

