/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.observer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.wso2.carbon.cloud.csg.agent.observer.CSGAgentObserver;
import org.wso2.carbon.cloud.csg.agent.observer.CSGAgentSubject;

public class CSGAgentSubjectImpl
implements CSGAgentSubject {
    private List<CSGAgentObserver> observers = Collections.synchronizedList(new ArrayList());

    public void addObserver(CSGAgentObserver o) {
        this.observers.add(o);
    }

    public void removeObserver(CSGAgentObserver o) {
        this.observers.remove(o);
    }

    public void connected(String host, int port) {
        this.notifyObservers(host, port);
    }

    private void notifyObservers(String host, int port) {
        Iterator<CSGAgentObserver> i$ = this.observers.iterator();
        while (i$.hasNext()) {
            CSGAgentObserver observer;
            CSGAgentObserver o = observer = i$.next();
            if (host == null || !host.equals(o.getHostName()) || port != o.getPort()) continue;
            o.update(this);
        }
    }
}

