/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.cloud.csg.agent.observer.CSGServiceObserver;
import org.wso2.carbon.cloud.csg.agent.service.CSGAgentAdminService;
import org.wso2.carbon.cloud.csg.common.CSGConstant;
import org.wso2.carbon.cloud.csg.common.CSGException;
import org.wso2.carbon.cloud.csg.common.CSGUtils;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CSGAgentServiceComponent {
    private static Log log = LogFactory.getLog(CSGAgentServiceComponent.class);
    private ConfigurationContextService configurationContextService;
    private RealmService realmService;
    private long initialReconnectDuration;
    private double reconnectionProgressionFactor;
    private List<String> pendingServices = new ArrayList<String>();

    protected void activate(ComponentContext context) {
        if (this.configurationContextService == null) {
            log.error((Object)"Cloud not activated the CSGAgentServiceComponent. ConfigurationContextService is null!");
            return;
        }
        this.initialReconnectDuration = CSGUtils.getLongProperty((String)"csg-thirft-re-connect-duration", (long)10000L);
        this.reconnectionProgressionFactor = CSGUtils.getDoubleProperty((String)"csg-progression-factor", (double)2.0);
        AxisConfiguration axisConfig = this.configurationContextService.getServerConfigContext().getAxisConfiguration();
        CSGServiceObserver observer = new CSGServiceObserver();
        axisConfig.addObservers((AxisObserver)observer);
        String[] publishOptimizedList = UserCoreUtil.optimizePermissions((String[])CSGConstant.CSG_PUBLISH_PERMISSION_LIST);
        String[] unPublishOptimizedList = UserCoreUtil.optimizePermissions((String[])CSGConstant.CSG_UNPUBLISH_PERMISSION_LIST);
        try {
            UserRealm realm = this.realmService.getBootstrapRealm();
            AuthorizationManager authorizationManager = realm.getAuthorizationManager();
            authorizationManager.clearRoleActionOnAllResources("csg_publisher", "ui.execute");
            authorizationManager.clearRoleActionOnAllResources("csg_unpublisher", "ui.execute");
            for (String permission : publishOptimizedList) {
                authorizationManager.authorizeRole("csg_publisher", permission, "ui.execute");
            }
            for (String permission : unPublishOptimizedList) {
                authorizationManager.authorizeRole("csg_unpublisher", permission, "ui.execute");
            }
            UserStoreManager manager = realm.getUserStoreManager();
            if (!manager.isExistingRole("csg_publisher")) {
                manager.addRole("csg_publisher", null, null);
            }
            if (!manager.isExistingRole("csg_unpublisher")) {
                manager.addRole("csg_unpublisher", null, null);
            }
            for (Map.Entry entry : axisConfig.getServices().entrySet()) {
                AxisService axisService = (AxisService)entry.getValue();
                CSGAgentAdminService service = new CSGAgentAdminService();
                String status = service.getServiceStatus(axisService.getName());
                if (SystemFilter.isAdminService((AxisService)axisService) || SystemFilter.isHiddenService((AxisService)axisService) || axisService.isClientSide() || status.equals("Unpublished")) continue;
                this.pendingServices.add(axisService.getName());
            }
            if (this.pendingServices.size() > 0) {
                new Thread((Runnable)new ServiceRePublishingTask(), "CSG-re-publishing-thread").start();
            }
        }
        catch (Exception e) {
            log.error((Object)"Cloud not activated the CSGAgentServiceComponent. ", (Throwable)e);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activated the CSGAgentServiceComponent");
        }
    }

    protected void deactivate(ComponentContext context) {
    }

    protected void setConfigurationContextService(ConfigurationContextService configCtxService) {
        this.configurationContextService = configCtxService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (this.configurationContextService != null) {
            this.configurationContextService = null;
        }
    }

    protected void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (this.realmService != null) {
            this.realmService = null;
        }
    }

    private class ServiceRePublishingTask
    implements Runnable {
        private ServiceRePublishingTask() {
        }

        public void run() {
            long retryDuration = CSGAgentServiceComponent.this.initialReconnectDuration;
            while (true) {
                if (CSGUtils.isServerAlive((String)"localhost", (int)CarbonUtils.getTransportPort((ConfigurationContextService)CSGAgentServiceComponent.this.configurationContextService, (String)"http"))) {
                    CSGAgentAdminService adminService = new CSGAgentAdminService();
                    for (String serviceName : CSGAgentServiceComponent.this.pendingServices) {
                        try {
                            boolean isAutomatic = adminService.getServiceStatus(serviceName).equals("AutoMatic");
                            String serverName = adminService.getPublishedServer(serviceName);
                            adminService.unPublishService(serviceName, serverName);
                            adminService.publishService(serviceName, serverName, isAutomatic);
                        }
                        catch (CSGException e) {
                            log.error((Object)("Error while re-publishing the previously published service '" + serviceName + "'," + " you will need to re-publish the service manually!"), (Throwable)e);
                        }
                        log.info((Object)("Service '" + serviceName + "', re-published successfully"));
                    }
                    break;
                }
                retryDuration = (long)((double)retryDuration * CSGAgentServiceComponent.this.reconnectionProgressionFactor);
                try {
                    Thread.sleep(retryDuration);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

