/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.client;

import java.net.SocketException;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.cloud.csg.agent.CSGAgentUtils;
import org.wso2.carbon.cloud.csg.common.CSGException;
import org.wso2.carbon.cloud.csg.common.CSGUtils;

public class AuthenticationClient {
    public String getSessionCookie(String serverUrl, String userName, String passWord, String hostName, String domainName) throws RemoteException, SocketException, LoginAuthenticationExceptionException {
        try {
            AuthenticationAdminStub authenticationAdminStub = this.getLoggedAuthAdminStub(serverUrl, userName, passWord, hostName, domainName);
            ServiceContext serivceContext = authenticationAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            return (String)serivceContext.getProperty("Cookie");
        }
        catch (CSGException ex) {
            throw new AxisFault(ex.getMessage(), (Throwable)ex);
        }
    }

    public AuthenticationAdminStub getLoggedAuthAdminStub(String serverUrl, String userName, String passWord, String hostName, String domainName) throws CSGException {
        boolean isLoggedIn;
        AuthenticationAdminStub authenticationAdminStub;
        String loggingName = CSGUtils.getFullUserName((String)userName, (String)domainName);
        try {
            if (CSGAgentUtils.isClientAxis2XMLExists()) {
                ConfigurationContext configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, (String)"repository/conf/axis2/axis2_client.xml");
                authenticationAdminStub = new AuthenticationAdminStub(configurationContext, serverUrl);
            } else {
                authenticationAdminStub = new AuthenticationAdminStub(serverUrl);
            }
            isLoggedIn = authenticationAdminStub.login(loggingName, passWord, hostName);
        }
        catch (Exception e) {
            throw new CSGException((Throwable)e);
        }
        if (!isLoggedIn) {
            throw new CSGException("User '" + loggingName + "' cloud not logged into server '" + hostName + "', using server URL '" + serverUrl + "'");
        }
        return authenticationAdminStub;
    }
}

