/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.ui;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.csg.agent.stub.CSGAgentAdminServiceCSGException;
import org.wso2.carbon.cloud.csg.agent.stub.CSGAgentAdminServiceStub;
import org.wso2.carbon.cloud.csg.agent.stub.types.carbon.CSGProxyToolsURLs;
import org.wso2.carbon.cloud.csg.agent.stub.types.carbon.CSGServerBean;

public class CSGAgentAdminClient {
    private static final Log log = LogFactory.getLog(CSGAgentAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.cloud.csg.agent.ui.i18n.Resources";
    private ResourceBundle bundle;
    private CSGAgentAdminServiceStub stub;

    public CSGAgentAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "CSGAgentAdminService";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new CSGAgentAdminServiceStub(configCtx, serviceURL);
        Options options = this.stub._getServiceClient().getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public void publish(String serviceName, String serverName, boolean isAutoMatic) throws AxisFault {
        try {
            this.stub.publishService(serviceName, serverName, isAutoMatic);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.publish.service", e), e);
        }
    }

    public void unPublish(String serviceName, String serverName) throws AxisFault {
        try {
            this.stub.unPublishService(serviceName, serverName);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.unpublish.service", e), e);
        }
    }

    public void addCSGServer(CSGServerBean csgServer) throws AxisFault {
        try {
            this.stub.addCSGServer(csgServer);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.add.the.csg.server", e), e);
        }
    }

    public CSGServerBean[] getCSGServerList() throws AxisFault {
        try {
            return this.stub.getCSGServerList();
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.retrieve.csg.servers", e), e);
        }
        return null;
    }

    public void removeCSGServer(String serverName) throws AxisFault {
        try {
            this.stub.removeCSGServer(serverName);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.remove.csg.server", e), e);
        }
    }

    public CSGServerBean getCSGServer(String serverName) throws AxisFault {
        try {
            return this.stub.getCSGServer(serverName);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.retrieve.csg.servers", e), e);
        }
        return null;
    }

    public void updateCSGServer(CSGServerBean bean) throws AxisFault {
        try {
            this.stub.updateCSGServer(bean);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.update.csg.server", e), e);
        }
    }

    public String getServiceStatus(String serviceName) throws AxisFault {
        try {
            return this.stub.getServiceStatus(serviceName);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.get.published.flag", e), e);
        }
        return null;
    }

    public void setServiceStatus(String serviceName, String status) throws AxisFault {
        try {
            this.stub.setServiceStatus(serviceName, status);
        }
        catch (Exception e) {
            this.handleException("Could not set the new status for the service '" + serviceName + "'", e);
        }
    }

    public String getPublishedServer(String serviceName) throws AxisFault {
        try {
            return this.stub.getPublishedServer(serviceName);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (CSGAgentAdminServiceCSGException e) {
            this.handleException(this.getI18nString("cannot.get.published.server.list", e), e);
        }
        return null;
    }

    public CSGProxyToolsURLs getPublishedProxyToolsURLs(String serviceName) throws AxisFault {
        try {
            return this.stub.getPublishedProxyToolsURLs(serviceName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public boolean isHasPublishedServices(String serverName) throws AxisFault {
        boolean isPublished = false;
        try {
            isPublished = this.stub.isHasPublishedServices(serverName);
        }
        catch (RemoteException e) {
            this.handleException(this.getI18nString("connect.error", e), e);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
        return isPublished;
    }

    private void handleException(String msg, Throwable t) throws AxisFault {
        log.error((Object)msg, t);
        throw new AxisFault(msg, t);
    }

    private String getI18nString(String rowString, Throwable t) {
        return MessageFormat.format(this.bundle.getString(rowString), t.getMessage());
    }
}

