/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.csg.agent.heartbeat.CSGAgentHeartBeatTask;
import org.wso2.carbon.cloud.csg.agent.heartbeat.CSGAgentHeartBeatTaskList;
import org.wso2.carbon.cloud.csg.agent.observer.CSGAgentObserverImpl;
import org.wso2.carbon.cloud.csg.agent.observer.CSGAgentSubject;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportBuffers;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportEndpoint;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportOutTransportInfo;
import org.wso2.carbon.cloud.csg.common.CSGUtils;
import org.wso2.carbon.cloud.csg.common.thrift.CSGThriftClient;
import org.wso2.carbon.cloud.csg.common.thrift.gen.Message;

public class CSGPollingTransportTaskManager {
    private static final Log log = LogFactory.getLog(CSGPollingTransportTaskManager.class);
    private int concurrentClients = 1;
    private String serviceName;
    private CSGPollingTransportEndpoint endpoint;
    private WorkerPool workerPool = null;
    private CSGAgentSubject subject;
    private String token;
    private int requestBlockSize;
    private int responseBlockSize;
    private String hostName;
    private int port;
    private int timeout;
    private String trustStoreLocation;
    private String trustStorePassWord;
    private int initialReconnectDuration = 10000;
    private double reconnectionProgressionFactor = 2.0;
    private int messageProcessingBlockSize;
    private final List<MessageExchangeTask> pollingTasks = Collections.synchronizedList(new ArrayList());
    private int noOfDispatchingTask = 2;

    public void setConcurrentClients(int concurrentClients) {
        this.concurrentClients = concurrentClients;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setInitialReconnectDuration(int initialReconnectDuration) {
        this.initialReconnectDuration = initialReconnectDuration;
    }

    public void setReconnectionProgressionFactor(double reconnectionProgressionFactor) {
        this.reconnectionProgressionFactor = reconnectionProgressionFactor;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEndpoint(CSGPollingTransportEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    public void setRequestBlockSize(int requestBlockSize) {
        this.requestBlockSize = requestBlockSize;
    }

    public void setResponseBlockSize(int responseBlockSize) {
        this.responseBlockSize = responseBlockSize;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public void setTrustStorePassWord(String trustStorePassWord) {
        this.trustStorePassWord = trustStorePassWord;
    }

    public void setNoOfDispatchingTask(int noOfDispatchingTask) {
        this.noOfDispatchingTask = noOfDispatchingTask;
    }

    public void setSubject(CSGAgentSubject subject) {
        this.subject = subject;
    }

    public void setMessageProcessingBlockSize(int messageProcessingBlockSize) {
        this.messageProcessingBlockSize = messageProcessingBlockSize;
    }

    public synchronized void start(CSGPollingTransportBuffers buffers) {
        int i;
        for (i = 0; i < this.noOfDispatchingTask; ++i) {
            this.workerPool.execute((Runnable)new MessageDispatchTask(buffers));
        }
        for (i = 0; i < this.concurrentClients; ++i) {
            CSGThriftClient client = new CSGThriftClient(CSGUtils.getCSGThriftClient((String)this.hostName, (int)this.port, (int)this.timeout, (String)this.trustStoreLocation, (String)this.trustStorePassWord));
            this.workerPool.execute((Runnable)new MessageExchangeTask(client, this.requestBlockSize, this.responseBlockSize, buffers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        List<MessageExchangeTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageExchangeTask exchangeTask : this.pollingTasks) {
                exchangeTask.requestShutDown();
            }
        }
        log.info((Object)("Task manager for service '" + this.serviceName + "', shutdown"));
    }

    static /* synthetic */ String access$300(CSGPollingTransportTaskManager x0) {
        return x0.hostName;
    }

    static /* synthetic */ int access$400(CSGPollingTransportTaskManager x0) {
        return x0.port;
    }

    static /* synthetic */ String access$500(CSGPollingTransportTaskManager x0) {
        return x0.serviceName;
    }

    static /* synthetic */ String access$600(CSGPollingTransportTaskManager x0) {
        return x0.token;
    }

    private final class MessageProcessingTask
    implements Runnable {
        private Message message;
        private boolean isSOAP11;
        private CSGPollingTransportBuffers buffers;

        private MessageProcessingTask(Message message, CSGPollingTransportBuffers buffers) {
            this.message = message;
            this.buffers = buffers;
        }

        public void run() {
            try {
                this.handleIncomingMessage(this.message);
            }
            catch (AxisFault axisFault) {
                try {
                    this.handleFaultMessage(this.message, this.buffers, axisFault);
                }
                catch (Exception e) {
                    log.error((Object)"Error while sending the fault message to the client. Client will not receive any errors!", (Throwable)e);
                }
            }
        }

        private void handleIncomingMessage(Message message) throws AxisFault {
            if (message == null) {
                log.warn((Object)"A null Message received!");
            } else {
                try {
                    MessageContext msgContext = CSGPollingTransportTaskManager.this.endpoint.createMessageContext();
                    String msgId = message.getMessageId();
                    msgContext.setMessageID(msgId);
                    msgContext.setProperty("CSG_CORRELATION_KEY", (Object)msgId);
                    Map trpHeaders = message.getTransportHeaders();
                    String contentType = message.getContentType();
                    HTTPTransportUtils.initializeMessageContext((MessageContext)msgContext, (String)message.getSoapAction(), (String)message.getRequestURI(), (String)contentType);
                    msgContext.setProperty("OutTransportInfo", (Object)new CSGPollingTransportOutTransportInfo(contentType));
                    if (message.isIsDoingREST()) {
                        msgContext.setAxisService(null);
                        msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)message.getHttpMethod());
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        RESTUtil.processURLRequest((MessageContext)msgContext, (OutputStream)out, (String)contentType);
                    } else {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getMessage());
                        msgContext.setProperty("ContentType", (Object)contentType);
                        msgContext.setProperty("TRANSPORT_HEADERS", (Object)trpHeaders);
                        if (message.isIsDoingMTOM()) {
                            msgContext.setDoingMTOM(message.isIsDoingMTOM());
                            msgContext.setProperty("enableMTOM", (Object)"true");
                        } else if (message.isIsDoingREST()) {
                            msgContext.setDoingSwA(message.isIsDoingSwA());
                            msgContext.setProperty("enableSwA", (Object)"true");
                        }
                        InputStream gzipInputStream = HTTPTransportUtils.handleGZip((MessageContext)msgContext, (InputStream)inputStream);
                        msgContext.setEnvelope(TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)gzipInputStream, (String)contentType));
                        this.isSOAP11 = msgContext.isSOAP11();
                        AxisEngine.receive((MessageContext)msgContext);
                    }
                }
                catch (XMLStreamException e) {
                    throw new AxisFault(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new AxisFault(e.getMessage(), (Throwable)e);
                }
            }
        }

        private void handleFaultMessage(Message originalMsg, CSGPollingTransportBuffers buffers, AxisFault axisFault) throws Exception {
            Message thriftMsg = new Message();
            thriftMsg.setMessageId(originalMsg.getMessageId());
            SOAPFactory factory = this.isSOAP11 ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
            OMDocument soapFaultDocument = factory.createOMDocument();
            SOAPEnvelope faultEnvelope = factory.getDefaultFaultEnvelope();
            soapFaultDocument.addChild((OMNode)faultEnvelope);
            SOAPFault fault = faultEnvelope.getBody().getFault();
            if (fault == null) {
                fault = factory.createSOAPFault();
            }
            SOAPFaultCode code = factory.createSOAPFaultCode();
            code.setText(axisFault.getMessage());
            fault.setCode(code);
            SOAPFaultReason reason = factory.createSOAPFaultReason();
            reason.setText(axisFault.getMessage());
            fault.setReason(reason);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            faultEnvelope.serialize((OutputStream)out);
            thriftMsg.setMessage(out.toByteArray());
            buffers.addResponseMessage(thriftMsg);
        }
    }

    private final class MessageDispatchTask
    implements Runnable {
        private CSGPollingTransportBuffers buffers;

        private MessageDispatchTask(CSGPollingTransportBuffers buffers) {
            this.buffers = buffers;
        }

        public void run() {
            while (true) {
                Message msg;
                if ((msg = this.buffers.getRequestMessage()) == null) {
                    continue;
                }
                CSGPollingTransportTaskManager.this.workerPool.execute((Runnable)new MessageProcessingTask(msg, this.buffers));
            }
        }
    }

    private final class MessageExchangeTask
    implements Runnable {
        private CSGThriftClient client;
        private volatile STATE workerState = STATE.STOPPED;
        private int responseBlockSize;
        private int requestBlockSize;
        private CSGPollingTransportBuffers buffers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MessageExchangeTask(CSGThriftClient client, int requestBlockSize, int responseBlockSize, CSGPollingTransportBuffers buffers) {
            this.client = client;
            this.requestBlockSize = requestBlockSize;
            this.responseBlockSize = responseBlockSize;
            this.buffers = buffers;
            List list = CSGPollingTransportTaskManager.this.pollingTasks;
            synchronized (list) {
                CSGPollingTransportTaskManager.this.pollingTasks.add(this);
            }
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void requestShutDown() {
            this.workerState = STATE.STOPPED;
        }

        private void registerObserver(String hostName, String serviceName, int port) {
            CSGAgentObserverImpl o = new CSGAgentObserverImpl(hostName, serviceName, port);
            CSGPollingTransportTaskManager.this.subject.addObserver(o);
        }

        private void scheduleHeartBeatTaskIfRequired(String host, int port) {
            String heartBeatTaskKey = host + ":" + port;
            if (!CSGAgentHeartBeatTaskList.isScheduledHeartBeatTaskAvailable(heartBeatTaskKey)) {
                CSGAgentHeartBeatTaskList.addScheduledHeartBeatTask(heartBeatTaskKey);
                CSGPollingTransportTaskManager.this.workerPool.execute((Runnable)new CSGAgentHeartBeatTask(CSGPollingTransportTaskManager.this.subject, CSGPollingTransportTaskManager.this.reconnectionProgressionFactor, CSGPollingTransportTaskManager.this.initialReconnectDuration, host, port));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        STOPPED,
        STARTED,
        FAILURE;

    }
}

