/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.transport;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.wso2.carbon.cloud.csg.agent.transport.CSGPollingTransportBuffers;
import org.wso2.carbon.cloud.csg.common.thrift.gen.Message;

public class CSGPollingTransportSender
extends AbstractTransportSender {
    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
    }

    public void sendMessage(MessageContext msgCtx, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        String relatesTo = (String)msgCtx.getOperationContext().getMessageContext("In").getProperty("CSG_CORRELATION_KEY");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("A response was received without addressing information. Correlation key '" + relatesTo + "' calculated from the IN message context"));
        }
        Message thriftMsg = new Message();
        thriftMsg.setMessageId(relatesTo);
        thriftMsg.setSoapAction(msgCtx.getSoapAction());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgCtx);
        if (messageFormatter == null) {
            throw new AxisFault("No MessageFormatter in MessageContext");
        }
        OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgCtx);
        thriftMsg.setContentType(messageFormatter.getContentType(msgCtx, format, msgCtx.getSoapAction()));
        try {
            if (msgCtx.isDoingREST()) {
                msgCtx.getEnvelope().getBody().getFirstElement().serialize((OutputStream)out);
            } else {
                thriftMsg.setIsDoingMTOM(msgCtx.isDoingMTOM());
                thriftMsg.setIsDoingSwA(msgCtx.isDoingSwA());
                msgCtx.getEnvelope().serialize((OutputStream)out);
            }
        }
        catch (XMLStreamException e) {
            this.handleException("Cloud not serialize the request message", e);
        }
        thriftMsg.setMessage(out.toByteArray());
        CSGPollingTransportBuffers buf = (CSGPollingTransportBuffers)msgCtx.getConfigurationContext().getProperty("CSG_POLLING_TRANSPORT_BUF_KEY");
        buf.addResponseMessage(thriftMsg);
    }
}

