/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.cloud.csg.common.CSGUtils;
import org.wso2.carbon.cloud.csg.common.thrift.gen.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSGPollingTransportBuffers {
    private BlockingQueue<Message> requestBuffer = new LinkedBlockingQueue<Message>();
    private BlockingQueue<Message> responseBuffer = new LinkedBlockingQueue<Message>();

    public List<Message> getResponseMessageList(int blockSize) throws AxisFault {
        ArrayList<Message> msgList = new ArrayList<Message>();
        if (this.responseBuffer.size() > 0) {
            CSGUtils.moveElements(this.responseBuffer, msgList, (int)blockSize);
        }
        return msgList;
    }

    public void addResponseMessage(Message msg) throws AxisFault {
        try {
            this.responseBuffer.put(msg);
        }
        catch (InterruptedException e) {
            throw new AxisFault("Could not get the response message", (Throwable)e);
        }
    }

    public BlockingQueue<Message> getRequestMessageBuffer() {
        return this.requestBuffer;
    }

    public Message getRequestMessage() {
        try {
            return this.requestBuffer.take();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }
}

