/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.observer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.csg.agent.observer.CSGAgentObserver;
import org.wso2.carbon.cloud.csg.agent.observer.CSGAgentSubject;
import org.wso2.carbon.cloud.csg.agent.service.CSGAgentAdminService;
import org.wso2.carbon.cloud.csg.common.CSGException;

public class CSGAgentObserverImpl
implements CSGAgentObserver {
    private String host;
    private int port;
    private String serviceName;
    private Log log = LogFactory.getLog(CSGAgentObserverImpl.class);

    public CSGAgentObserverImpl(String host, String serviceName, int port) {
        this.host = host;
        this.serviceName = serviceName;
        this.port = port;
    }

    public void update(CSGAgentSubject subject) {
        try {
            boolean isAutomatic = true;
            CSGAgentAdminService service = new CSGAgentAdminService();
            String status = service.getServiceStatus(this.serviceName);
            if (!status.equals("AutoMatic")) {
                isAutomatic = false;
            }
            String serverName = service.getPublishedServer(this.serviceName);
            service.unPublishService(this.serviceName, serverName);
            service.publishService(this.serviceName, serverName, isAutomatic);
        }
        catch (CSGException e) {
            this.log.error((Object)("Error while re-publishing the service '" + this.serviceName + "' via " + "received publish notification. You may need to re-publish the service manually!"));
        }
    }

    public String getHostName() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

