/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.heartbeat;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.csg.agent.observer.CSGAgentSubject;
import org.wso2.carbon.cloud.csg.common.CSGUtils;

public class CSGAgentHeartBeatTask
implements Runnable {
    private double reconnectionProgressionFactor;
    private int initialReconnectDuration;
    private String host;
    private int port;
    private CSGAgentSubject subject;
    private Log log = LogFactory.getLog(CSGAgentHeartBeatTask.class);

    public CSGAgentHeartBeatTask(CSGAgentSubject subject, double reconnectionProgressionFactor, int initialReconnectDuration, String remoteHost, int port) {
        this.subject = subject;
        this.reconnectionProgressionFactor = reconnectionProgressionFactor;
        this.initialReconnectDuration = initialReconnectDuration;
        this.host = remoteHost;
        this.port = port;
    }

    public void run() {
        long retryDuration = this.initialReconnectDuration;
        this.log.info((Object)("A heart beat task for the remote server '" + this.host + ":" + this.port + "' has been " + "added"));
        while (true) {
            if (CSGUtils.isServerAlive((String)this.host, (int)this.port)) {
                this.log.info((Object)("Hear beat task detected remote server '" + this.host + ":" + this.port + "', is alive. " + "Observers will be notified"));
                this.subject.connected(this.host, this.port);
                return;
            }
            retryDuration = (long)((double)retryDuration * this.reconnectionProgressionFactor);
            this.log.info((Object)("Remote server '" + this.host + ":" + this.port + "' is not alive. Next re-attempt " + "is after '" + retryDuration / 1000L + "' seconds"));
            try {
                Thread.sleep(retryDuration);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

