/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.csg.common.CSGException;
import org.wso2.carbon.cloud.csg.stub.CSGAdminServiceStub;
import org.wso2.carbon.cloud.csg.stub.types.common.CSGProxyToolsURLs;
import org.wso2.carbon.cloud.csg.stub.types.common.CSGServiceMetaDataBean;
import org.wso2.carbon.cloud.csg.stub.types.common.CSGThriftServerBean;

public class CSGAdminClient {
    private CSGAdminServiceStub stub;
    private static final Log log = LogFactory.getLog(CSGAdminClient.class);

    public CSGAdminClient(String cookie, String backendServerUrl) throws CSGException {
        String serviceURL = backendServerUrl + "CSGAdminService";
        try {
            this.stub = new CSGAdminServiceStub(serviceURL);
        }
        catch (AxisFault axisFault) {
            throw new CSGException((Throwable)axisFault);
        }
        Options options = this.stub._getServiceClient().getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public CSGAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws CSGException {
        String serviceURL = backendServerURL + "CSGAdminService";
        try {
            this.stub = new CSGAdminServiceStub(configCtx, serviceURL);
        }
        catch (AxisFault axisFault) {
            throw new CSGException((Throwable)axisFault);
        }
        Options options = this.stub._getServiceClient().getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public void deployProxy(CSGServiceMetaDataBean serviceMetaData) throws CSGException {
        try {
            this.stub.deployProxy(serviceMetaData);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void unDeployProxy(String serviceName) throws CSGException {
        try {
            this.stub.unDeployProxy(serviceName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public CSGThriftServerBean getThriftServerConnectionBean() throws CSGException {
        try {
            return this.stub.getThriftServerConnectionBean();
        }
        catch (Exception e) {
            throw new CSGException((Throwable)e);
        }
    }

    public void updateProxy(String serviceName, int eventType) throws CSGException {
        try {
            this.stub.updateProxy(serviceName, eventType);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public CSGProxyToolsURLs getPublishedProxyToolsURLs(String serviceName, String domainName) throws CSGException {
        try {
            return this.stub.getPublishedProxyToolsURLs(serviceName, domainName);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(Throwable t) throws CSGException {
        log.error((Object)t);
        throw new CSGException(t);
    }
}

