/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.csg.agent;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.util.SynapseBinaryDataSource;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.cloud.csg.agent.client.AuthenticationClient;
import org.wso2.carbon.cloud.csg.common.CSGException;
import org.wso2.carbon.cloud.csg.common.CSGServerBean;
import org.wso2.carbon.cloud.csg.common.CSGUtils;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;

public class CSGAgentUtils {
    private static Log log = LogFactory.getLog(CSGAgentUtils.class);

    private CSGAgentUtils() {
    }

    public static String getSessionCookie(String serverUrl, String userName, String password, String domainName, String hostName) throws SocketException, RemoteException, LoginAuthenticationExceptionException {
        AuthenticationClient authClient = new AuthenticationClient();
        return authClient.getSessionCookie(serverUrl, userName, password, hostName, domainName);
    }

    public static CSGServerBean getCSGServerBean(org.wso2.carbon.registry.api.Resource resource) throws CSGException {
        CSGServerBean bean = new CSGServerBean();
        try {
            bean.setHost(resource.getProperty("host"));
            bean.setName(resource.getProperty("name"));
            bean.setUserName(resource.getProperty("username"));
            bean.setPort(resource.getProperty("port"));
            bean.setDomainName(resource.getProperty("domain"));
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            String plainPassWord = new String(cryptoUtil.base64DecodeAndDecrypt(resource.getProperty("password")));
            bean.setPassWord(plainPassWord);
            return bean;
        }
        catch (CryptoException e) {
            throw new CSGException("Could not get the CSG server information from the resource: " + resource, (Throwable)e);
        }
    }

    public static void persistServer(Registry registry, CSGServerBean csgServer) throws CSGException {
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        try {
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            Collection collection = registry.newCollection();
            if (!registry.resourceExists("/repository/components/org.wso2.carbon.cloud.csg/")) {
                registry.put("/repository/components/org.wso2.carbon.cloud.csg/", (org.wso2.carbon.registry.api.Resource)collection);
                if (!registry.resourceExists("/repository/components/org.wso2.carbon.cloud.csg/servers")) {
                    registry.put("/repository/components/org.wso2.carbon.cloud.csg/servers", (org.wso2.carbon.registry.api.Resource)collection);
                }
            }
            Resource resource = registry.newResource();
            resource.addProperty("name", csgServer.getName());
            resource.addProperty("host", csgServer.getHost());
            resource.addProperty("username", csgServer.getUserName());
            resource.addProperty("port", csgServer.getPort());
            resource.addProperty("domain", csgServer.getDomainName());
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            resource.addProperty("password", cryptoUtil.encryptAndBase64Encode(csgServer.getPassWord().getBytes()));
            registry.put("/repository/components/org.wso2.carbon.cloud.csg/servers/" + csgServer.getName(), (org.wso2.carbon.registry.api.Resource)resource);
        }
        catch (Exception e) {
            isTransactionSuccess = false;
            throw new CSGException("Error occurred while saving the content into registry", (Throwable)e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException re) {
                    log.error((Object)"Error occurred while trying to rollback or commit the transaction", (Throwable)re);
                }
            }
        }
    }

    public static boolean isClientAxis2XMLExists() {
        File f = new File("repository/conf/axis2/axis2_client.xml");
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMNode getOMElementFromURI(String wsdlURI) throws CSGException {
        URL url;
        if (wsdlURI == null || "null".equals(wsdlURI)) {
            throw new CSGException("Can't create URI from a null value");
        }
        try {
            url = new URL(wsdlURI);
        }
        catch (MalformedURLException e) {
            throw new CSGException("Invalid URI reference '" + wsdlURI + "'", (Throwable)e);
        }
        URLConnection connection = CSGAgentUtils.getURLConnection(url);
        if (connection == null) {
            throw new CSGException("Cannot create a URLConnection for given URL : " + url);
        }
        connection.setReadTimeout(CSGAgentUtils.getReadTimeout());
        connection.setConnectTimeout(CSGAgentUtils.getConnectTimeout());
        connection.setRequestProperty("Connection", "close");
        InputStream inStream = null;
        try {
            inStream = connection.getInputStream();
            StAXOMBuilder builder = new StAXOMBuilder(inStream);
            OMElement doc = builder.getDocumentElement();
            doc.build();
            OMElement oMElement = doc;
            return oMElement;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.info((Object)("Content at URL : " + url + " is non XML.."));
            }
            OMNode oMNode = CSGAgentUtils.readNonXML(url);
            return oMNode;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Error while closing the input stream to: " + url), (Throwable)e);
            }
        }
    }

    private static int getReadTimeout() {
        return Integer.parseInt(CSGUtils.getStringProperty((String)"csg-connection-read-timeout", (String)String.valueOf(100000)));
    }

    private static int getConnectTimeout() {
        return Integer.parseInt(CSGUtils.getStringProperty((String)"csg-connection-connect-timeout", (String)String.valueOf(200000)));
    }

    private static OMNode readNonXML(URL url) throws CSGException {
        try {
            URLConnection newConnection = CSGAgentUtils.getURLConnection(url);
            if (newConnection == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot create a URLConnection for given URL : " + url));
                }
                return null;
            }
            BufferedInputStream newInputStream = new BufferedInputStream(newConnection.getInputStream());
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            return omFactory.createOMText((Object)new DataHandler((DataSource)new SynapseBinaryDataSource((InputStream)newInputStream, newConnection.getContentType())), true);
        }
        catch (IOException e) {
            throw new CSGException("Error when getting a stream from resource's content", (Throwable)e);
        }
    }

    private static URLConnection getURLConnection(URL url) throws CSGException {
        URLConnection connection;
        if (url.getProtocol().equalsIgnoreCase("https")) {
            String msg = "Connecting through doesn't support";
            log.error((Object)msg);
            throw new CSGException(msg);
        }
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw new CSGException("Could not open the URL connection", (Throwable)e);
        }
        connection.setReadTimeout(CSGAgentUtils.getReadTimeout());
        connection.setConnectTimeout(CSGAgentUtils.getConnectTimeout());
        connection.setRequestProperty("Connection", "close");
        return connection;
    }
}

