/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cep.admin.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cep.admin.internal.BucketBasicInfoDTO;
import org.wso2.carbon.cep.admin.internal.BucketDTO;
import org.wso2.carbon.cep.admin.internal.ExpressionDTO;
import org.wso2.carbon.cep.admin.internal.InputDTO;
import org.wso2.carbon.cep.admin.internal.InputTupleMappingDTO;
import org.wso2.carbon.cep.admin.internal.InputXMLMappingDTO;
import org.wso2.carbon.cep.admin.internal.OutputDTO;
import org.wso2.carbon.cep.admin.internal.OutputElementMappingDTO;
import org.wso2.carbon.cep.admin.internal.OutputTupleMappingDTO;
import org.wso2.carbon.cep.admin.internal.OutputXMLMappingDTO;
import org.wso2.carbon.cep.admin.internal.QueryDTO;
import org.wso2.carbon.cep.admin.internal.TuplePropertyDTO;
import org.wso2.carbon.cep.admin.internal.XMLPropertyDTO;
import org.wso2.carbon.cep.admin.internal.XpathDefinitionDTO;
import org.wso2.carbon.cep.admin.internal.config.XMLMappingHelper;
import org.wso2.carbon.cep.admin.internal.exception.CEPAdminException;
import org.wso2.carbon.cep.admin.internal.util.CEPAdminDSHolder;
import org.wso2.carbon.cep.core.Bucket;
import org.wso2.carbon.cep.core.BucketBasicInfo;
import org.wso2.carbon.cep.core.CEPServiceInterface;
import org.wso2.carbon.cep.core.Expression;
import org.wso2.carbon.cep.core.Query;
import org.wso2.carbon.cep.core.XpathDefinition;
import org.wso2.carbon.cep.core.exception.CEPConfigurationException;
import org.wso2.carbon.cep.core.mapping.input.Input;
import org.wso2.carbon.cep.core.mapping.input.mapping.InputMapping;
import org.wso2.carbon.cep.core.mapping.input.mapping.TupleInputMapping;
import org.wso2.carbon.cep.core.mapping.input.mapping.XMLInputMapping;
import org.wso2.carbon.cep.core.mapping.output.Output;
import org.wso2.carbon.cep.core.mapping.output.mapping.ElementOutputMapping;
import org.wso2.carbon.cep.core.mapping.output.mapping.OutputMapping;
import org.wso2.carbon.cep.core.mapping.output.mapping.TupleOutputMapping;
import org.wso2.carbon.cep.core.mapping.output.mapping.XMLOutputMapping;
import org.wso2.carbon.cep.core.mapping.property.TupleProperty;
import org.wso2.carbon.cep.core.mapping.property.XMLProperty;
import org.wso2.carbon.core.AbstractAdmin;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CEPAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(CEPAdminService.class);

    public boolean addBucket(BucketDTO bucketDTO) throws CEPAdminException {
        ArrayList<Input> backendInputList = new ArrayList<Input>();
        Bucket backEndBucket = new Bucket();
        QueryDTO[] queryDTOs = bucketDTO.getQueries();
        InputDTO[] inputDTOs = bucketDTO.getInputs();
        if (inputDTOs != null) {
            for (InputDTO inputDTO : inputDTOs) {
                backendInputList.add(this.adaptInput(inputDTO));
            }
        }
        ArrayList<Query> backEndQueryList = new ArrayList<Query>();
        if (queryDTOs != null) {
            int queryIndex = 0;
            for (QueryDTO queryDTO : queryDTOs) {
                Query query = this.adaptQuery(queryDTO);
                query.setQueryIndex(queryIndex);
                backEndQueryList.add(query);
                ++queryIndex;
            }
        }
        backEndBucket.setName(bucketDTO.getName());
        backEndBucket.setDescription(bucketDTO.getDescription());
        backEndBucket.setEngineProvider(bucketDTO.getEngineProvider());
        backEndBucket.setInputs(backendInputList);
        backEndBucket.setQueries(backEndQueryList);
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            cepServiceInterface.addBucket(backEndBucket, this.getAxisConfig());
            return true;
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in Adding bucket to back end ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public boolean editBucket(BucketDTO bucketDTO) throws CEPAdminException {
        try {
            ArrayList<Input> backendInputList = new ArrayList<Input>();
            Bucket backEndBucket = new Bucket();
            QueryDTO[] queryDTOs = bucketDTO.getQueries();
            InputDTO[] inputDTOs = bucketDTO.getInputs();
            if (inputDTOs != null) {
                for (InputDTO inputDTO : inputDTOs) {
                    backendInputList.add(this.adaptInput(inputDTO));
                }
            }
            ArrayList<Query> backEndQueryList = new ArrayList<Query>();
            if (queryDTOs != null) {
                int queryIndex = 0;
                for (QueryDTO queryDTO : queryDTOs) {
                    Query query = this.adaptQuery(queryDTO);
                    query.setQueryIndex(queryIndex);
                    backEndQueryList.add(query);
                    ++queryIndex;
                }
            }
            if (inputDTOs != null || queryDTOs != null) {
                backEndBucket.setName(bucketDTO.getName());
                backEndBucket.setDescription(bucketDTO.getDescription());
                backEndBucket.setEngineProvider(bucketDTO.getEngineProvider());
                backEndBucket.setInputs(backendInputList);
                backEndBucket.setQueries(backEndQueryList);
                CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
                cepServiceInterface.editBucket(backEndBucket);
            }
            return true;
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in editing the bucket";
            if (e.getCause().getMessage().contains("Error during creating rule")) {
                errorMessage = "Error in processing the query ";
            }
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    private Input adaptInput(InputDTO inputDTO) throws CEPAdminException {
        Input backendInput = new Input();
        backendInput.setTopic(inputDTO.getTopic());
        backendInput.setBrokerName(inputDTO.getBrokerName());
        if (inputDTO.getInputXMLMappingDTO() != null) {
            InputXMLMappingDTO inputXMLMappingDTO = inputDTO.getInputXMLMappingDTO();
            backendInput.setInputMapping(this.adaptInputMapping(inputXMLMappingDTO));
        } else if (inputDTO.getInputTupleMappingDTO() != null) {
            InputTupleMappingDTO inputTupleMappingDTO = inputDTO.getInputTupleMappingDTO();
            backendInput.setInputMapping(this.adaptInputMapping(inputTupleMappingDTO));
        }
        return backendInput;
    }

    private InputMapping adaptInputMapping(InputXMLMappingDTO inputXMLMappingDTO) throws CEPAdminException {
        XpathDefinitionDTO[] xpathDefinitionDTOs;
        XMLInputMapping backendInputMapping = new XMLInputMapping();
        XMLPropertyDTO[] XMLPropertyDTOs = inputXMLMappingDTO.getProperties();
        ArrayList<XMLProperty> backendInputPropertyList = new ArrayList<XMLProperty>();
        if (XMLPropertyDTOs != null) {
            for (XMLPropertyDTO inputXMLPropertyDTO : XMLPropertyDTOs) {
                XMLProperty backendInputProperty = new XMLProperty();
                backendInputProperty.setName(inputXMLPropertyDTO.getName());
                backendInputProperty.setXpath(inputXMLPropertyDTO.getXpath());
                backendInputProperty.setType(inputXMLPropertyDTO.getType());
                backendInputProperty.setType(inputXMLPropertyDTO.getType());
                backendInputProperty.setInputProperty(true);
                backendInputPropertyList.add(backendInputProperty);
            }
        }
        if ((xpathDefinitionDTOs = inputXMLMappingDTO.getXpathDefinition()) != null) {
            for (XpathDefinitionDTO xpathDefinitionDTO : xpathDefinitionDTOs) {
                XpathDefinition backEndXpathDefinition = new XpathDefinition();
                backEndXpathDefinition.setNamespace(xpathDefinitionDTO.getNamespace());
                backEndXpathDefinition.setPrefix(xpathDefinitionDTO.getPrefix());
                backendInputMapping.addXpathDefinition(backEndXpathDefinition);
            }
        }
        backendInputMapping.setStream(inputXMLMappingDTO.getStream());
        try {
            String mappingClassName = inputXMLMappingDTO.getMappingClass();
            Class mappingClass = mappingClassName == null || mappingClassName.equals("") || mappingClassName.toLowerCase().equals("map") ? Map.class : Class.forName(inputXMLMappingDTO.getMappingClass());
            backendInputMapping.setMappingClass(mappingClass);
        }
        catch (ClassNotFoundException e) {
            String errorMessage = "No class found matching " + inputXMLMappingDTO.getMappingClass();
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
        backendInputMapping.setProperties(backendInputPropertyList);
        return backendInputMapping;
    }

    private InputMapping adaptInputMapping(InputTupleMappingDTO inputTupleMappingDTO) throws CEPAdminException {
        TupleInputMapping backendInputMapping = new TupleInputMapping();
        TuplePropertyDTO[] tuplePropertyDTOs = inputTupleMappingDTO.getProperties();
        ArrayList<TupleProperty> backendInputPropertyList = new ArrayList<TupleProperty>();
        if (tuplePropertyDTOs != null) {
            for (TuplePropertyDTO tuplePropertyDTO : tuplePropertyDTOs) {
                TupleProperty backendInputProperty = new TupleProperty();
                backendInputProperty.setName(tuplePropertyDTO.getName());
                backendInputProperty.setType(tuplePropertyDTO.getType());
                backendInputProperty.setDataType(tuplePropertyDTO.getDataType());
                backendInputProperty.setInputProperty(true);
                backendInputPropertyList.add(backendInputProperty);
            }
        }
        backendInputMapping.setStream(inputTupleMappingDTO.getStream());
        try {
            String mappingClassName = inputTupleMappingDTO.getMappingClass();
            Class mappingClass = mappingClassName == null || mappingClassName.equals("") || mappingClassName.toLowerCase().equals("tuple") ? Map.class : Class.forName(inputTupleMappingDTO.getMappingClass());
            backendInputMapping.setMappingClass(mappingClass);
        }
        catch (ClassNotFoundException e) {
            String errorMessage = "No class found matching " + inputTupleMappingDTO.getMappingClass();
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
        backendInputMapping.setProperties(backendInputPropertyList);
        return backendInputMapping;
    }

    private Query adaptQuery(QueryDTO queryDTO) {
        Query backEndQuery = new Query();
        Expression backEndExpression = new Expression();
        backEndExpression.setType(queryDTO.getExpression().getType());
        backEndExpression.setText(queryDTO.getExpression().getText());
        backEndQuery.setName(queryDTO.getName());
        backEndQuery.setQueryIndex(queryDTO.getQueryIndex());
        backEndQuery.setExpression(backEndExpression);
        if (queryDTO.getOutput() != null) {
            OutputTupleMappingDTO outputTupleMappingDTO;
            OutputXMLMappingDTO outputXmlMappingDTO;
            Output backEndOutput = new Output();
            OutputDTO outputDTO = queryDTO.getOutput();
            backEndOutput.setTopic(outputDTO.getTopic());
            backEndOutput.setBrokerName(outputDTO.getBrokerName());
            OutputElementMappingDTO outputElementMappingDTO = outputDTO.getOutputElementMapping();
            if (outputElementMappingDTO != null) {
                ElementOutputMapping backEndElementOutputMapping = null;
                if (outputElementMappingDTO.getDocumentElement() != null && !outputElementMappingDTO.getDocumentElement().equals("")) {
                    XMLPropertyDTO[] XMLPropertyDTOs;
                    backEndElementOutputMapping = new ElementOutputMapping();
                    backEndElementOutputMapping.setDocumentElement(outputElementMappingDTO.getDocumentElement());
                    backEndElementOutputMapping.setNamespace(outputElementMappingDTO.getNamespace());
                    for (XMLPropertyDTO XMLPropertyDTO2 : XMLPropertyDTOs = outputElementMappingDTO.getProperties()) {
                        XMLProperty backEndProperty = new XMLProperty();
                        backEndProperty.setName(XMLPropertyDTO2.getName());
                        backEndProperty.setXmlFieldName(XMLPropertyDTO2.getXmlFieldName());
                        backEndProperty.setXmlFieldType(XMLPropertyDTO2.getXmlFieldType());
                        backEndElementOutputMapping.addProperty(backEndProperty);
                    }
                }
                backEndOutput.setOutputMapping(backEndElementOutputMapping);
            }
            if ((outputXmlMappingDTO = outputDTO.getOutputXmlMapping()) != null) {
                XMLOutputMapping backEndXMLOutputMapping = null;
                if (outputXmlMappingDTO.getMappingXMLText() != null && !outputXmlMappingDTO.getMappingXMLText().equals("")) {
                    backEndXMLOutputMapping = new XMLOutputMapping();
                    backEndXMLOutputMapping.setMappingXMLText(outputXmlMappingDTO.getMappingXMLText());
                }
                backEndOutput.setOutputMapping(backEndXMLOutputMapping);
            }
            if ((outputTupleMappingDTO = outputDTO.getOutputTupleMappingDTO()) != null) {
                TupleOutputMapping backEndTupleOutputMapping = null;
                if (outputTupleMappingDTO.getStreamId() != null) {
                    backEndTupleOutputMapping = new TupleOutputMapping();
                    backEndTupleOutputMapping.setStreamId(outputTupleMappingDTO.getStreamId());
                } else {
                    backEndTupleOutputMapping = new TupleOutputMapping();
                    backEndTupleOutputMapping.setStreamId(outputDTO.getTopic());
                }
                if (outputTupleMappingDTO.getMetaDataProperties() != null && outputTupleMappingDTO.getMetaDataProperties().length != 0) {
                    backEndTupleOutputMapping.setMetaDataProperties(Arrays.asList(outputTupleMappingDTO.getMetaDataProperties()));
                }
                if (outputTupleMappingDTO.getCorrelationDataProperties() != null && outputTupleMappingDTO.getCorrelationDataProperties().length != 0) {
                    backEndTupleOutputMapping.setCorrelationDataProperties(Arrays.asList(outputTupleMappingDTO.getCorrelationDataProperties()));
                }
                if (outputTupleMappingDTO.getPayloadDataProperties() != null && outputTupleMappingDTO.getPayloadDataProperties().length != 0) {
                    backEndTupleOutputMapping.setPayloadDataProperties(Arrays.asList(outputTupleMappingDTO.getPayloadDataProperties()));
                }
                backEndOutput.setOutputMapping((OutputMapping)backEndTupleOutputMapping);
            }
            backEndQuery.setOutput(backEndOutput);
        }
        return backEndQuery;
    }

    private OutputXMLMappingDTO getAdaptedXMLMappingElement(OutputXMLMappingDTO outputXmlMappingDTO) {
        OMElement omElement = null;
        try {
            omElement = AXIOMUtil.stringToOM((String)outputXmlMappingDTO.getMappingXMLText());
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        outputXmlMappingDTO = XMLMappingHelper.fromOM(omElement);
        return outputXmlMappingDTO;
    }

    public BucketBasicInfoDTO[] getAllBucketNames(int startingIndex, int maxBucketCount) throws CEPConfigurationException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        BucketBasicInfoDTO[] bucketBasicInfoDTOArray = null;
        List backEndBucketBasicInfoList = cepServiceInterface.getBucketList();
        int resultSetSize = maxBucketCount;
        if (backEndBucketBasicInfoList.size() - startingIndex < maxBucketCount) {
            resultSetSize = backEndBucketBasicInfoList.size() - startingIndex;
        }
        bucketBasicInfoDTOArray = new BucketBasicInfoDTO[resultSetSize];
        int index = 0;
        int basicInfoIndex = 0;
        for (BucketBasicInfo basicInfo : backEndBucketBasicInfoList) {
            if (startingIndex == index || startingIndex < index) {
                BucketBasicInfoDTO bucketBasicInfoDTO = new BucketBasicInfoDTO();
                bucketBasicInfoDTO.setName(basicInfo.getName());
                bucketBasicInfoDTO.setDescription(basicInfo.getDescription());
                bucketBasicInfoDTOArray[basicInfoIndex] = bucketBasicInfoDTO;
                if (++basicInfoIndex == maxBucketCount) break;
            }
            ++index;
        }
        return bucketBasicInfoDTOArray;
    }

    public int getAllBucketCount() throws CEPConfigurationException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        return cepServiceInterface.getBucketList().size();
    }

    public BucketDTO getBucket(String bucketName) throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        BucketDTO bucketDTO = new BucketDTO();
        Bucket backEndBucket = null;
        try {
            backEndBucket = cepServiceInterface.getBucket(bucketName);
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in getting the bucketDTO ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
        bucketDTO.setName(backEndBucket.getName());
        bucketDTO.setDescription(backEndBucket.getDescription());
        bucketDTO.setEngineProvider(backEndBucket.getEngineProvider());
        bucketDTO.setInputs(this.adaptInput(backEndBucket.getInputs()));
        bucketDTO.setQueries(this.adaptQueries(backEndBucket.getQueries()));
        return bucketDTO;
    }

    private InputDTO[] adaptInput(List<Input> backEndInputList) {
        InputDTO[] inputDTOs = new InputDTO[backEndInputList.size()];
        int i = 0;
        for (Input backEndInput : backEndInputList) {
            InputDTO inputDTO = new InputDTO();
            inputDTO.setTopic(backEndInput.getTopic());
            inputDTO.setBrokerName(backEndInput.getBrokerName());
            if (backEndInput.getInputMapping() instanceof XMLInputMapping) {
                inputDTO.setInputXMLMappingDTO(this.adaptMapping((XMLInputMapping)backEndInput.getInputMapping()));
            } else {
                inputDTO.setInputTupleMappingDTO(this.adaptMapping((TupleInputMapping)backEndInput.getInputMapping()));
            }
            inputDTOs[i] = inputDTO;
            ++i;
        }
        return inputDTOs;
    }

    private InputXMLMappingDTO adaptMapping(XMLInputMapping backEndXMLInputMapping) {
        InputXMLMappingDTO inputXMLMappingDTO = new InputXMLMappingDTO();
        inputXMLMappingDTO.setStream(backEndXMLInputMapping.getStream());
        inputXMLMappingDTO.setProperties(this.adaptProperties(backEndXMLInputMapping.getProperties()));
        inputXMLMappingDTO.setXpathDefinition(this.adaptXpathDefinitions(backEndXMLInputMapping.getXpathNamespacePrefixes()));
        return inputXMLMappingDTO;
    }

    private InputTupleMappingDTO adaptMapping(TupleInputMapping backEndTupleInputMapping) {
        InputTupleMappingDTO inputTupleMappingDTO = new InputTupleMappingDTO();
        inputTupleMappingDTO.setStream(backEndTupleInputMapping.getStream());
        inputTupleMappingDTO.setProperties(this.adaptProperties(backEndTupleInputMapping.getProperties()));
        return inputTupleMappingDTO;
    }

    private XMLPropertyDTO[] adaptProperties(List<XMLProperty> backEndXMLPropertyList) {
        XMLPropertyDTO[] inputXMLPropertyDTOs = new XMLPropertyDTO[backEndXMLPropertyList.size()];
        int i = 0;
        for (XMLProperty backEndInputProperty : backEndXMLPropertyList) {
            XMLPropertyDTO XMLPropertyDTO2 = new XMLPropertyDTO();
            XMLPropertyDTO2.setName(backEndInputProperty.getName());
            XMLPropertyDTO2.setXpath(backEndInputProperty.getXpath());
            XMLPropertyDTO2.setType(backEndInputProperty.getType());
            XMLPropertyDTO2.setInputProperty(backEndInputProperty.isInputProperty());
            inputXMLPropertyDTOs[i] = XMLPropertyDTO2;
            ++i;
        }
        return inputXMLPropertyDTOs;
    }

    private TuplePropertyDTO[] adaptProperties(List<TupleProperty> backEndTuplePropertyList) {
        TuplePropertyDTO[] inputTuplePropertyDTOs = new TuplePropertyDTO[backEndTuplePropertyList.size()];
        int i = 0;
        for (TupleProperty backEndInputProperty : backEndTuplePropertyList) {
            TuplePropertyDTO tuplePropertyDTO = new TuplePropertyDTO();
            tuplePropertyDTO.setName(backEndInputProperty.getName());
            tuplePropertyDTO.setDataType(backEndInputProperty.getDataType());
            tuplePropertyDTO.setType(backEndInputProperty.getType());
            tuplePropertyDTO.setInputProperty(backEndInputProperty.isInputProperty());
            inputTuplePropertyDTOs[i] = tuplePropertyDTO;
            ++i;
        }
        return inputTuplePropertyDTOs;
    }

    private XpathDefinitionDTO[] adaptXpathDefinitions(List<XpathDefinition> backEndXpathDefinitions) {
        XpathDefinitionDTO[] xpathDefinitionDTOs = new XpathDefinitionDTO[backEndXpathDefinitions.size()];
        int i = 0;
        for (XpathDefinition xpathDefinition : backEndXpathDefinitions) {
            XpathDefinitionDTO xpathDefinitionDTO = new XpathDefinitionDTO();
            xpathDefinitionDTO.setPrefix(xpathDefinition.getPrefix());
            xpathDefinitionDTO.setNamespace(xpathDefinition.getNamespace());
            xpathDefinitionDTOs[i] = xpathDefinitionDTO;
            ++i;
        }
        return xpathDefinitionDTOs;
    }

    private QueryDTO[] adaptQueries(List<Query> backEndQueryList) {
        QueryDTO[] queryDTOs = new QueryDTO[backEndQueryList.size()];
        int index = 0;
        for (Query backEndQuery : backEndQueryList) {
            QueryDTO queryDTO = new QueryDTO();
            queryDTO.setName(backEndQuery.getName());
            queryDTO.setQueryIndex(backEndQuery.getQueryIndex());
            if (backEndQuery.getOutput() != null) {
                queryDTO.setOutput(this.adaptOutput(backEndQuery.getOutput()));
            }
            queryDTO.setExpression(this.adaptExpression(backEndQuery.getExpression()));
            queryDTOs[index] = queryDTO;
            ++index;
        }
        return queryDTOs;
    }

    private OutputDTO adaptOutput(Output backEndOutput) {
        OutputDTO outputDTO = new OutputDTO();
        outputDTO.setTopic(backEndOutput.getTopic());
        outputDTO.setBrokerName(backEndOutput.getBrokerName());
        if (backEndOutput.getOutputMapping() instanceof ElementOutputMapping) {
            outputDTO.setOutputElementMapping(this.adaptOutputElementMapping((ElementOutputMapping)backEndOutput.getOutputMapping()));
        } else if (backEndOutput.getOutputMapping() instanceof TupleOutputMapping) {
            outputDTO.setOutputTupleMappingDTO(this.adaptOutputTupleMapping((TupleOutputMapping)backEndOutput.getOutputMapping()));
        } else {
            outputDTO.setOutputXmlMapping(this.adaptOutputXMLMapping((XMLOutputMapping)backEndOutput.getOutputMapping()));
        }
        return outputDTO;
    }

    private OutputElementMappingDTO adaptOutputElementMapping(ElementOutputMapping backEndElementOutputMapping) {
        OutputElementMappingDTO outputElementMappingDTO = null;
        if (backEndElementOutputMapping != null) {
            outputElementMappingDTO = new OutputElementMappingDTO();
            outputElementMappingDTO.setNamespace(backEndElementOutputMapping.getNamespace());
            outputElementMappingDTO.setDocumentElement(backEndElementOutputMapping.getDocumentElement());
            outputElementMappingDTO.setProperties(this.adaptOutputProperties(backEndElementOutputMapping.getProperties()));
        }
        return outputElementMappingDTO;
    }

    private OutputTupleMappingDTO adaptOutputTupleMapping(TupleOutputMapping backEndTupleOutputMapping) {
        OutputTupleMappingDTO outputTupleMappingDTO = null;
        if (backEndTupleOutputMapping != null) {
            outputTupleMappingDTO = new OutputTupleMappingDTO();
            outputTupleMappingDTO.setStreamId(backEndTupleOutputMapping.getStreamId());
            if (backEndTupleOutputMapping.getMetaDataProperties() != null) {
                outputTupleMappingDTO.setMetaDataProperties(backEndTupleOutputMapping.getMetaDataProperties().toArray(new String[backEndTupleOutputMapping.getMetaDataProperties().size()]));
            } else {
                outputTupleMappingDTO.setMetaDataProperties(new String[0]);
            }
            if (backEndTupleOutputMapping.getCorrelationDataProperties() != null) {
                outputTupleMappingDTO.setCorrelationDataProperties(backEndTupleOutputMapping.getCorrelationDataProperties().toArray(new String[backEndTupleOutputMapping.getCorrelationDataProperties().size()]));
            } else {
                outputTupleMappingDTO.setCorrelationDataProperties(new String[0]);
            }
            if (backEndTupleOutputMapping.getPayloadDataProperties() != null) {
                outputTupleMappingDTO.setPayloadDataProperties(backEndTupleOutputMapping.getPayloadDataProperties().toArray(new String[backEndTupleOutputMapping.getPayloadDataProperties().size()]));
            } else {
                outputTupleMappingDTO.setPayloadDataProperties(new String[0]);
            }
        }
        return outputTupleMappingDTO;
    }

    private OutputXMLMappingDTO adaptOutputXMLMapping(XMLOutputMapping backEndXmlOutputMapping) {
        OutputXMLMappingDTO outputXmlMappingDTO = null;
        if (backEndXmlOutputMapping != null && backEndXmlOutputMapping.getMappingXMLText().length() > 0) {
            outputXmlMappingDTO = new OutputXMLMappingDTO();
            String xmlMappingText = backEndXmlOutputMapping.getMappingXMLText();
            outputXmlMappingDTO.setMappingXMLText(xmlMappingText);
        }
        return outputXmlMappingDTO;
    }

    private XMLPropertyDTO[] adaptOutputProperties(List<XMLProperty> backEndPropertyList) {
        XMLPropertyDTO[] XMLPropertyDTOs = new XMLPropertyDTO[backEndPropertyList.size()];
        int i = 0;
        for (XMLProperty backEndProperty : backEndPropertyList) {
            XMLPropertyDTO XMLPropertyDTO2 = new XMLPropertyDTO();
            XMLPropertyDTO2.setName(backEndProperty.getName());
            XMLPropertyDTO2.setXmlFieldName(backEndProperty.getXmlFieldName());
            XMLPropertyDTO2.setXmlFieldType(backEndProperty.getXmlFieldType());
            XMLPropertyDTO2.setInputProperty(backEndProperty.isInputProperty());
            XMLPropertyDTOs[i] = XMLPropertyDTO2;
            ++i;
        }
        return XMLPropertyDTOs;
    }

    private ExpressionDTO adaptExpression(Expression backendExpression) {
        ExpressionDTO expressionDTO = new ExpressionDTO();
        expressionDTO.setText(backendExpression.getText());
        expressionDTO.setType(backendExpression.getType());
        return expressionDTO;
    }

    public boolean removeBucket(String bucketName) throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.removeBucket(bucketName);
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in removing the bucket from back end";
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public boolean removeAllBuckets() throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.removeAllBuckets();
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in removing all buckets from back end ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public String[] getEngineProviders() throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.getCEPEngineProviders();
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in getting engine providers from back end ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public String[] getBrokerNames() throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.getCEPBrokerNames();
        }
        catch (CEPConfigurationException e) {
            throw new CEPAdminException("Error in getting engine providers from back end : " + (Object)((Object)e));
        }
    }

    public boolean removeQuery(String bucketName, String queryName) throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.removeQuery(bucketName, queryName);
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in removing query " + queryName + " from bucket :" + bucketName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public boolean removeAllQueries(String bucketName) throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.removeAllQueries(bucketName);
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in removing all queries from bucket :" + bucketName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public boolean editQuery(String bucketName, QueryDTO queryDTO) throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.editQuery(bucketName, this.adaptQuery(queryDTO));
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in editing the queryDTO :" + queryDTO.getName();
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public QueryDTO[] getAllQueries(String bucketName, int startingIndex, int maxQueryCount) throws CEPAdminException {
        try {
            CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
            QueryDTO[] queriesArray = null;
            List backEndQueryList = cepServiceInterface.getBucket(bucketName).getQueries();
            QueryDTO[] operationsQueryDTOs = null;
            operationsQueryDTOs = this.adaptQueries(backEndQueryList);
            int resultSetSize = maxQueryCount;
            if (backEndQueryList.size() - startingIndex < maxQueryCount) {
                resultSetSize = backEndQueryList.size() - startingIndex;
            }
            queriesArray = new QueryDTO[resultSetSize];
            int index = 0;
            int queryIndex = 0;
            for (QueryDTO queryDTO : operationsQueryDTOs) {
                if (startingIndex == index || startingIndex < index) {
                    queriesArray[queryIndex] = queryDTO;
                    if (++queryIndex == maxQueryCount) break;
                }
                ++index;
            }
            return queriesArray;
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in reading queries from back end ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public int getAllQueryCount(String bucketName) throws CEPAdminException {
        try {
            CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
            Bucket bucket = cepServiceInterface.getBucket(bucketName);
            return bucket.getQueries().size();
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in getting all query count for the bucket :" + bucketName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public InputDTO[] getAllInputs(String bucketName, int startingIndex, int maxQueryCount) throws CEPAdminException {
        try {
            CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
            InputDTO[] inputsArray = null;
            List backEndInputList = cepServiceInterface.getBucket(bucketName).getInputs();
            InputDTO[] operationsInputDTOs = null;
            operationsInputDTOs = this.adaptInput(backEndInputList);
            int resultSetSize = maxQueryCount;
            if (backEndInputList.size() - startingIndex < maxQueryCount) {
                resultSetSize = backEndInputList.size() - startingIndex;
            }
            inputsArray = new InputDTO[resultSetSize];
            int index = 0;
            int inputIndex = 0;
            for (InputDTO inputDTO : operationsInputDTOs) {
                if (startingIndex == index || startingIndex < index) {
                    inputsArray[inputIndex] = inputDTO;
                    if (++inputIndex == maxQueryCount) break;
                }
                ++index;
            }
            return inputsArray;
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in reading inputs from back end ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public int getAllInputCount(String bucketName) throws CEPAdminException {
        try {
            CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
            Bucket bucket = cepServiceInterface.getBucket(bucketName);
            return bucket.getInputs().size();
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in getting all query count for the bucket :" + bucketName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public boolean removeInput(String bucketName, String inputTopic) throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.removeInput(bucketName, inputTopic);
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in removing input " + inputTopic + " from bucket :" + bucketName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }

    public boolean removeAllInputs(String bucketName) throws CEPAdminException {
        CEPServiceInterface cepServiceInterface = CEPAdminDSHolder.getInstance().getCEPService();
        try {
            return cepServiceInterface.removeAllInputs(bucketName);
        }
        catch (CEPConfigurationException e) {
            String errorMessage = "Error in removing all inputs from bucket :" + bucketName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new CEPAdminException(errorMessage, e);
        }
    }
}

