/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.server.internal;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.cassandra.server.CassandraServerComponentManager;
import org.wso2.carbon.cassandra.server.CassandraServerController;
import org.wso2.carbon.cassandra.server.service.CassandraServerService;
import org.wso2.carbon.cassandra.server.service.CassandraServerServiceImpl;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.user.core.service.RealmService;

public class CassandraServerDSComponent {
    private static Log log = LogFactory.getLog(CassandraServerDSComponent.class);
    private static final String CASSANDRA_SERVER_CONF = File.separator + "repository" + File.separator + "conf" + File.separator + "etc" + File.separator + "cassandra.yaml";
    private static final String DEFAULT_CONF = "/org/wso2/carbon/cassandra/server/deployment/cassandra_default.yaml";
    private static final int CASSANDRA_RPC_PORT = 9160;
    private static final int CASSANDRA_STORAGE_PORT = 7000;
    private static final int CASSANDRA_SSL_STORAGE_PORT = 7001;
    private static int CARBON_DEFAULT_PORT_OFFSET = 0;
    private static String CARBON_CONFIG_CASSANDRA_RPC_PORT = "Ports.EmbeddedCassandra.RPCPort";
    private static String CARBON_CONFIG_CASSANDRA_STORAGE_PORT = "Ports.EmbeddedCassandra.StoragePort";
    private static String CARBON_CONFIG_PORT_OFFSET = "Ports.Offset";
    private static String DISABLE_CASSANDRA_SERVER_STARTUP = "disable.cassandra.server.startup";
    private CassandraServerController cassandraServerController;
    private RealmService realmService;
    private AuthenticationService authenticationService;
    private ServerConfigurationService serverConfigurationService;

    protected void activate(ComponentContext componentContext) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting the Cassandra Server component");
            }
            CassandraServerComponentManager.getInstance().init(this.realmService, this.authenticationService, this.serverConfigurationService);
            String cassandraConfLocation = DEFAULT_CONF;
            if (this.isConfigurationExists()) {
                cassandraConfLocation = "file:" + System.getProperty("carbon.home") + CASSANDRA_SERVER_CONF;
            }
            System.setProperty("cassandra.config", cassandraConfLocation);
            System.setProperty("cassandra-foreground", "yes");
            int carbonPortOffset = this.readPortOffset();
            int cassandrRPCPort = 9160 + carbonPortOffset;
            System.setProperty("cassandra.rpc_port", Integer.toString(cassandrRPCPort));
            int cassandraStoragePort = 7000 + carbonPortOffset;
            System.setProperty("cassandra.storage_port", Integer.toString(cassandraStoragePort));
            int cassandraSSLStoragePort = 7001 + carbonPortOffset;
            System.setProperty("cassandra.ssl_storage_port", Integer.toString(cassandraStoragePort));
            this.cassandraServerController = new CassandraServerController();
            CassandraServerServiceImpl cassandraServerService = new CassandraServerServiceImpl(this.cassandraServerController);
            componentContext.getBundleContext().registerService(CassandraServerService.class.getName(), (Object)cassandraServerService, null);
            String disableServerStartup = System.getProperty(DISABLE_CASSANDRA_SERVER_STARTUP);
            if ("true".equals(disableServerStartup)) {
                log.debug((Object)"Cassandra server is not started in service activator");
                return;
            }
            this.cassandraServerController.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping the Cassandra Server component");
        }
        if (this.cassandraServerController != null) {
            this.cassandraServerController.shutdown();
        }
        CassandraServerComponentManager.getInstance().destroy();
    }

    protected void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        this.realmService = null;
    }

    protected void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void unsetAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = null;
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = null;
    }

    private boolean isConfigurationExists() {
        String carbonHome = System.getProperty("carbon.home");
        String path = carbonHome + CASSANDRA_SERVER_CONF;
        if (!new File(path).exists()) {
            log.info((Object)("There is no " + CASSANDRA_SERVER_CONF + ". Using the default configuration"));
            return false;
        }
        return true;
    }

    private int readPortOffset() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String portOffset = carbonConfig.getFirstProperty(CARBON_CONFIG_PORT_OFFSET);
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : CARBON_DEFAULT_PORT_OFFSET;
        }
        catch (NumberFormatException e) {
            return CARBON_DEFAULT_PORT_OFFSET;
        }
    }
}

