/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.server;

import java.util.EnumSet;
import java.util.List;
import org.apache.cassandra.auth.Action;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthority;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.server.CassandraServerComponentManager;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonCassandraAuthority
implements IAuthority {
    private static final Log log = LogFactory.getLog(CarbonCassandraAuthority.class);
    private static final String ACTION_WRITE = "write";
    private static final String ACTION_READ = "read";

    public EnumSet<Permission> authorize(AuthenticatedUser authenticatedUser, List<Object> resource, Action action) {
        if (resource.size() < 2 || !"cassandra".equals(resource.get(0)) || !"keyspaces".equals(resource.get(1))) {
            return Permission.NONE;
        }
        String resourcePath = "/cassandra/keyspaces";
        if (resource.size() != 2) {
            String keyspace;
            if (resource.size() == 3) {
                keyspace = (String)resource.get(2);
                resourcePath = resourcePath + "/" + keyspace;
            } else if (resource.size() == 4) {
                keyspace = (String)resource.get(2);
                String columnFamily = (String)resource.get(3);
                resourcePath = resourcePath + "/" + keyspace + "/" + columnFamily;
            } else {
                String msg = "Do not currently descend any lower in the hierarchy than the column family";
                log.error((Object)msg);
                throw new UnsupportedOperationException(msg);
            }
        }
        try {
            UserRealm userRealm = CassandraServerComponentManager.getInstance().getRealmForTenant(authenticatedUser.domainName);
            UserStoreManager userStoreManager = userRealm.getUserStoreManager();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            String tenantLessUsername = MultitenantUtils.getTenantAwareUsername((String)authenticatedUser.username);
            switch (action) {
                case ADD: {
                    return this.authorizeForAdd(userStoreManager, authorizationManager, tenantLessUsername, resourcePath);
                }
                case UPDATE: {
                    return this.authorizeForWrite(authorizationManager, tenantLessUsername, resourcePath);
                }
                case READ: {
                    return this.authorizeForRead(authorizationManager, tenantLessUsername, resourcePath);
                }
                case DELETE: {
                    return this.authorizeForWrite(authorizationManager, tenantLessUsername, resourcePath);
                }
                case ALL: {
                    return this.authorizeForWrite(authorizationManager, tenantLessUsername, resourcePath);
                }
            }
            log.error((Object)("Undefined action for resource" + resourcePath));
            return Permission.NONE;
        }
        catch (UserStoreException e) {
            log.error((Object)("Error during authorizing a user for a resource" + resourcePath), (Throwable)e);
            return Permission.NONE;
        }
    }

    private EnumSet<Permission> authorizeForWrite(AuthorizationManager authorizationManager, String tenantLessUsername, String resourcePath) {
        try {
            EnumSet<Permission> authorized = EnumSet.noneOf(Permission.class);
            boolean isAuthorized = authorizationManager.isUserAuthorized(tenantLessUsername, resourcePath, ACTION_WRITE);
            if (isAuthorized) {
                authorized.add(Permission.WRITE);
                return authorized;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)("Authorization failure for user " + tenantLessUsername + " for performing write on resource" + resourcePath));
        }
        return Permission.NONE;
    }

    private EnumSet<Permission> authorizeForRead(AuthorizationManager authorizationManager, String tenantLessUsername, String resourcePath) {
        try {
            EnumSet<Permission> authorized = EnumSet.noneOf(Permission.class);
            boolean isAuthorized = authorizationManager.isUserAuthorized(tenantLessUsername, resourcePath, ACTION_READ);
            if (isAuthorized) {
                authorized.add(Permission.READ);
                return authorized;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)("Authorization failure for user " + tenantLessUsername + " for performing read on resource" + resourcePath));
        }
        return Permission.NONE;
    }

    private EnumSet<Permission> authorizeForAdd(UserStoreManager userStoreManager, AuthorizationManager authorizationManager, String tenantLessUsername, String resourcePath) {
        try {
            if (authorizationManager.isUserAuthorized(tenantLessUsername, resourcePath, ACTION_READ) && authorizationManager.isUserAuthorized(tenantLessUsername, resourcePath, ACTION_WRITE)) {
                return Permission.ALL;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)("Authorization failure for user " + tenantLessUsername + " for performing add resource" + resourcePath));
            return Permission.NONE;
        }
        return Permission.NONE;
    }

    public void validateConfiguration() throws ConfigurationException {
    }
}

