/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.gms.GossipDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GossipDigestSerializationHelper {
    private static Logger logger_ = LoggerFactory.getLogger(GossipDigestSerializationHelper.class);

    GossipDigestSerializationHelper() {
    }

    static void serialize(List<GossipDigest> gDigestList, DataOutput dos, int version) throws IOException {
        dos.writeInt(gDigestList.size());
        for (GossipDigest gDigest : gDigestList) {
            GossipDigest.serializer().serialize(gDigest, dos, version);
        }
    }

    static List<GossipDigest> deserialize(DataInput dis, int version) throws IOException {
        int size = dis.readInt();
        ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>(size);
        for (int i = 0; i < size; ++i) {
            gDigests.add(GossipDigest.serializer().deserialize(dis, version));
        }
        return gDigests;
    }
}

