/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.SSTableSliceIterator;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryFilter
implements IFilter {
    private static Logger logger = LoggerFactory.getLogger(SliceQueryFilter.class);
    public volatile ByteBuffer start;
    public volatile ByteBuffer finish;
    public final boolean reversed;
    public volatile int count;

    public SliceQueryFilter(ByteBuffer start, ByteBuffer finish, boolean reversed, int count) {
        this.start = start;
        this.finish = finish;
        this.reversed = reversed;
        this.count = count;
    }

    @Override
    public IColumnIterator getMemtableColumnIterator(ColumnFamily cf, DecoratedKey<?> key) {
        return Memtable.getSliceIterator(key, cf, this);
    }

    @Override
    public IColumnIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey<?> key) {
        return new SSTableSliceIterator(sstable, key, this.start, this.finish, this.reversed);
    }

    @Override
    public IColumnIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey<?> key) {
        return new SSTableSliceIterator(sstable, file, key, this.start, this.finish, this.reversed);
    }

    @Override
    public SuperColumn filterSuperColumn(SuperColumn superColumn, int gcBefore) {
        Comparator<ByteBuffer> comparator;
        Iterator<IColumn> subcolumns;
        SuperColumn scFiltered = superColumn.cloneMeShallow();
        if (this.reversed) {
            ArrayList<IColumn> columnsAsList = new ArrayList<IColumn>(superColumn.getSubColumns());
            subcolumns = Lists.reverse(columnsAsList).iterator();
        } else {
            subcolumns = superColumn.getSubColumns().iterator();
        }
        Comparator<ByteBuffer> comparator2 = comparator = this.reversed ? superColumn.getComparator().reverseComparator : superColumn.getComparator();
        while (subcolumns.hasNext()) {
            IColumn column = subcolumns.next();
            if (comparator.compare(column.name(), this.start) < 0) continue;
            subcolumns = Iterators.concat((Iterator)Iterators.singletonIterator((Object)column), subcolumns);
            break;
        }
        this.collectReducedColumns(scFiltered, subcolumns, gcBefore);
        return scFiltered;
    }

    @Override
    public Comparator<IColumn> getColumnComparator(AbstractType<?> comparator) {
        return this.reversed ? comparator.columnReverseComparator : comparator.columnComparator;
    }

    @Override
    public void collectReducedColumns(IColumnContainer container, Iterator<IColumn> reducedColumns, int gcBefore) {
        int liveColumns = 0;
        AbstractType<?> comparator = container.getComparator();
        while (reducedColumns.hasNext() && liveColumns < this.count) {
            IColumn column = reducedColumns.next();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("collecting %s of %s: %s", liveColumns, this.count, column.getString(comparator)));
            }
            if (this.finish.remaining() > 0 && !this.reversed && comparator.compare(column.name(), this.finish) > 0 || this.reversed && comparator.compare(column.name(), this.finish) < 0) break;
            if (column.isLive() && (!container.isMarkedForDelete() || column.mostRecentLiveChangeAt() > container.getMarkedForDeleteAt())) {
                ++liveColumns;
            }
            if (!QueryFilter.isRelevant(column, container, gcBefore)) continue;
            container.addColumn(column);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "start=" + this.start + ", finish=" + this.finish + ", reversed=" + this.reversed + ", count=" + this.count + "]";
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void updateColumnsLimit(int newLimit) {
        this.count = newLimit;
    }
}

