/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.UpdateStatement;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.ThriftValidation;

public class DeleteStatement
extends ModificationStatement {
    private CFDefinition cfDef;
    private final List<ColumnIdentifier> columns;
    private final List<Relation> whereClause;
    private final Map<ColumnIdentifier, List<Term>> processedKeys = new HashMap<ColumnIdentifier, List<Term>>();

    public DeleteStatement(CFName name, List<ColumnIdentifier> columns, List<Relation> whereClause, Attributes attrs) {
        super(name, attrs);
        this.columns = columns;
        this.whereClause = whereClause;
    }

    @Override
    public List<IMutation> getMutations(ClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException {
        List<Term> keys = this.processedKeys.get(this.cfDef.key.name);
        if (keys == null || keys.isEmpty()) {
            throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", this.cfDef.key.name));
        }
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        CFDefinition.Name firstEmpty = null;
        for (CFDefinition.Name name : this.cfDef.columns.values()) {
            List<Term> values = this.processedKeys.get(name.name);
            if (values == null || values.isEmpty()) {
                firstEmpty = name;
                if (!this.cfDef.isComposite || this.cfDef.isCompact || builder.componentCount() == 0) continue;
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (firstEmpty != null) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s since %s is set", firstEmpty, name));
            }
            assert (values.size() == 1);
            builder.add(values.get(0), Relation.Type.EQ, variables);
        }
        ArrayList<IMutation> rowMutations = new ArrayList<IMutation>();
        for (Term key : keys) {
            ByteBuffer rawKey = key.getByteBuffer(this.cfDef.key.type, variables);
            rowMutations.add(this.mutationForKey(this.cfDef, clientState, rawKey, builder, variables));
        }
        return rowMutations;
    }

    public RowMutation mutationForKey(CFDefinition cfDef, ClientState clientState, ByteBuffer key, ColumnNameBuilder builder, List<ByteBuffer> variables) throws InvalidRequestException {
        QueryProcessor.validateKey(key);
        RowMutation rm = new RowMutation(cfDef.cfm.ksName, key);
        if (this.columns.isEmpty() && builder.componentCount() == 0) {
            rm.delete(new QueryPath(this.columnFamily()), this.getTimestamp(clientState));
        } else {
            for (ColumnIdentifier column : this.columns) {
                CFDefinition.Name name = cfDef.get(column);
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", column));
                }
                if (name.kind == CFDefinition.Name.Kind.COLUMN_METADATA || name.kind == CFDefinition.Name.Kind.VALUE_ALIAS) continue;
                throw new InvalidRequestException(String.format("Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", column));
            }
            if (cfDef.isCompact) {
                ByteBuffer columnName = builder.build();
                QueryProcessor.validateColumnName(columnName);
                rm.delete(new QueryPath(this.columnFamily(), null, columnName), this.getTimestamp(clientState));
            } else {
                Iterator<ColumnIdentifier> iter = this.columns.iterator();
                while (iter.hasNext()) {
                    ColumnIdentifier column;
                    column = iter.next();
                    ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                    ByteBuffer columnName = b.add(column.key).build();
                    QueryProcessor.validateColumnName(columnName);
                    rm.delete(new QueryPath(this.columnFamily(), null, columnName), this.getTimestamp(clientState));
                }
            }
        }
        return rm;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        this.cfDef = metadata.getCfDef();
        AbstractType[] types = new AbstractType[this.getBoundsTerms()];
        UpdateStatement.processKeys(this.cfDef, this.whereClause, this.processedKeys, types);
        return new ParsedStatement.Prepared(this, Arrays.asList(types));
    }

    public String toString() {
        return String.format("DeleteStatement(name=%s, columns=%s, consistency=%s keys=%s)", new Object[]{this.cfName, this.columns, this.cLevel, this.whereClause});
    }
}

