/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RowCacheKey
implements CacheKey,
Comparable<RowCacheKey> {
    public final int cfId;
    public final ByteBuffer key;

    public RowCacheKey(int cfId, DecoratedKey key) {
        this.cfId = cfId;
        this.key = key.key;
    }

    @Override
    public ByteBuffer serializeForStorage() {
        ByteBuffer bytes = ByteBuffer.allocate(this.serializedSize());
        bytes.put(this.key.slice());
        bytes.rewind();
        return bytes;
    }

    @Override
    public Pair<String, String> getPathInfo() {
        return Schema.instance.getCF(this.cfId);
    }

    @Override
    public int serializedSize() {
        return this.key.remaining();
    }

    public int hashCode() {
        return new HashCodeBuilder(131, 56337).append(this.cfId).append((Object)this.key).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowCacheKey otherKey = (RowCacheKey)obj;
        return this.cfId == otherKey.cfId && this.key.equals(otherKey.key);
    }

    @Override
    public int compareTo(RowCacheKey otherKey) {
        return this.cfId < otherKey.cfId ? -1 : (this.cfId == otherKey.cfId ? ByteBufferUtil.compareUnsigned(this.key, otherKey.key) : 1);
    }

    public String toString() {
        return String.format("RowCacheKey(cfId:%d, key:%s)", this.cfId, this.key);
    }
}

